package com.ejianc.business.market.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.market.vo.ResultDetailVO;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 中标结果主实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_market_result_analysis")
public class ResultAnalysisEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 工程编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="org_id")
    private Long orgId; // 所属组织
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="opp_id")
    private Long oppId; // 商机登记id
    @TableField(value="construction_unit")
    private Long constructionUnit; // 建设单位
    @TableField(value="construction_unit_name")
    private String constructionUnitName; // 建设单位名称
    @TableField(value="follow_person")
    private String followPerson; // 跟踪人
    @TableField(value="follow_person_name")
    private String followPersonName; // 跟踪人名称
    @TableField(value="follow_person_phone")
    private String followPersonPhone; // 跟踪人电话
    @TableField(value="info_source")
    private Long infoSource; // 信息来源
    @TableField(value="info_source_name")
    private String infoSourceName; // 信息来源名称
    @TableField(value="estimated_bidding_date")
    private Date estimatedBiddingDate; // 预计招标日期
    @TableField(value="bidding_tax_mny")
    private BigDecimal biddingTaxMny; // 投标价格
    @TableField(value="is_win_info")
    private Integer isWinInfo; // 是否中标 1是0否
    @TableField(value="bidding_sub_tax_mny")
    private BigDecimal biddingSubTaxMny; // 投标差价
    @TableField(value="bidding_avg_tax_mny")
    private BigDecimal biddingAvgTaxMny; // 投标均价
    @TableField(value="engineering_name")
    private String engineeringName; // 工程名称
    @TableField(value="engineering_type")
    private Long engineeringType; // 工程类型
    @TableField(value="engineering_type_name")
    private String engineeringTypeName;// 工程类型名称
    @TableField(value="employee_id")
    private Long employeeId;
    @TableField(value="employee_name")
    private String employeeName;
    @TableField(value="employee_phone")
    private String employeePhone;
    @TableField(value="employee_date")
    private Date employeeDate; // 经办时间
    @TableField(exist=false)
    @SubEntity(serviceName="resultDetailService", pidName = "resultId")
    List<ResultDetailEntity> resultDetailList;
    @TableField(value="actual_tax_mny")
    private BigDecimal actualTaxMny; // 中标价格

    public BigDecimal getActualTaxMny() {
        return actualTaxMny;
    }

    public void setActualTaxMny(BigDecimal actualTaxMny) {
        this.actualTaxMny = actualTaxMny;
    }

    public Integer getIsWinInfo() {
        return isWinInfo;
    }

    public void setIsWinInfo(Integer isWinInfo) {
        this.isWinInfo = isWinInfo;
    }

    public List<ResultDetailEntity> getResultDetailList() {
        return resultDetailList;
    }

    public void setResultDetailList(List<ResultDetailEntity> resultDetailList) {
        this.resultDetailList = resultDetailList;
    }

    public Date getEmployeeDate() {
        return employeeDate;
    }

    public void setEmployeeDate(Date employeeDate) {
        this.employeeDate = employeeDate;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getEmployeePhone() {
        return employeePhone;
    }

    public void setEmployeePhone(String employeePhone) {
        this.employeePhone = employeePhone;
    }

    public Long getEngineeringType() {
        return engineeringType;
    }

    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }

    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

    public String getEngineeringName() {
        return engineeringName;
    }

    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getOppId() {
        return oppId;
    }

    public void setOppId(Long oppId) {
        this.oppId = oppId;
    }
    public Long getConstructionUnit() {
        return constructionUnit;
    }

    public void setConstructionUnit(Long constructionUnit) {
        this.constructionUnit = constructionUnit;
    }
    public String getConstructionUnitName() {
        return constructionUnitName;
    }

    public void setConstructionUnitName(String constructionUnitName) {
        this.constructionUnitName = constructionUnitName;
    }
    public String getFollowPerson() {
        return followPerson;
    }

    public void setFollowPerson(String followPerson) {
        this.followPerson = followPerson;
    }
    public String getFollowPersonName() {
        return followPersonName;
    }

    public void setFollowPersonName(String followPersonName) {
        this.followPersonName = followPersonName;
    }
    public String getFollowPersonPhone() {
        return followPersonPhone;
    }

    public void setFollowPersonPhone(String followPersonPhone) {
        this.followPersonPhone = followPersonPhone;
    }
    public Long getInfoSource() {
        return infoSource;
    }

    public void setInfoSource(Long infoSource) {
        this.infoSource = infoSource;
    }
    public String getInfoSourceName() {
        return infoSourceName;
    }

    public void setInfoSourceName(String infoSourceName) {
        this.infoSourceName = infoSourceName;
    }
    public Date getEstimatedBiddingDate() {
        return estimatedBiddingDate;
    }

    public void setEstimatedBiddingDate(Date estimatedBiddingDate) {
        this.estimatedBiddingDate = estimatedBiddingDate;
    }
    public BigDecimal getBiddingTaxMny() {
        return biddingTaxMny;
    }

    public void setBiddingTaxMny(BigDecimal biddingTaxMny) {
        this.biddingTaxMny = biddingTaxMny;
    }
    public BigDecimal getBiddingSubTaxMny() {
        return biddingSubTaxMny;
    }

    public void setBiddingSubTaxMny(BigDecimal biddingSubTaxMny) {
        this.biddingSubTaxMny = biddingSubTaxMny;
    }
    public BigDecimal getBiddingAvgTaxMny() {
        return biddingAvgTaxMny;
    }

    public void setBiddingAvgTaxMny(BigDecimal biddingAvgTaxMny) {
        this.biddingAvgTaxMny = biddingAvgTaxMny;
    }
    
}
