package com.ejianc.business.market.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.market.bean.BusinessOpportunityEntity;
import com.ejianc.business.market.service.IBusinessOpportunityService;
import com.ejianc.business.market.vo.BusinessOpportunityExportVO;
import com.ejianc.business.market.vo.BusinessOpportunityVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author mrsir_wxp
 * @Date 2020/5/12
 * @Description BusinessOpportunityController
 */

@Controller
@RequestMapping("/business/opportunity/")
public class BusinessOpportunityController  implements Serializable {

    private static final long serialVersionUID = 1L;

    @Autowired
    IBusinessOpportunityService iBusinessOpportunityService;
    /**
     * @Author mrsir_wxp
     * @Date 2020/5/12
     * @Description saveOrUpdate 新增或者修改
     * @param businessOpportunityVO
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BusinessOpportunityVO> saveOrUpdate(@RequestBody BusinessOpportunityVO businessOpportunityVO) {
    	BusinessOpportunityEntity entity = BeanMapper.map(businessOpportunityVO, BusinessOpportunityEntity.class);
    	BusinessOpportunityEntity backEntity = iBusinessOpportunityService.insertOrUpdate(entity);
    	BusinessOpportunityVO vo = BeanMapper.map(backEntity, BusinessOpportunityVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    /**
     * @Author mrsir_wxp
     * @Date 2020/5/12
     * @Description saveOrUpdate 查询详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BusinessOpportunityVO> queryDetail(Long id) {
    	BusinessOpportunityEntity entity = iBusinessOpportunityService.queryDetail(id);
    	BusinessOpportunityVO vo = BeanMapper.map(entity, BusinessOpportunityVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Author mrsir_wxp
     * @Date 2020/5/12
     * @Description queryPrint 查询打印详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryPrint", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("BusinessOpportunity",iBusinessOpportunityService.queryDetail(id));
        return CommonResponse.success("查询打印数据成功！",json);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/5/12
     * @Description saveOrUpdate 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BusinessOpportunityEntity>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("address");
        fuzzyFields.add("area");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringTypeName");
        fuzzyFields.add("infoSourceName");
        fuzzyFields.add("followPersonName");
        fuzzyFields.add("constructionUnitName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<BusinessOpportunityEntity> businessOpportunityEntityIPage = iBusinessOpportunityService.queryPage(param, false);
        List<BusinessOpportunityEntity> records = businessOpportunityEntityIPage.getRecords();
        records.forEach(item->{
            if(null != item.getResultState() && item.getResultState() == 1){
                item.setResultStateStr("已中标");
            }else{
                item.setResultStateStr("未中标");
            }
        });
        businessOpportunityEntityIPage.setRecords(records);
        return CommonResponse.success("查询列表数据成功！",businessOpportunityEntityIPage);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/5/20
     * @Description delete 批量删除单据
     * @Param [ids]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BusinessOpportunityVO> vos) {
        iBusinessOpportunityService.removeByIds(vos.stream().map(BusinessOpportunityVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    /**
     * excel导出
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(10000);
        List<BusinessOpportunityExportVO> supplierVos = iBusinessOpportunityService.queryExportList(queryParam);
        supplierVos.forEach(item->{
            if(null != item.getResultState() && item.getResultState() == 1){
                item.setResultStateStr("已中标");
            }else{
                item.setResultStateStr("未中标");
            }
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("business-opportunity-export.xlsx", beans, response);
    }


    /**
     * @Author mrsir_wxp
     * @Date 2020/5/22
     * @Description refer 商机登记列表参照
     *
     * @Param [pageNumber, pageSize, searchText]
     * @Return com.alibaba.fastjson.JSONObject
     */
    @RequestMapping(value = "/refer")
    @ResponseBody
    public CommonResponse<IPage<BusinessOpportunityVO>> refer(@RequestParam(defaultValue = "1") Integer pageNumber,
                            @RequestParam(defaultValue = "10") Integer pageSize,
                            String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("address");
        fuzzyFields.add("area");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringTypeName");
        fuzzyFields.add("infoSourceName");
        fuzzyFields.add("followPersonName");
        fuzzyFields.add("constructionUnitName");
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        queryParam.getOrderMap().put("createTime", QueryParam.DESC);

        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);

        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("project_is_set", new Parameter(QueryParam.EQ, null));

        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("project_is_set", new Parameter(QueryParam.EQ, false));

        c1.getComplexParams().add(c2);
        c1.getComplexParams().add(c3);
        queryParam.getComplexParams().add(c1);

        IPage<BusinessOpportunityEntity> pageData = iBusinessOpportunityService.queryPage(queryParam,false);
        IPage<BusinessOpportunityVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());

        List<BusinessOpportunityVO> businessOpportunityVOS = BeanMapper.mapList(pageData.getRecords(), BusinessOpportunityVO.class);
        businessOpportunityVOS.forEach(item->{
            if(null != item.getResultState() && item.getResultState() == 1){
                item.setResultStateStr("已中标");
            }else{
                item.setResultStateStr("未中标");
            }
        });
        result.setRecords(businessOpportunityVOS);
        return CommonResponse.success("参照查询成功！", result);
    }

    @RequestMapping(value = "/referOpp")
    @ResponseBody
    public CommonResponse<IPage<BusinessOpportunityVO>> referOpp(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                              @RequestParam(defaultValue = "10") Integer pageSize,
                                                              String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("address");
        fuzzyFields.add("area");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringTypeName");
        fuzzyFields.add("infoSourceName");
        fuzzyFields.add("followPersonName");
        fuzzyFields.add("constructionUnitName");
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        queryParam.getOrderMap().put("createTime", QueryParam.DESC);

        IPage<BusinessOpportunityEntity> pageData = iBusinessOpportunityService.queryPage(queryParam,false);
        IPage<BusinessOpportunityVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());

        List<BusinessOpportunityVO> businessOpportunityVOS = BeanMapper.mapList(pageData.getRecords(), BusinessOpportunityVO.class);
        businessOpportunityVOS.forEach(item->{
            if(null != item.getResultState() && item.getResultState() == 1){
                item.setResultStateStr("已中标");
            }else{
                item.setResultStateStr("未中标");
            }
        });
        result.setRecords(businessOpportunityVOS);
        return CommonResponse.success("参照查询成功！", result);
    }

}
