package com.ejianc.business.market.service;

import com.ejianc.business.market.bean.ProjectRegisterEntity;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public interface IProjectRegisterService extends IBaseService<ProjectRegisterEntity> {

    /**
     * 根据主键Id查询项目详情
     *
     * @param id
     * @return
     */
    ProjectRegisterEntity queryById(Long id);

    /**
     * 保存项目信息
     *
     * @param projectRegisterVO
     * @return
     */
    CommonResponse<ProjectRegisterVO> saveProject(ProjectRegisterVO projectRegisterVO);

    /**
     * 统计项目总数、在建项目数和已完工项目数量
     *
     * @param queryParam
     * @return
     */
    Map<String, Integer> countProjectNum(QueryParam queryParam);
    /**
     * 查询行政地区信息
     *
     * @param pid
     * @return
     */
    List<Map> queryAll(Long pid);
    /**
     * 编码重复校验
     *
     * @param project
     * @return
     */
    boolean codeUsedCheck(ProjectRegisterVO project);

    /**
     * 根据条件查询对应的项目Id列表
     *
     * @param queryParam
     * @param queryNewSignedCurYear
     * @return
     */
    List<Long> queryProIdsByProperties(QueryParam queryParam, boolean queryNewSignedCurYear);

    /**
     * 根据项目Id删除对应项目
     *
     * @param projectId
     */
    String delProject(ProjectRegisterEntity entity);

    /**
     * 更改项目状态
     *
     * @param projectRegisterVO
     * @return
     */
    ProjectRegisterVO changeStatus(ProjectRegisterVO projectRegisterVO);

    ProjectRegisterVO getDataByName(String projectName);

    CommonResponse<ProjectRegisterVO> saveContractMny(Long id, BigDecimal contractTaxMny, BigDecimal contractMny,Long contractId);

    CommonResponse<String> updProject(ProjectRegisterVO projectRegisterVO);

    CommonResponse<ProjectRegisterVO> syncProject(ProjectRegisterVO projectRegisterVO);

    CommonResponse<String> updateProjectByBidCost(ProjectRegisterVO projectRegisterVO);
}
