package com.ejianc.business.market.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.market.bean.ProjectRegisterEntity;
import com.ejianc.business.market.mapper.ProjectRegisterMapper;
import com.ejianc.business.market.service.IProjectRegisterService;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.CommonUpdateBillStateService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Service("projectRegisterService")
public class ProjectRegisterServiceImpl extends BaseServiceImpl<ProjectRegisterMapper, ProjectRegisterEntity> implements IProjectRegisterService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String DEFAULT_RULE_CODE = "marketProjectRegister";

    @Autowired
    private ProjectRegisterMapper projectRegisterMapper;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private CommonUpdateBillStateService commonUpdateBillStateService;

    @Override
    public ProjectRegisterEntity queryById(Long id) {
        return projectRegisterMapper.selectById(id);
    }

    @Override
    public CommonResponse<ProjectRegisterVO> saveProject(ProjectRegisterVO projectRegisterVO) {

        projectRegisterVO.setName(projectRegisterVO.getName().replaceAll(" ", ""));

        LambdaQueryWrapper<ProjectRegisterEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ProjectRegisterEntity::getTenantId, InvocationInfoProxy.getTenantid());
        queryWrapper.eq(ProjectRegisterEntity::getName, projectRegisterVO.getName());
        if(null != projectRegisterVO.getId()){
            queryWrapper.ne(ProjectRegisterEntity::getId, projectRegisterVO.getId());
        }
        int count = this.count(queryWrapper);
        if (count > 0) {
            return CommonResponse.error("当前项目名称已使用，请重新输入！");
        }

        if (StringUtils.isNotBlank(projectRegisterVO.getCode())) {
            projectRegisterVO.setCode(projectRegisterVO.getCode().replaceAll(" ", ""));
            boolean codeCheck = this.codeUsedCheck(projectRegisterVO);
            if (codeCheck) {
                return CommonResponse.error("保存失败，编码重复！");
            }
        }
        if(StringUtils.isBlank(projectRegisterVO.getProjectProperty())){
            projectRegisterVO.setProjectProperty("1");
        }
        if(projectRegisterVO.getId()==null){
            //新增的项目都是执行项目
            projectRegisterVO.setType("2");
            projectRegisterVO.setHasChild(false);
            if(projectRegisterVO.getParentId()!=null){
                //判断父项目是否是父项目，若不是，则修改
                ProjectRegisterEntity pentity = this.queryById(projectRegisterVO.getParentId());
                if(!"1".equals(pentity.getType())){
                    pentity.setType("1");
                    pentity.setHasChild(true);
                    this.saveOrUpdate(pentity, false);
                }
            }
        }

        ProjectRegisterEntity saveEntity = BeanMapper.map(projectRegisterVO, ProjectRegisterEntity.class);
        //处理项目地区，转为省市区
        if(StringUtils.isNotBlank(saveEntity.getArea())){
            String regex = "((?<provinceAndCity>[^市]+市|.*?自治州|.*?区|.*县)(?<town>[^区]+区|.*?市|.*?县|.*?路|.*?街|.*?道|.*?镇|.*?旗)(?<detailAddress>.*))";
            Matcher matcher = Pattern.compile(regex).matcher(saveEntity.getArea());
            while(matcher.find()){
                saveEntity.setRegion(matcher.group("town"));
                String regex2 = "((?<province>[^省]+省|.+自治区|上海市|北京市|天津市|重庆市|上海|北京|天津|重庆|香港特别行政区|澳门特别行政区)(?<city>.*))";
                Matcher matcher2 = Pattern.compile(regex2).matcher(matcher.group("provinceAndCity"));
                while (matcher2.find()){
                    saveEntity.setProvince(matcher2.group("province"));
                    String city = matcher2.group("city");
                    if(StringUtils.isBlank(city)){
                        saveEntity.setCity(saveEntity.getProvince());
                    }else{
                        saveEntity.setCity(matcher2.group("city"));
                    }
                }
            }
        }
        //项目部
        OrgVO projectDepartment = null;
//        BusinessOpportunityEntity buOpr = null;
        boolean storeFlag = false;
        boolean add = false;
        if(null != projectRegisterVO.getId()) {
            ProjectRegisterEntity dbEntity = queryById(projectRegisterVO.getId());
            saveEntity.setTenantId(dbEntity.getTenantId());
            saveEntity.setCreateTime(dbEntity.getCreateTime());
            saveEntity.setCreateUserCode(dbEntity.getCreateUserCode());
            saveEntity.setSyncEsFlag(dbEntity.getSyncEsFlag());
            saveEntity.setDr(dbEntity.getDr());

            if(!projectRegisterVO.getOrgId().equals(dbEntity.getOrgId())) {
                //项目所属组织修改
                projectDepartment = (OrgVO) getRespData(orgApi.getOneById(dbEntity.getProjectDepartmentId()), true, "保存失败，查询所属组织信息失败。");
                projectDepartment.setParentId(projectRegisterVO.getOrgId());
            }
            if(!projectRegisterVO.getName().equals(dbEntity.getName())) {
                if(null == projectDepartment) {
                    projectDepartment = (OrgVO) getRespData(orgApi.getOneById(dbEntity.getProjectDepartmentId()), true, "保存失败，查询所属组织信息失败。");
                }
                projectDepartment.setName(projectRegisterVO.getName());
                projectDepartment.setShortName(projectRegisterVO.getName());
            }

            if(!projectRegisterVO.getStatus().equals(dbEntity.getStatus())) {
                if(null == projectDepartment) {
                    projectDepartment = (OrgVO) getRespData(orgApi.getOneById(dbEntity.getProjectDepartmentId()), true, "保存失败，查询所属组织信息失败。");
                }
            }
        } else {
            storeFlag = true;
            add = true;
            //创建项目部
            projectDepartment = generateProjectDepartment(projectRegisterVO, false);
            saveEntity.setProjectDepartmentId(projectDepartment.getId());
            projectRegisterVO.setProjectDepartmentId(projectDepartment.getId());
            UserContext userContext = sessionManager.getUserContext();

            //项目状态-在建
            //saveEntity.setStatus("2");
        }
        if(StringUtils.isBlank(projectRegisterVO.getCode())) {
            saveEntity.setCode(getAutoCode());
        }
        //保存更新项目部信息
        if(null != projectDepartment) {
            projectDepartment.setSourceId(projectRegisterVO.getSourceId());
            if("2".equals(saveEntity.getStatus())){
                projectDepartment.setProjectState(1);
            }else{
                projectDepartment.setProjectState(2);
            }
//            logger.info("-------------{}",projectDepartment.getProjectState());
            CommonResponse<OrgVO> resp = orgApi.saveOrgInfo(projectDepartment);
            if(!resp.isSuccess()) {
                throw new BusinessException("保存失败，保存项目部信息出错: " + resp.getMsg());
            }
        }

        Map<String, Object> memberMap = getMemberMap(projectRegisterVO);
        if(!memberMap.isEmpty()) {
            //保存新增的成员信息
            CommonResponse<String> resp = employeeApi.manageProjectMembers(memberMap);
            if(!resp.isSuccess()) {
                throw new BusinessException("保存失败，新增成员出错: " + resp.getMsg());
            }
        }
        Map<String, Object> memberUpdateMap = getMemberUpdateMap(projectRegisterVO);
        if(!memberUpdateMap.isEmpty()) {
            //保存新增的成员信息
            CommonResponse<String> resp = employeeApi.manageUpdateProjectMembers(memberUpdateMap);
            if(!resp.isSuccess()) {
                throw new BusinessException("保存失败，新增成员出错: " + resp.getMsg());
            }
        }

        super.saveOrUpdate(saveEntity, false);

        if(!add){
            //更新下游数据
            commonUpdateBillStateService.updateQuoteData(saveEntity.getId(), "BT200519000000002");
        }
        ProjectRegisterVO resp = BeanMapper.map(saveEntity, ProjectRegisterVO.class);
        List<Map<String, Object>> list =(List<Map<String, Object>>) getRespData(userApi.getEmployeeList(resp.getProjectDepartmentId()), false, null);
        for (Map<String,Object> map :list){
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("id",map.get("postId"));
            jsonObj.put("name",map.get("postName"));
            map.put("postId",jsonObj);
        }
        //查询项目成员
        resp.setMembersList(list);
        return CommonResponse.success("保存成功！", resp);
    }

    @Override
    public List<Map> queryAll(Long pid) {
        return baseMapper.queryAll(pid);
    }
    /**
     * 获取自动生成编码变校验重复
     *
     * @return
     */
    private String getAutoCode() {
        ProjectRegisterVO project = new ProjectRegisterVO();

        while (null == project.getCode()) {
            String code = getRespData(billCodeApi.getCodeBatchByRuleCode(DEFAULT_RULE_CODE, InvocationInfoProxy.getTenantid()),
                    true, "保存失败，自动生成编码失败！").toString();
            project.setCode(code);
            boolean checkResult = codeUsedCheck(project);
            if(checkResult) {
                project.setCode(null);
            }
        }

        return project.getCode();
    }

    @Override
    public Map<String, Integer> countProjectNum(QueryParam queryParam) {
        Map<String, Integer> resp = new HashMap<>();
        QueryWrapper<ProjectRegisterEntity> queryWrapper = null;
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        c1.getParams().put("status", new Parameter(QueryParam.EQ, "2"));
        queryParam.getComplexParams().add(c1);
        queryWrapper = changeToQueryWrapper(queryParam);
        resp.put("buildingNum", super.count(queryWrapper));

        queryParam.getComplexParams().remove(c1);
        c1.getParams().put("status", new Parameter(QueryParam.EQ, "3"));
        queryParam.getComplexParams().add(c1);
        queryWrapper = changeToQueryWrapper(queryParam);
        resp.put("finishNum", super.count(queryWrapper));

        return resp;
    }

    @Override
    public boolean codeUsedCheck(ProjectRegisterVO project) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("code", new Parameter(QueryParam.EQ, project.getCode()));
        queryParam.getParams().put("id", new Parameter(QueryParam.NE, project.getId()));

        List<ProjectRegisterEntity> proList = super.queryList(queryParam, false);
        if(CollectionUtils.isNotEmpty(proList)) {
            return true;
        }
        return false;
    }

    @Override
    public List<Long> queryProIdsByProperties(QueryParam queryParam, boolean queryNewSignedCurYear) {
        QueryWrapper<ProjectRegisterEntity> queryWrapper = changeToQueryWrapper(queryParam);
        queryWrapper.select("id");
        queryWrapper.eq("dr", 0);
        queryWrapper.apply(queryNewSignedCurYear, " date_format(sign_date, '%Y') = date_format(now(), '%Y')");

        List<Object> result = baseMapper.selectObjs(queryWrapper);
        List<Long> ids = new ArrayList<>();
        result.forEach(obj -> ids.add(Long.valueOf(obj.toString())));
        return ids;
    }

    /**
     * 生成项目对应的项目部信息
     *
     * @param projectRegisterVO
     * @return
     */
    private OrgVO generateProjectDepartment(ProjectRegisterVO projectRegisterVO, boolean isSyncProject) {
        CommonResponse<OrgVO> response = orgApi.getOneById(projectRegisterVO.getOrgId());
        OrgVO parentOrg = null;
        if(response.isSuccess()) {
            parentOrg = response.getData();
        } else {
            throw new BusinessException("保存项目信息失败，查询项目所属组织信息失败: " + response.getMsg() );
        }
        if(null == parentOrg) {
            throw new BusinessException("保存项目信息失败，项目所属组织信息不存在。");
        }
        OrgVO projectDepartment = new OrgVO();
        projectDepartment.setId(IdWorker.getId());
        projectDepartment.setParentId(projectRegisterVO.getOrgId());
        projectDepartment.setTenantId(parentOrg.getTenantId());
        projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
        projectDepartment.setIsParent(false);
        projectDepartment.setName(projectRegisterVO.getName());
        projectDepartment.setShortName(projectRegisterVO.getName());
        projectDepartment.setSourceId(projectRegisterVO.getSourceId());
        projectDepartment.setState(1);
        //项目部类型
        projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);
        if(isSyncProject) {
            //同步的项目，其对应项目部的sourceId保存项目的sourceId
            projectDepartment.setSourceId(projectRegisterVO.getSourceId());
        }

        return projectDepartment;
    }

    private Object getRespData(CommonResponse resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
    private Map<String, Object> getMemberMap(ProjectRegisterVO projectRegisterVO) {
        Map<String, Object> dataMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(projectRegisterVO.getMembersList())) {
            //保存项目成员
            Map<String, Object> moveMap = new HashMap<>(), parttimeMap = new HashMap<>();

            List<RoleUserRelationVO> relationList = null;
            RoleUserRelationVO tmp = null;
            for(Map<String, Object> member :  projectRegisterVO.getMembersList()) {
                //过滤掉非新增的成员
                if(null != member.get("isAdd") && "true".equals(member.get("isAdd"))) {
                    tmp = new RoleUserRelationVO();
                    tmp.setUserId(null != member.get("userId") ? Long.valueOf(member.get("userId").toString()) : null);
                    tmp.setJobId(null != member.get("jobId") ? Long.valueOf(member.get("jobId").toString()) : null);
                    tmp.setAuthOrgId(projectRegisterVO.getProjectDepartmentId());
                    tmp.setEmployeeId(null != member.get("employeeId") ? Long.valueOf(member.get("employeeId").toString()) : null);
                    tmp.setRoleId(null != member.get("roleId") ? Long.valueOf(member.get("roleId").toString()) : null);
                    if(member.get("postId") != null){
                        JSONObject jsonObject = (JSONObject) JSONObject.toJSON(member.get("postId"));
                        if(jsonObject.get("id") != null){
                            tmp.setPostId(Long.parseLong(jsonObject.get("id").toString()));
                        }
                    }
                    if("move".equals(member.get("type").toString())) {
                        relationList = (List<RoleUserRelationVO>) moveMap.get(tmp.getEmployeeId());
                        if(null == relationList) {
                            relationList = new ArrayList<>();
                        }
                        relationList.add(tmp);
                        moveMap.put(tmp.getEmployeeId().toString(), relationList);
                    } else {
                        relationList = (List<RoleUserRelationVO>) parttimeMap.get(tmp.getEmployeeId());
                        if(null == relationList) {
                            relationList = new ArrayList<>();
                        }
                        relationList.add(tmp);
                        parttimeMap.put(tmp.getEmployeeId().toString(), relationList);
                    }
                }

            }
            if(!moveMap.isEmpty()) {
                Map<String, Object> moveData = new HashMap<>();
                if(moveData.get("postId") != null){
                    JSONObject jsonObject = new JSONObject();
                    jsonObject =(JSONObject) moveMap.get("postId");
                    if(jsonObject.get("id") != null){
                        moveData.put("postId",jsonObject.get("id"));
                    }
                }
                moveData.put("orgId", projectRegisterVO.getProjectDepartmentId());
                moveData.put("detail", moveMap);

                dataMap.put("moveMembers", moveData);
            }
            if(!parttimeMap.isEmpty()) {
                Map<String, Object> parttimeData = new HashMap<>();
                parttimeData.put("orgId", projectRegisterVO.getProjectDepartmentId());
                if(parttimeData.get("postId") != null){
                    JSONObject jsonObject = new JSONObject();
                    jsonObject =(JSONObject) moveMap.get("postId");
                    if(jsonObject.get("id") != null){
                        parttimeData.put("postId",jsonObject.get("id"));
                    }
                }
                parttimeData.put("detail", parttimeMap);

                dataMap.put("parttimeMembers", parttimeData);
            }
        }

        return dataMap;
    }
    private Map<String, Object> getMemberUpdateMap(ProjectRegisterVO projectRegisterVO) {
        Map<String, Object> dataMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(projectRegisterVO.getMembersList())) {
            //保存项目成员
            Map<String, Object> moveMap = new HashMap<>(),
                    parttimeMap = new HashMap<>();

            List<RoleUserRelationVO> relationList = null;
            RoleUserRelationVO tmp = null;
            for(Map<String, Object> member :  projectRegisterVO.getMembersList()) {
                //过滤掉非新增的成员
                if(null != member.get("rowState") && "edit".equals(member.get("rowState"))) {
                    tmp = new RoleUserRelationVO();
                    tmp.setJobId(null != member.get("jobId") ? Long.valueOf(member.get("jobId").toString()) : null);
                    tmp.setEmployeeId(null != member.get("employeeId") ? Long.valueOf(member.get("employeeId").toString()) : null);
                    JSONObject jsonObject = new JSONObject();
                    if(member.get("postId")  != null){
                        jsonObject= (JSONObject) JSONObject.toJSON(member.get("postId"));
                        if(jsonObject.get("id") !=null){
                            tmp.setPostId(Long.parseLong(jsonObject.get("id").toString()));
                        }
                    }

                    relationList = (List<RoleUserRelationVO>) parttimeMap.get(tmp.getEmployeeId());
                    if(null == relationList) {
                        relationList = new ArrayList<>();
                    }
                    relationList.add(tmp);
                    parttimeMap.put(tmp.getEmployeeId().toString(), relationList);
                }
            }

            if(!parttimeMap.isEmpty()) {
                dataMap.put("detail", parttimeMap);
            }
        }

        return dataMap;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public String delProject(ProjectRegisterEntity entity) {
        if(entity.getParentId()!=null){
            //有父级项目--判断是否还有兄弟项目
            QueryWrapper<ProjectRegisterEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("parent_id", entity.getParentId());
            wrapper.ne("id", entity.getId());
            List<ProjectRegisterEntity> plist = this.list(wrapper);
            if(!(plist!=null && plist.size()>0)){
                //没有，处理父级项目的数据
                ProjectRegisterEntity pentity = this.queryById(entity.getParentId());
                pentity.setType("2");
                pentity.setHasChild(false);
                this.saveOrUpdate(pentity, false);
            }
        }
        //删除项目
        super.removeById(entity.getId());
        logger.info("执行项目删部除操作，删除项目部[id-{}]", entity.getProjectDepartmentId());
        //删除对应项目部相关信息
        CommonResponse<String> delResp = orgApi.delByOrgId(entity.getProjectDepartmentId());
        if(!delResp.isSuccess()) {
            logger.error("删除项目[id-{}]对应项目部[id-{}]信息失败，原因：{}", entity.getId(), entity.getProjectDepartmentId(), delResp.getMsg());
            return "项目【"+entity.getName()+"】删除失败，删除对应项目部信息失败;";
        }
        return null;
    }

    @Override
    public ProjectRegisterVO changeStatus(ProjectRegisterVO projectRegisterVO) {
        ProjectRegisterEntity saveEntity = this.selectById(projectRegisterVO.getId());
        saveEntity.setStatus(projectRegisterVO.getStatus());
        OrgVO projectDepartment = (OrgVO) getRespData(orgApi.getOneById(saveEntity.getProjectDepartmentId()), true, "保存失败，查询所属组织信息失败。");
        super.saveOrUpdate(saveEntity, false);
        //保存更新项目部信息
        if(null != projectDepartment) {
            if("2".equals(projectRegisterVO.getStatus())){
                projectDepartment.setProjectState(1);
            }else{
                projectDepartment.setProjectState(2);
            }
            CommonResponse<OrgVO> resp = orgApi.saveOrgInfo(projectDepartment);
            if(!resp.isSuccess()) {
                throw new BusinessException("保存失败，保存项目部信息出错: " + resp.getMsg());
            }
        }
        return BeanMapper.map(saveEntity, ProjectRegisterVO.class);
    }
    @Override
    public ProjectRegisterVO getDataByName(String projectName) {
        QueryWrapper<ProjectRegisterEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("name", projectName);
        wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        List<ProjectRegisterEntity> list = this.list(wrapper);
        if(list!=null && list.size()>0){
            return BeanMapper.map(list.get(0), ProjectRegisterVO.class);
        }
        return null;
    }

    @Override
    public CommonResponse<ProjectRegisterVO> saveContractMny(Long id, BigDecimal contractTaxMny, BigDecimal contractMny,Long contractId) {
        ProjectRegisterEntity saveEntity = this.selectById(id);
        saveEntity.setContractMny(contractMny);
        saveEntity.setContractTaxMny(contractTaxMny);
        saveEntity.setContractId(contractId);
        this.saveOrUpdate(saveEntity, false);
        ProjectRegisterVO vo = BeanMapper.map(saveEntity, ProjectRegisterVO.class);
        return CommonResponse.success(vo);
    }
    @Override
    public CommonResponse<String> updProject(ProjectRegisterVO projectRegisterVO) {
        ProjectRegisterEntity entity = this.selectById(projectRegisterVO.getId());
        if (null == entity){
            throw new BusinessException("该项目不存在！");
        }
        LambdaUpdateWrapper<ProjectRegisterEntity> updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(ProjectRegisterEntity::getId,projectRegisterVO.getId())
                .set(null!=projectRegisterVO.getProjectManager(),ProjectRegisterEntity::getProjectManager,projectRegisterVO.getProjectManager())
                .set(null!=projectRegisterVO.getProjectManagerName(),ProjectRegisterEntity::getProjectManagerName,projectRegisterVO.getProjectManagerName())
                .set(null!=projectRegisterVO.getTechnologyId(),ProjectRegisterEntity::getTechnologyId,projectRegisterVO.getTechnologyId())
                .set(null!=projectRegisterVO.getTechnologyName(),ProjectRegisterEntity::getTechnologyName,projectRegisterVO.getTechnologyName())
                .set(null!=projectRegisterVO.getSecurityId(),ProjectRegisterEntity::getSecurityId,projectRegisterVO.getSecurityId())
                .set(null!=projectRegisterVO.getSecurityName(),ProjectRegisterEntity::getSecurityName,projectRegisterVO.getSecurityName())
                .set(null!=projectRegisterVO.getCostTotal(),ProjectRegisterEntity::getCostTotal,projectRegisterVO.getCostTotal())
                .set(null!=projectRegisterVO.getIncomeArea(),ProjectRegisterEntity::getIncomeArea,projectRegisterVO.getIncomeArea());
        super.update(updateWrapper);
        return CommonResponse.success("更新项目成功");
    }

    @Override
    public CommonResponse<ProjectRegisterVO> syncProject(ProjectRegisterVO projectRegisterVO) {
        QueryWrapper<ProjectRegisterEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("source_id", projectRegisterVO.getSourceId());
        List<ProjectRegisterEntity> list = this.list(wrapper);
        ProjectRegisterEntity entity = null;
        if(list!=null && list.size()>0){
            entity = list.get(0);
        }

        OrgVO projectDepartment = null;
        if(entity==null){
            entity = BeanMapper.map(projectRegisterVO, ProjectRegisterEntity.class);
            //新增的项目都是执行项目
            entity.setType("2");
            entity.setHasChild(false);
            entity.setProjectProperty("1");

            projectDepartment = generateProjectDepartment(projectRegisterVO, false);
            entity.setProjectDepartmentId(projectDepartment.getId());
        }else{
            entity.setName(projectRegisterVO.getName());
            entity.setCode(projectRegisterVO.getCode());
            entity.setProjectType(projectRegisterVO.getProjectType());
            entity.setProjectTypeName(projectRegisterVO.getProjectTypeName());
            entity.setProjectSource(projectRegisterVO.getProjectSource());
            entity.setInternalCooperationProject(projectRegisterVO.getInternalCooperationProject());
            entity.setFirstBusiness(projectRegisterVO.getFirstBusiness());
            entity.setSecondBusiness(projectRegisterVO.getSecondBusiness());
            entity.setProjectOverview(projectRegisterVO.getProjectOverview());
            entity.setAddress(projectRegisterVO.getAddress());
            entity.setIncomeArea(projectRegisterVO.getIncomeArea());
            entity.setContractId(projectRegisterVO.getContractId());
            entity.setSignDate(projectRegisterVO.getSignDate());
            entity.setContractMny(projectRegisterVO.getContractMny());
            entity.setPubUnit(projectRegisterVO.getPubUnit());
            entity.setPubUnitName(projectRegisterVO.getPubUnitName());
            if(!projectRegisterVO.getOrgId().equals(entity.getOrgId())) {
                //项目所属组织修改
                projectDepartment = (OrgVO) getRespData(orgApi.getOneById(entity.getProjectDepartmentId()), true, "保存失败，查询所属组织信息失败。");
                projectDepartment.setParentId(projectRegisterVO.getOrgId());
            }
            if(!projectRegisterVO.getName().equals(entity.getName())) {
                if(null == projectDepartment) {
                    projectDepartment = (OrgVO) getRespData(orgApi.getOneById(entity.getProjectDepartmentId()), true, "保存失败，查询所属组织信息失败。");
                }
                projectDepartment.setName(projectRegisterVO.getName());
                projectDepartment.setShortName(projectRegisterVO.getName());
            }
            entity.setOrgId(projectRegisterVO.getOrgId());
            entity.setOrgName(projectRegisterVO.getOrgName());
            if(!projectRegisterVO.getStatus().equals(entity.getStatus())) {
                if(null == projectDepartment) {
                    projectDepartment = (OrgVO) getRespData(orgApi.getOneById(entity.getProjectDepartmentId()), true, "保存失败，查询所属组织信息失败。");
                }
            }
            entity.setStatus(projectRegisterVO.getStatus());
        }

        //保存更新项目部信息
        if(null != projectDepartment) {
            projectDepartment.setSourceId(projectRegisterVO.getSourceId());
            if(!"0".equals(entity.getStatus())){
                projectDepartment.setProjectState(1);
            }else{
                projectDepartment.setProjectState(2);
            }
            projectDepartment.setState(entity.getStatus()!=null ? Integer.parseInt(entity.getStatus()):0);
//            logger.info("-------------{}",projectDepartment.getProjectState());
            CommonResponse<OrgVO> resp = orgApi.saveOrgInfo(projectDepartment);
            if(!resp.isSuccess()) {
                throw new BusinessException("保存失败，保存项目部信息出错: " + resp.getMsg());
            }
        }
        super.saveOrUpdate(entity, false);

        if(list!=null && list.size()>0){
            //更新下游数据
            commonUpdateBillStateService.updateQuoteData(entity.getId(), "BT200519000000002");
        }
        return CommonResponse.success(BeanMapper.map(entity, ProjectRegisterVO.class));
    }

    @Override
    public CommonResponse<String> updateProjectByBidCost(ProjectRegisterVO projectRegisterVO) {
        QueryWrapper<ProjectRegisterEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("bid_cost_id", projectRegisterVO.getBidCostId());
        wrapper.isNull("parent_id");
        List<ProjectRegisterEntity> list = this.list(wrapper);
        if(list!=null && list.size()>0){
            ProjectRegisterEntity entity = list.get(0);
            String name = projectRegisterVO.getName().replaceAll(" ", "");
            entity.setName(name);
            CommonResponse<OrgVO> response = orgApi.getOneById(projectRegisterVO.getProjectDepartmentId());
            if(response.isSuccess()){
                OrgVO org = response.getData();
                org.setName(name);
                CommonResponse<OrgVO> re = orgApi.saveOrgInfo(org);
                if(!re.isSuccess()){
                    logger.info("修改项目信息失败，修改项目部信息失败。错误信息:{}",response.getMsg());
                    throw new BusinessException("修改项目部信息失败");
                }
            }else{
                logger.info("修改项目信息失败，项目部获取失败。错误信息:{}",response.getMsg());
                throw new BusinessException("修改项目信息失败，项目部获取失败");
            }
            this.saveOrUpdate(entity, false);
        }
        return CommonResponse.success("修改成功");
    }

}
