package com.ejianc.business.material.vo;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author songlx
 * @version 1.0
 * @description: 材料成本统计vo
 * @date 2021-04-07
 */
public class BuyPriceVO {


    /***
     SELECT
     d.material_type_name, d.material_name, d.model , d.unit, 0 total_num,
     0 total_money, 0 contract_price, 0 avg_price, 0 price_area, 0 buy_price
     FROM
     ejc_material_purchase_settlement_material_detail d
     LEFT JOIN ejc_material_purchase_settlement s ON d.pid = s.id
     order by d.create_time desc

     材料分类：通过右侧数据组装成分类。（即需要过滤掉没有产生历史价格的分类）；


     查询方式：默认查询租户下所有已生效的物资合同结算单。通过结算单组合成如下数据；


     开始时间：默认为空，小于截止时间；查大于该时间的物资合同结算单数据；


     截止时间：默认为空，大于开始时间；查小于该时间的物资合同结算单数据；   当开始时间与结束时间为空时，查询租户下所有数据；


     累计采购数量：取该物资的累计结算数量；


     累计采购金额：取该物资的累计结算金额；


     合同价：取该物资结算单对应的合同单价，显示最低价—最高价；


     历史均价：累计采购金额 / 累计采购数量；


     历史价格区间：取该物资结算最低价—最高价；


     最近采购价格：取该物资最新一次采购单价，如有多个，取最低价；
     */
    private Long id;

    private Long tenantId;

    /**
     * 物资分类名称
     */
    private String materialTypeName;

    /**
     * 物资分类id
     */
    private Long materialTypeId;

    /**
     * 物资id
     */
    private Long materialId;

    /**
     * 物资id
     */
    private String materialCode;

    /**
     * 物资名称
     */
    private String materialName;

    /**
     * 规格型号
     */
        private String model;

    /**
     * 计量单位
     */
    private String unit;

    /**
     * 品牌
     */
    private String brandName;

    /**
     * 累计购买数量
     */
    private BigDecimal totalNum;

    /**
     * 累计购买金额
     */
    private BigDecimal totalMoney;

    /**
     * 合同单价低价
     */
    private BigDecimal minContractPrice;

    /**
     * 合同单价高价
     */
    private BigDecimal maxContractPrice;

    /**
     * 均价
     */
    private BigDecimal avgPrice;

    /**
     * 价格区间低价
     */
    private BigDecimal minPriceArea;

    /**
     * 价格区间高价
     */
    private BigDecimal maxPriceArea;

    /**
     * 最近一次采购单价  多个取最低价
     */
    private BigDecimal buyPrice;



    /**
     * 结算日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settlementDate;


    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(BigDecimal totalNum) {
        this.totalNum = totalNum;
    }

    public BigDecimal getTotalMoney() {
        return totalMoney;
    }

    public void setTotalMoney(BigDecimal totalMoney) {
        this.totalMoney = totalMoney;
    }

    public BigDecimal getMinContractPrice() {
        return minContractPrice;
    }

    public void setMinContractPrice(BigDecimal minContractPrice) {
        this.minContractPrice = minContractPrice;
    }

    public BigDecimal getMaxContractPrice() {
        return maxContractPrice;
    }

    public void setMaxContractPrice(BigDecimal maxContractPrice) {
        this.maxContractPrice = maxContractPrice;
    }

    public BigDecimal getAvgPrice() {
        return avgPrice;
    }

    public void setAvgPrice(BigDecimal avgPrice) {
        this.avgPrice = avgPrice;
    }

    public BigDecimal getMinPriceArea() {
        return minPriceArea;
    }

    public void setMinPriceArea(BigDecimal minPriceArea) {
        this.minPriceArea = minPriceArea;
    }

    public BigDecimal getMaxPriceArea() {
        return maxPriceArea;
    }

    public void setMaxPriceArea(BigDecimal maxPriceArea) {
        this.maxPriceArea = maxPriceArea;
    }

    public BigDecimal getBuyPrice() {
        return buyPrice;
    }

    public void setBuyPrice(BigDecimal buyPrice) {
        this.buyPrice = buyPrice;
    }


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getSettlementDate() {
        return settlementDate;
    }

    public void setSettlementDate(Date settlementDate) {
        this.settlementDate = settlementDate;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
}
