package com.ejianc.business.material.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.material.hystrix.MaterialContractHystrix;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.material.vo.MaterialReportVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author CJ
 * @Description: 物资合同API
 * @date 2020/6/23 10:15
 */
@FeignClient(name= "ejc-material-web", url="${common.env.feign-client-url}", path="ejc-material-web", fallback = MaterialContractHystrix.class)
public interface IMaterialContractApi {

    /**
     * 分页查询生效的物资合同列表信息
     *
     * @param queryParam
     * @return
     */
    @PostMapping(value = "/api/materialContract/queryContractList")
    CommonResponse<JSONObject> queryContractList(@RequestBody QueryParam queryParam);

    /**
     * 根据主键查询合同详情，并查询合同中供方、客户信息
     *
     * @param id
     * @return
     */
    @GetMapping("/api/materialContract/queryContractById")
    CommonResponse<JSONObject> queryContractInfoById(@RequestParam(value = "id") Long id);

    /**
     * @Author mrsir_wxp
     * @Date 2021/3/22 根据项目id，查询所属项目合同数量，合同金额累计，结算金额累计
     * @Description queryContractNumAndMoneyAndSettleMoneyByProjectId
     * @Param projectId
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     */
    @GetMapping("/api/materialContract/queryContractNumAndMoneyAndSettleMoneyByProjectId")
    CommonResponse<JSONObject> queryContractNumAndMoneyAndSettleMoneyByProjectId(@RequestParam(value = "projectId") Long projectId);
    /**
     * 查物资合同结算
     *
     * @param projectId
     * @param lastDay
     * @return
     */
    @RequestMapping(value = "/api/materialContract/getMonthMaterialMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MaterialReportVo>> getMonthMaterialMny(@RequestParam(value = "projectId") Long projectId,
                                                                      @RequestParam(value = "lastDay") Integer lastDay);

	/**
	 * 查物资合同数量，金额，结算金额
	 *
	 * @param projectId
	 *
	 * @return
	 */
	@RequestMapping(value = "/api/materialContract/getMaterialContract", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<MaterialReportVo> getMaterialContract(@RequestParam(value = "projectId") Long projectId);

	/**
	 * 按项目维度，获取合同金额(含税)
	 *
	 * @param projectId 项目id
	 *
	 * @return {@link CommonResponse}<{@link BigDecimal}>
	 */
	@GetMapping(value = "/api/materialContract/fetchAmountWithTax")
	CommonResponse<BigDecimal> fetchAmountWithTax(@RequestParam(value = "projectId") Long projectId);


	/**
	 * @description:
	 *
	 * @param enquiryPriceBillIds
	 * @return {@link CommonResponse< List<MaterialContractVO>>}
	 * @author songlx
	 * @date: 2023/2/14
	 */
	@PostMapping(value = "/api/materialContract/getContractByCondition")
	@ResponseBody
	CommonResponse<List<MaterialContractVO>> getContractByCondition(@RequestBody List<Long> enquiryPriceBillIds);

	@GetMapping(value = "/api/materialContract/fetchSjzcje")
	CommonResponse<BigDecimal> fetchSjzcje(@RequestParam(value = "projectId") Long projectId);

}
