package com.ejianc.business.material.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;

/**
 * @Author liyongjia
 * @Date 2020/6/11  采购入库实体
 * @Description InstoreEntity
 */

public class InstoreAccountSumVO extends BaseVO {

	private static final long serialVersionUID = 1L;
	
    /**
     * 所属项目
     */
    private Long projectId;
	
    /**
     * 所属项目名称
     */
    private String projectName;


	/**
	 * 收料入库 + 调拨入库 - 调拨出库
	 */
	private BigDecimal totalAmount;


    /**
     * 入库金额 =  收料入库 + 调拨入库
     */
    private BigDecimal inAmount;

	/**
	 * 出库金额 =  调拨出库
	 */
	private BigDecimal outAmount;

    /**
     * 集采和非集采的结算
     */
    private BigDecimal settleAmount;

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public BigDecimal getTotalAmount() {
		return totalAmount;
	}

	public void setTotalAmount(BigDecimal totalAmount) {
		this.totalAmount = totalAmount;
	}

	public BigDecimal getInAmount() {
		return inAmount;
	}

	public void setInAmount(BigDecimal inAmount) {
		this.inAmount = inAmount;
	}

	public BigDecimal getOutAmount() {
		return outAmount;
	}

	public void setOutAmount(BigDecimal outAmount) {
		this.outAmount = outAmount;
	}

	public BigDecimal getSettleAmount() {
		return settleAmount;
	}

	public void setSettleAmount(BigDecimal settleAmount) {
		this.settleAmount = settleAmount;
	}
}
