package com.ejianc.business.material.api;

import com.ejianc.business.material.hystrix.MaterialSettlementApiHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/24 物资采购结算api
 * @Description IMaterialSettlement
 */
@FeignClient(name= "ejc-material-web", url="${common.env.feign-client-url}", path="ejc-material-web", fallback = MaterialSettlementApiHystrix.class)
public interface IMaterialSettlementApi {
    /**
     * @Author mrsir_wxp
     * @Date 2020/6/24 更新结算单累计已申请金额，其中currentApplyAmount  本期申请金额  可正可负，正为审批通过后调用，负为逆操作调用
     * @Description updateSettlementBillAlreadyApplyAmount
     * @Param settlementBillId  结算单id
     * @Param currentApplyAmount  本期申请金额
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @GetMapping(value = "/api/purchaseSettlement/updateSettlementBillAlreadyApplyAmount")
    CommonResponse<String> updateSettlementBillAlreadyApplyAmount(@RequestParam("settlementBillId") Long settlementBillId,@RequestParam("currentApplyAmount") BigDecimal currentApplyAmount);
    /**
     * @Author mrsir_wxp
     * @Date 2020/6/24 更新结算单累计已付款金额，currentPaidAmount  本期已付款金额  可正可负，正为审批通过后调用，负为逆操作调用
     * @Description updateSettlementBillAlreadyApplyAmount
     * @Param settlementBillId  结算单id
     * @Param currentPaidAmount  本期已付款金额
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @GetMapping(value = "/api/purchaseSettlement/updateSettlementBillAlreadyPaidAmount")
    CommonResponse<String> updateSettlementBillAlreadyPaidAmount(@RequestParam("settlementBillId") Long settlementBillId, @RequestParam("currentPaidAmount") BigDecimal currentPaidAmount);

    /**
     * @Author mrsir_wxp
     * @Date 2020/7/14 根据合同id和组织id查询累计冲抵金额
     * @Description getTotalOffsetAmountByContractIdAndOrgId
     * @Param [contractId, orgId]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.math.BigDecimal>
     */
    @GetMapping(value = "/api/purchaseSettlement/getTotalOffsetAmountByContractIdAndOrgId")
    CommonResponse<BigDecimal> getTotalOffsetAmountByContractIdAndOrgId(@RequestParam("contractId") Long contractId, @RequestParam("orgId") Long orgId);
}
