package com.ejianc.business.material.api;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.ejianc.business.material.hystrix.InstoreHystrix;
import com.ejianc.business.material.vo.InstoreVO;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 入库单的rpc服务
 * 
 * @author liyongjia
 *
 */
@FeignClient(name= "ejc-material-web", url="${common.env.feign-client-url}", path="ejc-material-web", fallback = InstoreHystrix.class)
public interface IInstoreApi {

    /**
     * @Author liyongjia
     * @Date 2020/6/2 查询详情
     * @Description queryDetail
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.InstoreVO>
     */
	@RequestMapping(value = "/api/instore/queryDetail", method=RequestMethod.GET)
	public CommonResponse<InstoreVO> queryDetail(@RequestParam(value = "id")  Long id);

    /**
     * @Author liyongjia
     * @Date 2020/6/10  修改是否付款
     * @Description updatePayment
     * @Param [vos]
     * @Return 
     */
	@RequestMapping(value = "/api/instore/updatePayment", method=RequestMethod.POST)
	public CommonResponse<String> updatePayment(@RequestBody List<InstoreVO> vos);
	
}
