package com.ejianc.business.material.vo;

import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.pub.tax.ITaxCalculate;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
public class InstoreMaterialVO extends BaseVO implements ITaxCalculate {

    private static final long serialVersionUID = 2779265683203439571L;

    /**
	 * 入库日期（冗余主表入库日期，便于出库查询计算）
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private Date instoreDate;

	/**
	 * 仓库id（冗余主表仓库仓库id，便于出库查询计算）
	 */
	private Long storeId;

	/**
	 * 入库库物资库存状态，根据主表billState状态判断
	 * 已提交和已通过的，状态为：STORED(3,"已入库");
	 * 新增和审批中的均为：STORING(2,"入库中"),
	 * 参见com.ejianc.business.material.pub.MaterialStoreState.java
	 */
	private Integer storeState;
    /**
     * 物资分类名称
     */
    private String materialCategoryName;
	
    /**
     * 物资分类id
     */
    private Long materialCategoryId;
	
    /**
     * 物资id
     */
    private Long materialId;
	
    /**
     * 物资名称
     */
    private String materialName;
	
    /**
     * 规格型号
     */
    private String materialSpec;
	
    /**
     * 计量单位
     */
    private String materialUnit;
	
    /**
     * 入库数量
     */
    private BigDecimal instoreNumber;
    /**
     * 入库数量
     */
    private BigDecimal amount;

    /**
     * 库存可用数量(用于实时计算，不存数据库)
     */
    private String canUseNumber;

    /**
     * 单价
     */
    private BigDecimal unitPrice;
    /**
     * 单价(含税)
     */
    private BigDecimal taxUnitPrice;


    /**
     * 金额(含税)
     */
    private BigDecimal taxTotalAmount;
    /**
     * 金额
     */
    private BigDecimal totalAmount;

    /**
     * 税率
     */
    private BigDecimal taxDetailRate;
    /**
     * 税额
     */
    private BigDecimal taxDetail;

    /**
     * 备注
     */
    private String remark;
	
    /**
     * 来源
     */
    private String sourceType;
	
    /**
     * 来源id
     */
    private Long sourceId;

	/**
	 * 数据来源主表id
	 */
	private String sourceMainId;

    /**
     * 主表id
     */
    private Long instoreId;
	
    /**
     * 领料数量---领料退库
     */
    private BigDecimal pickNumber;
	
    /**
     * 导入失败原因
     */
    private String errorMessage;
    
    /**
     * 入库类型（1:收料入库,2:直接入库,3:调拨入库,4:物资退库）
     */
    private Integer instoreType;
	
    /**
     * 库存数量（仓库统计）
     */
    private BigDecimal storeNum;

	
    /**
     * 库存均价（仓库统计）
     */
    private BigDecimal storePrice;

	
    /**
     * 库存金额（仓库统计）
     */
    private BigDecimal storeAmount;

	/**
	 * 成本科目主键
	 */
	private Long subjectId;

	/**
	 * 成本科目名称
	 */
	private String subjectName;

	/**
	 * 税率
	 */
	private BigDecimal taxRate;

	public Date getInstoreDate() {
		return instoreDate;
	}

	public void setInstoreDate(Date instoreDate) {
		this.instoreDate = instoreDate;
	}

	public Long getStoreId() {
		return storeId;
	}

	public void setStoreId(Long storeId) {
		this.storeId = storeId;
	}

	public Integer getStoreState() {
		return storeState;
	}

	public void setStoreState(Integer storeState) {
		this.storeState = storeState;
	}

	public String getMaterialCategoryName() {
		return materialCategoryName;
	}

	public void setMaterialCategoryName(String materialCategoryName) {
		this.materialCategoryName = materialCategoryName;
	}

	public Long getMaterialCategoryId() {
		return materialCategoryId;
	}

	public void setMaterialCategoryId(Long materialCategoryId) {
		this.materialCategoryId = materialCategoryId;
	}

	public Long getMaterialId() {
		return materialId;
	}

	public void setMaterialId(Long materialId) {
		this.materialId = materialId;
	}

	public String getMaterialName() {
		return materialName;
	}

	public void setMaterialName(String materialName) {
		this.materialName = materialName;
	}

	public String getMaterialSpec() {
		return materialSpec;
	}

	public void setMaterialSpec(String materialSpec) {
		this.materialSpec = materialSpec;
	}

	public String getMaterialUnit() {
		return materialUnit;
	}

	public void setMaterialUnit(String materialUnit) {
		this.materialUnit = materialUnit;
	}

	public BigDecimal getInstoreNumber() {
		return instoreNumber;
	}

	public void setInstoreNumber(BigDecimal instoreNumber) {
		this.instoreNumber = instoreNumber;
	}

	public String getCanUseNumber() {
		return canUseNumber;
	}

	public void setCanUseNumber(String canUseNumber) {
		this.canUseNumber = canUseNumber;
	}

	public BigDecimal getUnitPrice() {
		return unitPrice;
	}

	public void setUnitPrice(BigDecimal unitPrice) {
		this.unitPrice = unitPrice;
	}

	public BigDecimal getAmount() {
		return amount;
	}

	public void setAmount(BigDecimal amount) {
		this.amount = amount;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getSourceType() {
		return sourceType;
	}

	public void setSourceType(String sourceType) {
		this.sourceType = sourceType;
	}

	public Long getInstoreId() {
		return instoreId;
	}

	public void setInstoreId(Long instoreId) {
		this.instoreId = instoreId;
	}

	public String getErrorMessage() {
		return errorMessage;
	}

	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}

	public Integer getInstoreType() {
		return instoreType;
	}

	public void setInstoreType(Integer instoreType) {
		this.instoreType = instoreType;
	}

	public BigDecimal getPickNumber() {
		return pickNumber;
	}

	public void setPickNumber(BigDecimal pickNumber) {
		this.pickNumber = pickNumber;
	}

	public Long getSourceId() {
		return sourceId;
	}

	public void setSourceId(Long sourceId) {
		this.sourceId = sourceId;
	}

	public String getSourceMainId() {
		return sourceMainId;
	}

	public void setSourceMainId(String sourceMainId) {
		this.sourceMainId = sourceMainId;
	}

	public BigDecimal getStorePrice() {
		return storePrice;
	}

	public void setStorePrice(BigDecimal storePrice) {
		this.storePrice = storePrice;
	}

	public BigDecimal getStoreAmount() {
		return storeAmount;
	}

	public void setStoreAmount(BigDecimal storeAmount) {
		this.storeAmount = storeAmount;
	}

	public BigDecimal getStoreNum() {
		return storeNum;
	}

	public void setStoreNum(BigDecimal storeNum) {
		this.storeNum = storeNum;
	}

	@ReferSerialTransfer(referCode="cost-subject-set")
	public Long getSubjectId() {
		return subjectId;
	}

	@ReferDeserialTransfer
	public void setSubjectId(Long subjectId) {
		this.subjectId = subjectId;
	}

	public String getSubjectName() {
		return subjectName;
	}

	public void setSubjectName(String subjectName) {
		this.subjectName = subjectName;
	}

	public BigDecimal getTaxRate() {
		return taxRate;
	}

	public void setTaxRate(BigDecimal taxRate) {
		this.taxRate = taxRate;
	}

	public BigDecimal getTaxUnitPrice() {
		return taxUnitPrice;
	}

	public void setTaxUnitPrice(BigDecimal taxUnitPrice) {
		this.taxUnitPrice = taxUnitPrice;
	}

	public BigDecimal getTaxTotalAmount() {
		return taxTotalAmount;
	}

	public void setTaxTotalAmount(BigDecimal taxTotalAmount) {
		this.taxTotalAmount = taxTotalAmount;
	}

	public BigDecimal getTotalAmount() {
		return totalAmount;
	}

	public void setTotalAmount(BigDecimal totalAmount) {
		this.totalAmount = totalAmount;
	}

	public BigDecimal getTaxDetailRate() {
		return taxDetailRate;
	}

	public void setTaxDetailRate(BigDecimal taxDetailRate) {
		this.taxDetailRate = taxDetailRate;
	}

	public BigDecimal getTaxDetail() {
		return taxDetail;
	}

	public void setTaxDetail(BigDecimal taxDetail) {
		this.taxDetail = taxDetail;
	}

	@Override
	public String[] getPriceArray() {

		return new String[]{"unitPrice"};
	}

	@Override
	public String[] getTaxPriceArray() {
		return new String[]{"taxUnitPrice"};
	}

	@Override
	public String[] getNumArray() {
		return new String[]{"instoreNumber"};
	}

	@Override
	public String[] getMoneyArray() {
		return new String[]{"totalAmount"};
	}

	@Override
	public String[] getTaxMoneyArray() {
		return new String[]{"taxTotalAmount"};
	}

	@Override
	public String[] getTaxRateArray() {
		return new String[]{"taxDetailRate"};
	}

	@Override
	public String[] getTaxArray() {
		return new String[]{"taxDetail"};
	}
}
