package com.ejianc.business.material.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 周转材变更记录
 * </p>
 */
public class SupplementContractRecordVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /***
     data.put("baseAmountWithTax", lastRecord.getBaseTaxMoney());
     data.put("changingTaxMny", lastRecord.getChangingTaxMny());
     data.put("changeAmount", lastRecord.getChangingTaxMny().subtract(lastRecord.getAmountWithTax()));
     data.put("changeCount", list.size());
     data.put("totalChangeRate", lastRecord.calculateTotalChangeRatio());
     */

    /**
     * 合同主键
     */
    private Long contractId;

    /**
     * 合同金额（含税）
     */
    private BigDecimal amountWithTax;

    /**
     * 合同金额（不含税）
     */
    private BigDecimal amountWithoutTax;


    /**
     * 变更前合同金额（不含税）
     */
    private BigDecimal beforeChangeMny;
    /**
     * 变更前合同金额（含税）
     */
    private BigDecimal beforeChangeTaxMny;

    /**
     * 初始版本合同金额（含税）
     */
    private BigDecimal baseTaxMoney;

    /**
     * 变更中合同金额（不含税）
     */
    private BigDecimal changingMny;

    private Integer settlementType;

    private Integer changeState;

    /**
     * 组织主键
     */
    private Long orgId;

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }

    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }

    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }

    private List<MaterialSupplementVO> supplementRecord = new ArrayList<>();

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    public List<MaterialSupplementVO> getSupplementRecord() {
        return supplementRecord;
    }

    public void setSupplementRecord(List<MaterialSupplementVO> supplementRecord) {
        this.supplementRecord = supplementRecord;
    }

    public Integer getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(Integer settlementType) {
        this.settlementType = settlementType;
    }
}
