package com.ejianc.business.material.pub;



import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/12  物资出入库类型枚举
 * @Description MaterialStoreType
 */

public enum MaterialStoreType {

    //入库类型
    /** 收料入库 */
    RECEIVE_IN_STORE(1,"收料入库"),
    /** 直接入库 */
    STRAIGHT_IN_STORE(2,"直入直出"),
    /** 调拨入库 */
    ALLOCATION_IN_STORE(3,"调拨入库"),
    /** 领料退库 */
    RETURN_IN_STORE(4,"领料退库"),
    /** 盘盈入库 */
    INVENTORY_PROFIT_IN_STORE(9, "盘点入库"),

    //出库类型
    /** 领料出库 */
    PICKING_OUT_STORE(5,"领料出库"),
    /** 直接出库 */
    STRAIGHT_OUT_STORE(6,"直入直出"),
    /** 调拨出库 */
    ALLOCATION_OUT_STORE(7,"调拨出库"),
    /** 退货出库 （物资从库存取出，退给供应商）*/
    RETURN_GOODS_OUT_STORE(8,"退货出库"),
    /** 盘亏出库 */
    INVENTORY_LOSSES_OUT_STORE(10, "盘点出库");

    private Integer code;

    private String description;

    //构造方法
    private MaterialStoreType(Integer code,String description ){
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    private static Map<Integer, MaterialStoreType> enumMap = new HashMap<>();
    static {
        enumMap = EnumSet.allOf(MaterialStoreType.class).stream().collect(Collectors.toMap(MaterialStoreType::getCode, Function.identity(), (k1, k2) -> k2));
    }
    public static String getStoreTypeNameByCode(Integer code){
        MaterialStoreType type = enumMap.get(code);
        return type==null?null:type.getDescription();
    }
}
