/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.pub;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum MaterialStoreType {
    RECEIVE_IN_STORE(1, "\u6536\u6599\u5165\u5e93"),
    STRAIGHT_IN_STORE(2, "\u76f4\u5165\u76f4\u51fa"),
    ALLOCATION_IN_STORE(3, "\u8c03\u62e8\u5165\u5e93"),
    RETURN_IN_STORE(4, "\u9886\u6599\u9000\u5e93"),
    INVENTORY_PROFIT_IN_STORE(9, "\u76d8\u70b9\u5165\u5e93"),
    PICKING_OUT_STORE(5, "\u9886\u6599\u51fa\u5e93"),
    STRAIGHT_OUT_STORE(6, "\u76f4\u5165\u76f4\u51fa"),
    ALLOCATION_OUT_STORE(7, "\u8c03\u62e8\u51fa\u5e93"),
    RETURN_GOODS_OUT_STORE(8, "\u9000\u8d27\u51fa\u5e93"),
    INVENTORY_LOSSES_OUT_STORE(10, "\u76d8\u70b9\u51fa\u5e93");

    private Integer code;
    private String description;
    private static Map<Integer, MaterialStoreType> enumMap;

    private MaterialStoreType(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static String getStoreTypeNameByCode(Integer code) {
        MaterialStoreType type = enumMap.get(code);
        return type == null ? null : type.getDescription();
    }

    static {
        enumMap = new HashMap<Integer, MaterialStoreType>();
        enumMap = EnumSet.allOf(MaterialStoreType.class).stream().collect(Collectors.toMap(MaterialStoreType::getCode, Function.identity(), (k1, k2) -> k2));
    }
}

