package com.ejianc.business.material.hystrix;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.material.api.IMaterialContractApi;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.material.vo.MaterialReportVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author CJ
 * @Description: 物资合同Hystrix
 * @date 2020/6/23 10:15
 */
@Component
public class MaterialContractHystrix implements IMaterialContractApi {


    @Override
    public CommonResponse<JSONObject> queryContractList(QueryParam queryParam) {
        return CommonResponse.error("网络问题， 查询失败。");
    }

    @Override
    public CommonResponse<JSONObject> queryContractInfoById(Long id) {
        return CommonResponse.error("网络问题， 查询失败。");
    }

    /**
     * @param projectId
     * @Author mrsir_wxp
     * @Date 2021/3/22 根据项目id，查询所属项目合同数量，合同金额累计，结算金额累计
     * @Description queryContractNumAndMoneyAndSettleMoneyByProjectId
     * @Param projectId
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     */
    @Override
    public CommonResponse<JSONObject> queryContractNumAndMoneyAndSettleMoneyByProjectId(Long projectId) {
        return CommonResponse.error("网络问题， 查询失败。");
    }

	@Override
	public CommonResponse<List<MaterialReportVo>> getMonthMaterialMny(Long projectId, Integer lastDay) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<MaterialReportVo> getMaterialContract(Long projectId) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	/**
	 * 按项目维度，获取合同金额(含税)
	 *
	 * @param projectId 项目id
	 *
	 * @return {@link CommonResponse}<{@link BigDecimal}>
	 */
	@Override
	public CommonResponse<BigDecimal> fetchAmountWithTax(Long projectId) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	/**
	 * @description:
	 *
	 * @return {@link CommonResponse< List< MaterialContractVO >>}
	 * @author songlx
	 * @date: 2023/2/14
	 */
	@Override
	public CommonResponse<List<MaterialContractVO>> getContractByCondition(List<Long> enquiryPriceBillIds) {
		return CommonResponse.error("网络问题， 查询失败。");
	}

	@Override
	public CommonResponse<BigDecimal> fetchSjzcje(Long projectId) {
		return CommonResponse.error("网络问题， 查询失败。");
	}
}
