package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/1  用料申请主实体
 * @Description UseApplyEntity
 */

@TableName("ejc_material_apply")
public class UseApplyEntity extends BaseEntity {

    private static final long serialVersionUID = 2779265683203439571L;

    /**
     * 单据状态
     */
    @TableField(value = "bill_state")
    private Integer billState;

    /**
     * 申请单号
     */
    @TableField(value = "bill_code")
    private String billCode;

    /**
     * 申请单名称
     */
    @TableField(value = "name")
    private String name;

    /**
     * 项目名称
     */
    @TableField(value = "project_name")
    private String projectName;

    /**
     * 项目名称参照
     */
    @TableField(value = "project_id")
    private Long projectId;

    /**
     * 组织名称
     */
    @TableField(value = "org_name")
    private String orgName;
    @TableField(value="sporadic_material_flag")
    private Integer sporadicMaterialFlag;//是否零星材料(0:否1:是)
    @TableField(value="purchase_flag")
    private Integer purchaseFlag;//是否已采购(0:否1:是)
    /**
     * 组织参照
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 申请材料种类
     */
    @TableField(value = "material_type_name")
    private String materialTypeName;

    /**
     * 预估金额
     */
    @TableField(value = "estimate_money")
    private BigDecimal estimateMoney;

    /**
     * 计划进场日期
     */
    @TableField(value = "plan_enter_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planEnterDate;

    /**
     * 申请时间
     */
    @TableField(value = "apply_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate;

    /**
     * 申请人
     */
    @TableField(value = "apply_person")
    private String applyPerson;

    /**
     * 备注
     */
    @TableField(value = "memo")
    private String memo;

    /**
     * 收货人
     */
    @TableField(value = "consignee")
    private String consignee;

    /**
     * 收货人电话
     */
    @TableField(value = "consignee_phone")
    private String consigneePhone;

    /**
     * 收货地址
     */
    @TableField(value = "consignee_address")
    private String consigneeAddress;


    @TableField(value="area_id")
    private java.lang.Long areaId; // 区域id
    @TableField(value="area_code")
    private java.lang.String areaCode; // 区域编码
    @TableField(value="area_name")
    private java.lang.String areaName; // 区域名称
    @TableField(value="purchase_type_id")
    private java.lang.Long purchaseTypeId; // 采购类型id
    @TableField(value="purchase_type_code")
    private java.lang.String purchaseTypeCode; // 采购类型编码
    @TableField(value="purchase_type_name")
    private java.lang.String purchaseTypeName; // 采购类型名称
    @TableField(value="is_above")
    private java.lang.Integer isAbove; // 是否超量1是0否

    @TableField(value="is_exceed")
    private java.lang.Integer isExceed; // 是否超量1是0否 （工程云通用）


    @TableField(value="assign_state")
    private Integer assignState; // 分配状态0未分配1已分配
    @TableField(value="purchase_manager_id")
    private Long purchaseManagerId; // 采购负责人
    @TableField(value="purchase_manager_name")
    private String purchaseManagerName; // 采购负责人

    /**
     * 子表
     */
    @TableField(exist = false)
    @SubEntity(serviceName = "useApplySubService")
    private List<UseApplySubEntity> useApplySubEntities = new ArrayList<>();

    public Integer getAssignState() {
        return assignState;
    }

    public void setAssignState(Integer assignState) {
        this.assignState = assignState;
    }

    public Long getPurchaseManagerId() {
        return purchaseManagerId;
    }

    public void setPurchaseManagerId(Long purchaseManagerId) {
        this.purchaseManagerId = purchaseManagerId;
    }

    public String getPurchaseManagerName() {
        return purchaseManagerName;
    }

    public void setPurchaseManagerName(String purchaseManagerName) {
        this.purchaseManagerName = purchaseManagerName;
    }

    public Integer getSporadicMaterialFlag() {
        return sporadicMaterialFlag;
    }

    public void setSporadicMaterialFlag(Integer sporadicMaterialFlag) {
        this.sporadicMaterialFlag = sporadicMaterialFlag;
    }

    public String getConsigneeAddress() {
        return consigneeAddress;
    }

    public void setConsigneeAddress(String consigneeAddress) {
        this.consigneeAddress = consigneeAddress;
    }

    public Long getAreaId() {
        return areaId;
    }

    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public Long getPurchaseTypeId() {
        return purchaseTypeId;
    }

    public void setPurchaseTypeId(Long purchaseTypeId) {
        this.purchaseTypeId = purchaseTypeId;
    }

    public String getPurchaseTypeCode() {
        return purchaseTypeCode;
    }

    public void setPurchaseTypeCode(String purchaseTypeCode) {
        this.purchaseTypeCode = purchaseTypeCode;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public Integer getIsAbove() {
        return isAbove;
    }

    public Integer getPurchaseFlag() {
        return purchaseFlag;
    }

    public void setPurchaseFlag(Integer purchaseFlag) {
        this.purchaseFlag = purchaseFlag;
    }

    public void setIsAbove(Integer isAbove) {
        this.isAbove = isAbove;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public BigDecimal getEstimateMoney() {
        return estimateMoney;
    }

    public void setEstimateMoney(BigDecimal estimateMoney) {
        this.estimateMoney = estimateMoney;
    }

    public Date getPlanEnterDate() {
        return planEnterDate;
    }

    public void setPlanEnterDate(Date planEnterDate) {
        this.planEnterDate = planEnterDate;
    }

    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }

    public String getApplyPerson() {
        return applyPerson;
    }

    public void setApplyPerson(String applyPerson) {
        this.applyPerson = applyPerson;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getConsignee() {
        return consignee;
    }

    public void setConsignee(String consignee) {
        this.consignee = consignee;
    }

    public String getConsigneePhone() {
        return consigneePhone;
    }

    public void setConsigneePhone(String consigneePhone) {
        this.consigneePhone = consigneePhone;
    }

    public Integer getIsExceed() {
        return isExceed;
    }

    public void setIsExceed(Integer isExceed) {
        this.isExceed = isExceed;
    }

    public List<UseApplySubEntity> getUseApplySubEntities() {
        return useApplySubEntities;
    }

    public void setUseApplySubEntities(List<UseApplySubEntity> useApplySubEntities) {
        this.useApplySubEntities = useApplySubEntities;
    }
}
