package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/1  用料申请子实体
 * @Description UseApplySubEntity
 */

@TableName("ejc_material_apply_sub")
public class UseApplySubEntity  extends BaseEntity {

    private static final long serialVersionUID = 2779265683203439571L;

    /**
     * 主表id
     */
    @TableField(value = "pid")
    private Long pid;

    /**
     * 物资分类名称
     */
    @TableField(value = "material_type_name")
    private String materialTypeName;


    /**
     * 物资分类id
     */
    @TableField(value = "material_type_id")
    private Long materialTypeId;

    /**
     * 物资名称
     */
    @TableField(value = "material_name")
    private String materialName;

    /**
     * 物资id
     */
    @TableField(value = "material_id")
    private Long materialId;

    /**
     * 规格型号
     */
    @TableField(value = "model")
    private String model;

    /**
     * 计量单位
     */
    @TableField(value = "unit")
    private String unit;
    /**
     * 部位
     */
    @TableField(value = "part_name")
    private String partName;
    /**
     * 物资批次计划数量
     */
    @TableField(value = "batch_plan_num")
    private BigDecimal batchPlanNum;

    /**
     * 累计申请金额(不含本期)
     */
    @TableField(value = "sum_estimate_mny")
    private BigDecimal sumEstimateMny;
    /**
     * 累计申请金额
     */
    @TableField(value = "this_add_sum_estimate_mny")
    private BigDecimal thisAddSumEstimateMny;
    /**
     * 总计划金额
     */
    @TableField(value = "plan_total_mny")
    private BigDecimal planTotalMny;

    /**
     * 申请数量
     */
    @TableField(value = "apply_num")
    private BigDecimal applyNum;
    /**
     * 部位累计申请量(不含本期)
     */
    @TableField(value = "sum_apply_num_for_part")
    private BigDecimal sumApplyNumForPart;
    /**
     * 部位累计申请量(含本期)
     */
    @TableField(value = "order_num_for_part")
    private BigDecimal orderNumForPart;

    /**
     * 暂估单价
     */
    @TableField(value = "estimate_price")
    private BigDecimal estimatePrice;

    /**
     * 暂估金额
     */
    @TableField(value = "estimate_money")
    private BigDecimal estimateMoney;

    /**
     * 计划进场日期
     */
    @TableField(value = "sub_plan_enter_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date subPlanEnterDate;

    /**
     * 备注
     */
    @TableField(value = "memo")
    private String memo;

    @TableField(value="material_info")
    private java.lang.String materialInfo; // 采购物资名称
    @TableField(value="supplier_id")
    private java.lang.Long supplierId; // 供应商品牌id
    @TableField(value="supplier_name")
    private java.lang.String supplierName; // 供应商品牌
    @TableField(value="model_id")
    private java.lang.Long modelId; // 规格型号id
    @TableField(value="thickness")
    private java.lang.String thickness; // 厚度
    @TableField(value="colour")
    private java.lang.String colour; // 色号/容重

    @TableField(value="order_num")
    private java.math.BigDecimal orderNum; // 订货量
    @TableField(value="plan_num")
    private java.math.BigDecimal planNum; // 进度量
    @TableField(value="total_num")
    private java.math.BigDecimal totalNum; // 总量
    @TableField(value="is_finish")
    private Integer isFinish; // 是否完成1是0否

    @TableField(value="sum_apply_num")
    private java.math.BigDecimal sumApplyNum; // 累计申请量

    @TableField(value="master_plan_num")
    private java.math.BigDecimal masterPlanNum; // 总计划量

    @TableField(value="source_type")
    private String sourceType;//物资来源类型：1-总计划，2-物资档案，3-批次计划，4-导入

    @TableField(value="source_id")
    private Long sourceId;//来源单据Id
    @TableField(exist = false)
    private Integer matchStatus; // 匹配状态：0-未匹配，1-已匹配，2-模糊匹配，
    @TableField(exist = false)
    private String matchStatusDescription;

    @TableField(exist = false)
    private Long applyId; //用料申请参照使用的id
    @TableField(exist = false)
    private String billCode; //用料申请参照使用的code

    /**
     * 物资编码
     */
    @TableField(value = "material_code")
    private String materialCode;

    @TableField(value="auto_file_flag")
    private Integer autoFileFlag;//自动加载文件标识：1-加载，0-不加载

    @TableField(value="store_num")
    private java.math.BigDecimal storeNum; // 库存量

    @TableField(value="task_state")
    private String taskState; // task_state任务状态:待分配unassign已分配assigned已下单order已退回back
    @TableField(value="project_purchase_num")
    private BigDecimal projectPurchaseNum; // 项目自采数量，当taskState为项目自采时需要把applyNum置为0，记录在这个字段走项目零星采购
    @TableField(value="receiver_id")
    private Long receiverId; // 接收人
    @TableField(value="receiver_name")
    private String receiverName; // 接收人
    @TableField(value="last_receiver_id")
    private Long lastReceiverId; // 上次接收人
    @TableField(value="last_receiver_name")
    private String lastReceiverName; // 上次接收人
    @TableField(value="returner_id")
    private Long returnerId; // 退回人
    @TableField(value="returner_name")
    private String returnerName; // 退回人
    @TableField(value="expect_arrive_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date expectArriveDate; // 预计到货日期
    @TableField(value="sum_book_num")
    private BigDecimal sumBookNum; // 累计下单量


    public String getTaskState() {
        return taskState;
    }

    public void setTaskState(String taskState) {
        this.taskState = taskState;
    }

    public BigDecimal getProjectPurchaseNum() {
        return projectPurchaseNum;
    }

    public void setProjectPurchaseNum(BigDecimal projectPurchaseNum) {
        this.projectPurchaseNum = projectPurchaseNum;
    }

    public Long getReceiverId() {
        return receiverId;
    }

    public void setReceiverId(Long receiverId) {
        this.receiverId = receiverId;
    }

    public String getReceiverName() {
        return receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    public Long getLastReceiverId() {
        return lastReceiverId;
    }

    public void setLastReceiverId(Long lastReceiverId) {
        this.lastReceiverId = lastReceiverId;
    }

    public String getLastReceiverName() {
        return lastReceiverName;
    }

    public void setLastReceiverName(String lastReceiverName) {
        this.lastReceiverName = lastReceiverName;
    }

    public Long getReturnerId() {
        return returnerId;
    }

    public void setReturnerId(Long returnerId) {
        this.returnerId = returnerId;
    }

    public String getReturnerName() {
        return returnerName;
    }

    public void setReturnerName(String returnerName) {
        this.returnerName = returnerName;
    }

    public Date getExpectArriveDate() {
        return expectArriveDate;
    }

    public void setExpectArriveDate(Date expectArriveDate) {
        this.expectArriveDate = expectArriveDate;
    }


    public BigDecimal getSumBookNum() {
        return sumBookNum;
    }

    public void setSumBookNum(BigDecimal sumBookNum) {
        this.sumBookNum = sumBookNum;
    }

    public BigDecimal getStoreNum() {
        return storeNum;
    }

    public void setStoreNum(BigDecimal storeNum) {
        this.storeNum = storeNum;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getAutoFileFlag() {
        return autoFileFlag;
    }

    public void setAutoFileFlag(Integer autoFileFlag) {
        this.autoFileFlag = autoFileFlag;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public BigDecimal getMasterPlanNum() {
        return masterPlanNum;
    }

    public void setMasterPlanNum(BigDecimal masterPlanNum) {
        this.masterPlanNum = masterPlanNum;
    }

    public BigDecimal getSumApplyNum() {
        return sumApplyNum;
    }

    public void setSumApplyNum(BigDecimal sumApplyNum) {
        this.sumApplyNum = sumApplyNum;
    }

    public String getMaterialInfo() {
        return materialInfo;
    }

    public void setMaterialInfo(String materialInfo) {
        this.materialInfo = materialInfo;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public String getPartName() {
        return partName;
    }

    public void setPartName(String partName) {
        this.partName = partName;
    }

    public BigDecimal getBatchPlanNum() {
        return batchPlanNum;
    }

    public BigDecimal getSumApplyNumForPart() {
        return sumApplyNumForPart;
    }

    public BigDecimal getSumEstimateMny() {
        return sumEstimateMny;
    }

    public void setSumEstimateMny(BigDecimal sumEstimateMny) {
        this.sumEstimateMny = sumEstimateMny;
    }

    public BigDecimal getThisAddSumEstimateMny() {
        return thisAddSumEstimateMny;
    }

    public void setThisAddSumEstimateMny(BigDecimal thisAddSumEstimateMny) {
        this.thisAddSumEstimateMny = thisAddSumEstimateMny;
    }

    public BigDecimal getPlanTotalMny() {
        return planTotalMny;
    }

    public void setPlanTotalMny(BigDecimal planTotalMny) {
        this.planTotalMny = planTotalMny;
    }

    public void setSumApplyNumForPart(BigDecimal sumApplyNumForPart) {
        this.sumApplyNumForPart = sumApplyNumForPart;
    }

    public BigDecimal getOrderNumForPart() {
        return orderNumForPart;
    }

    public void setOrderNumForPart(BigDecimal orderNumForPart) {
        this.orderNumForPart = orderNumForPart;
    }

    public void setBatchPlanNum(BigDecimal batchPlanNum) {
        this.batchPlanNum = batchPlanNum;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Long getModelId() {
        return modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public String getThickness() {
        return thickness;
    }

    public void setThickness(String thickness) {
        this.thickness = thickness;
    }

    public String getColour() {
        return colour;
    }

    public void setColour(String colour) {
        this.colour = colour;
    }


    public BigDecimal getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(BigDecimal orderNum) {
        this.orderNum = orderNum;
    }

    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }

    public BigDecimal getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(BigDecimal totalNum) {
        this.totalNum = totalNum;
    }

    public Integer getIsFinish() {
        return isFinish;
    }

    public void setIsFinish(Integer isFinish) {
        this.isFinish = isFinish;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getApplyNum() {
        return applyNum;
    }

    public void setApplyNum(BigDecimal applyNum) {
        this.applyNum = applyNum;
    }

    public BigDecimal getEstimatePrice() {
        return estimatePrice;
    }

    public void setEstimatePrice(BigDecimal estimatePrice) {
        this.estimatePrice = estimatePrice;
    }

    public BigDecimal getEstimateMoney() {
        return estimateMoney;
    }

    public void setEstimateMoney(BigDecimal estimateMoney) {
        this.estimateMoney = estimateMoney;
    }

    public Date getSubPlanEnterDate() {
        return subPlanEnterDate;
    }

    public void setSubPlanEnterDate(Date subPlanEnterDate) {
        this.subPlanEnterDate = subPlanEnterDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Integer getMatchStatus() {
        return matchStatus;
    }

    public void setMatchStatus(Integer matchStatus) {
        this.matchStatus = matchStatus;
    }

    public String getMatchStatusDescription() {
        return matchStatusDescription;
    }

    public void setMatchStatusDescription(String matchStatusDescription) {
        this.matchStatusDescription = matchStatusDescription;
    }

    public Long getApplyId() {
        return applyId;
    }

    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }
}
