package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.ProjectFinanceVO;
import com.ejianc.business.material.bean.UseApplyEntity;
import com.ejianc.business.material.bean.UseApplySubEntity;
import com.ejianc.business.material.mapper.InstoreMaterialMapper;
import com.ejianc.business.material.mapper.UseApplyMapper;
import com.ejianc.business.material.mapper.UseApplySubMapper;
import com.ejianc.business.material.service.IOutStoreSubService;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.vo.*;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.bean.MaterialMasterPlanSubEntity;
import com.ejianc.business.plan.mapper.MaterialMasterPlanMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanSubMapper;
import com.ejianc.business.plan.vo.MaterialMasterPlanSubVO;
import com.ejianc.business.utils.BigDecimalUtils;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;


@Service
public class UseApplyService extends BaseServiceImpl<UseApplyMapper, UseApplyEntity> implements IUseApplyService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    public IOutStoreSubService outStoreSubService;

    @Autowired
    public IPayContractApi payContractApi;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private MaterialMasterPlanMapper materialMasterPlanMapper;
    @Autowired
    private MaterialMasterPlanSubMapper materialMasterPlanSubMapper;
    @Autowired
    private UseApplyMapper useApplyMapper;
    @Autowired
    private UseApplySubMapper useApplySubMapper;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;

    @Autowired
    private InstoreMaterialService instoreMaterialService;

    private static String PARAM_PLAN_ALL_COUNT = "P-F8k54925";
    private static String PARAM_PLAN_PRICE = "P-649dG759";//物资总计划单价控制用料申请单价
    private static String PARAM_PROJECT_MNY = "P-w112KG65";//【项目可用资金】控制【用料申请】
    private static String PARAM_COST_MNY = "P-AQ725A75";//【预算零星材料金额】控制【用料申请零星材料金额】
    private static String PARAM_BATCH_PLAN_NUM = "P-q4fR4e66";//【材料批次计划量】控制【用料申请量】

    @Override
    public IPage<UseApplyVO> queryForList(QueryParam queryParam, boolean isEs) {
        IPage<UseApplyVO> voPage = null;
        IPage<UseApplyEntity> entityPage = super.queryPage(queryParam, isEs);
        if (entityPage != null) {
            voPage = new Page<>();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(entityPage.getRecords(), UseApplyVO.class));
        }
        return voPage;
    }


    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }


    @Override
    public ParamsCheckVO checkAllParams(UseApplyVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        List<UseApplySubVO> useApplySubEntities = vo.getUseApplySubEntities();
        String[] paramsArray = {"none", "warn", "alert"};
        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());

        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType(paramsArray[0]);
        if (CollectionUtils.isNotEmpty(useApplySubEntities) && (int) useApplySubEntities.stream().filter(in -> in.getMaterialId() != null).count() > 0) {
            useApplySubEntities = useApplySubEntities.stream().filter(in -> in.getMaterialId() != null).collect(Collectors.toList());

            // 【总计划】控制【项目用料申请】
            CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_ALL_COUNT, curOrgId);
            if (!response.isSuccess()) {
                throw new BusinessException("【总计划】控制【项目用料申请】，获取控制参数失败，失败原因：" + response.getMsg());
            }
            List<BillParamVO> billParamVOS = response.getData();

            if (CollectionUtils.isNotEmpty(billParamVOS)) {

                // 根据项目取得总计划数据
                Long projectId = vo.getProjectId();
                QueryWrapper<MaterialMasterPlanEntity> wrapper = new QueryWrapper<>();
                wrapper.eq("project_id", projectId);
                wrapper.eq("dr", 0);
                List<MaterialMasterPlanEntity> materialMasterPlanEntities = materialMasterPlanMapper.selectList(wrapper);

                QueryWrapper<MaterialMasterPlanSubEntity> planSubWrapper = new QueryWrapper<>();
                List<Long> ids = new ArrayList<>();
                materialMasterPlanEntities.forEach(item -> {
                    ids.add(item.getId());
                });
                // list添加一个数据，防止数据为空时，in查询sql拼接错误。
                ids.add(000001L);
                planSubWrapper.in("material_master_plan_id", ids);
                planSubWrapper.eq("dr", 0);
                List<MaterialMasterPlanSubEntity> materialMasterPlanSubEntities = materialMasterPlanSubMapper.selectList(planSubWrapper);
                Map<Long, BigDecimal> planMap = new HashMap<>();
                materialMasterPlanSubEntities.forEach(item -> {
                    Double num = item.getNum();
                    if (planMap.get(item.getMaterialId()) != null) {
                        planMap.put(item.getMaterialId(), ComputeUtil.safeAdd(BigDecimal.valueOf(num), planMap.get(item.getMaterialId())));
                    } else {
                        planMap.put(item.getMaterialId(), BigDecimal.valueOf(num));
                    }
                });

                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 != billParamVO.getControlType()) {
                        // 管理费率
                        BigDecimal manageRate = billParamVO.getRoleValue();

                        // 根据项目id取得原申请过的数据。
                        QueryWrapper<UseApplyEntity> appWrapper = new QueryWrapper<>();
                        appWrapper.eq("project_id", projectId);
                        appWrapper.eq("dr", 0);
                        List<UseApplyEntity> useApplyEntities = useApplyMapper.selectList(appWrapper);
                        ids.clear();
                        useApplyEntities.forEach(item -> {
                            ids.add(item.getId());
                        });
                        // 查询旧数据时，剔除掉本次申请的物资
                        List<Long> noIds = new ArrayList<>();
                        useApplySubEntities.forEach(item -> {
                            if (item.getId() != null) {
                                noIds.add(item.getId());
                            }
                        });
                        // list添加一个数据，防止数据为空时，in查询sql拼接错误。
                        ids.add(000001L);
                        QueryWrapper<UseApplySubEntity> appSubWrapper = new QueryWrapper<>();
                        appSubWrapper.in("pid", ids);
                        appSubWrapper.notIn("id", noIds);
                        appSubWrapper.eq("dr", 0);
                        List<UseApplySubEntity> useApplySubEntities1 = useApplySubMapper.selectList(appSubWrapper);
                        List<UseApplySubEntity> useApplySubEntities2 = BeanMapper.mapList(useApplySubEntities, UseApplySubEntity.class);
                        Map<Long, UseApplySubEntity> thisMap = new HashMap<>();
                        useApplySubEntities2.forEach(item -> {
                            if (thisMap.containsKey(item.getMaterialId())) {
                                UseApplySubEntity useApplySubEntity = thisMap.get(item.getMaterialId());
                                useApplySubEntity.setApplyNum(ComputeUtil.nullToZero(ComputeUtil.safeAdd(useApplySubEntity.getApplyNum(), item.getApplyNum())));
                            } else {
                                thisMap.put(item.getMaterialId(), item);
                            }
                        });

                        Map<Long, BigDecimal> oldAppMap = new HashMap<>();
                        useApplySubEntities1.forEach(item -> {
                            BigDecimal applyNum = item.getApplyNum();
                            if (oldAppMap.containsKey(item.getMaterialId())) {
                                BigDecimal bigDecimal = oldAppMap.get(item.getMaterialId());
                                oldAppMap.put(item.getMaterialId(), ComputeUtil.nullToZero(ComputeUtil.safeAdd(applyNum, bigDecimal)));
                            } else {
                                oldAppMap.put(item.getMaterialId(), applyNum);
                            }
                        });

                        thisMap.forEach((k, item) -> {
                            Long materialId = item.getMaterialId();
                            //本次申请数量
                            BigDecimal applyNum = item.getApplyNum();
                            //原有的数量 如果为空取0
                            BigDecimal oldApplyNum = oldAppMap.get(materialId) == null ? BigDecimal.ZERO : oldAppMap.get(materialId);
                            //总计划数量 如果为空 则表示未做计划，取0
                            BigDecimal planNum = planMap.get(materialId) == null ? BigDecimal.ZERO : planMap.get(materialId);

                            BigDecimal planNumber = planNum.multiply(manageRate).divide(BigDecimal.valueOf(100));
                            BigDecimal appNumber = ComputeUtil.nullToZero(ComputeUtil.safeAdd(oldApplyNum, applyNum));

                            if (planNumber.compareTo(appNumber) == -1) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                paramsCheckDsVO.setWarnItem(item.getMaterialName() + (StringUtils.isNotEmpty(item.getModel()) ? " [" + item.getModel() + "]" : ""));
                                paramsCheckDsVO.setWarnName("累计申请数量超出总计划*比例");
                                paramsCheckDsVO.setContent("本次申请数量:" + applyNum.setScale(2, BigDecimal.ROUND_HALF_UP)
                                        + ",累计已申请数量" + oldApplyNum.setScale(2, BigDecimal.ROUND_HALF_UP)
                                        + ",总计划数量" + planNum.setScale(2, BigDecimal.ROUND_HALF_UP)
                                        + ",总计划数量比例" + manageRate.setScale(2, BigDecimal.ROUND_HALF_UP)
                                        + "%,超额" + appNumber.subtract(planNumber).setScale(2, BigDecimal.ROUND_HALF_UP)
                                );
                                updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                            }
                        });
                    }
                }
            }

            // 【物资总计划单价】控制【用料申请单价】
            CommonResponse<List<BillParamVO>> response1 = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_PRICE, curOrgId);
            if (!response1.isSuccess()) {
                throw new BusinessException("【物资总计划单价】控制【用料申请单价】，获取控制参数失败，失败原因：" + response1.getMsg());
            }
            List<BillParamVO> billParamVOS1 = response1.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS1)) {
                // 根据项目取得总计划数据
                Long projectId = vo.getProjectId();
                QueryWrapper<MaterialMasterPlanEntity> wrapper = new QueryWrapper<>();
                wrapper.eq("project_id", projectId);
                List<MaterialMasterPlanEntity> materialMasterPlanEntities = materialMasterPlanMapper.selectList(wrapper);

                Map<Long, BigDecimal> planMap = new HashMap<>();
                if (CollectionUtils.isNotEmpty(materialMasterPlanEntities)) {
                    List<Long> planIds = materialMasterPlanEntities.stream().map(MaterialMasterPlanEntity::getId).collect(Collectors.toList());
                    QueryWrapper<MaterialMasterPlanSubEntity> planSubWrapper = new QueryWrapper<>();
                    planSubWrapper.in("material_master_plan_id", planIds);
                    List<MaterialMasterPlanSubEntity> materialMasterPlanSubEntities = materialMasterPlanSubMapper.selectList(planSubWrapper);
                    materialMasterPlanSubEntities.forEach(item -> {
                        BigDecimal price = item.getPrice();
                        Long materialId = item.getMaterialId();
                        //根据物资id取出总计划物资单价，若物资id相同则取单价最小值
                        if (!planMap.containsKey(materialId) || ComputeUtil.isLessThan(price, planMap.get(item.getMaterialId()))) {
                            planMap.put(materialId, price);
                        }
                    });
                }
                for (BillParamVO billParamVO : billParamVOS1) {
                    if (0 != billParamVO.getControlType()) {
                        // 比例
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                        useApplySubEntities.forEach((item) -> {
                            Long materialId = item.getMaterialId();
                            //本次材料申请单价
                            BigDecimal estimatePrice = item.getEstimatePrice();
                            //总计划单价 如果为空 则表示未做计划，取0
                            BigDecimal price = ComputeUtil.nullToZero(planMap.get(materialId));
                            //预警价
                            BigDecimal _planPrice = price.multiply(divide);

                            if (ComputeUtil.isGreaterThan(estimatePrice, _planPrice)) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                paramsCheckDsVO.setWarnItem(item.getMaterialName() + (StringUtils.isNotEmpty(item.getModel()) ? " [" + item.getModel() + "]" : ""));
                                paramsCheckDsVO.setWarnName("用料申请单价大于总计划单价");
                                paramsCheckDsVO.setContent("本次用料申请单价：" + estimatePrice.setScale(2, BigDecimal.ROUND_HALF_UP)
                                        + ",总计划单价*" + roleValue + "%:" + _planPrice.setScale(2, BigDecimal.ROUND_HALF_UP)
                                        + ",超出单价" + estimatePrice.subtract(_planPrice).setScale(2, BigDecimal.ROUND_HALF_UP)
                                );
                                updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                            }
                        });
                    }
                }
            }
            // 【项目可用资金】控制【用料申请】
            CommonResponse<List<BillParamVO>> response2 = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PROJECT_MNY, curOrgId);
            if (!response2.isSuccess()) {
                throw new BusinessException("【项目可用资金】控制【用料申请】，获取控制参数失败，失败原因：" + response2.getMsg());
            }
            List<BillParamVO> billParamVOS2 = response2.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS2)) {
                // 根据项目取得项目可用资金数据
                Long projectId = vo.getProjectId();
                CommonResponse<ProjectFinanceVO> proFinance = payContractApi.getProFinance(projectId);
                if (!proFinance.isSuccess()) {
                    throw new BusinessException("获取项目可用资金失败，失败原因：" + proFinance.getMsg());
                }
                ProjectFinanceVO proFinanceData = proFinance.getData();
                BigDecimal proSurplusMny = proFinanceData.getProSurplusMny();//项目可用资金
                for (BillParamVO billParamVO : billParamVOS2) {
                    if (0 != billParamVO.getControlType()) {
                        if (ComputeUtil.isLessOrEqual(proSurplusMny, BigDecimal.ZERO)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(sessionManager.getUserContext().getOrgName());
                            paramsCheckDsVO.setWarnItem(vo.getProjectName());
                            paramsCheckDsVO.setWarnName("项目可用资金<=0");
                            paramsCheckDsVO.setContent("该项目可用资金：" + proSurplusMny.setScale(2, BigDecimal.ROUND_HALF_UP)
                                    + "元,不能做用料申请；");
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                }
            }
            // 【材料批次计划量】控制【用料申请量】
            CommonResponse<List<BillParamVO>> response3 = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_BATCH_PLAN_NUM, curOrgId);
            if (!response3.isSuccess()) {
                throw new BusinessException("【材料批次计划量】控制【用料申请】，获取控制参数失败，失败原因：" + response3.getMsg());
            }
            List<BillParamVO> billParamVOS3 = response3.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS3)) {
                Map<Long, List<UseApplySubVO>> listMap = useApplySubEntities.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.groupingBy(UseApplySubVO::getMaterialId));
                List<Long> materialIds = new ArrayList<>(listMap.keySet());
                Map<String, Object> queryParam = new HashMap<>();
                queryParam.put("projectId", vo.getProjectId());
                queryParam.put("pId", vo.getId());
                queryParam.put("materialIds", materialIds);
                List<UseApplySubVO> useApplySubVOS = baseMapper.countUseApplyNum(queryParam);
                queryParam.put("partNames", 1);
                List<UseApplySubVO> useApplySubVOSForPart = baseMapper.countUseApplyNum(queryParam);
                List<UseApplySubVO> useApplySubVOSTwo = baseMapper.countBatchPlanNumCommon(queryParam);
                Map<Long, BigDecimal> level1Map = useApplySubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getApplyNum()));
                Map<String, BigDecimal> applyPartMap = useApplySubVOSForPart.stream().collect(Collectors.toMap(s -> s.getMaterialId() + s.getPartName(), s -> s.getApplyNum()));
                Map<String, BigDecimal> BatchNumMap = useApplySubVOSTwo.stream().collect(Collectors.toMap(s -> s.getMaterialId() + s.getPartName(), s -> s.getBatchPlanNum()));
                for (BillParamVO billParamVO : billParamVOS3) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                        for (UseApplySubVO useApplySubVO : useApplySubEntities) {
                            Long materialId = useApplySubVO.getMaterialId();
                            String partName = useApplySubVO.getPartName();
                            BigDecimal applyNum = useApplySubVO.getApplyNum();//本次申请数量
                            BigDecimal alreadyApplyNum = new BigDecimal(0);
                            if (useApplySubVO.getPartName() == null) {
                                alreadyApplyNum = level1Map.get(materialId);//已申请申请量
                            } else {
                                alreadyApplyNum = applyPartMap.get(materialId + partName);//已申请申请量
                            }
                            BigDecimal batchPlanNum = BatchNumMap.get(materialId + partName);//批次计划量
                            BigDecimal warnNum = ComputeUtil.nullToZero(batchPlanNum).multiply(divide);//预警量
                            BigDecimal sumNum = ComputeUtil.safeAdd(applyNum, alreadyApplyNum);

                            if (ComputeUtil.isGreaterThan(sumNum, warnNum)) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setOrgName(sessionManager.getUserContext().getOrgName());
                                paramsCheckDsVO.setWarnItem(useApplySubVO.getMaterialName() + useApplySubVO.getModel());
                                if (StringUtils.isNotEmpty(useApplySubVO.getPartName())) {
                                    paramsCheckDsVO.setWarnName("【" + useApplySubVO.getPartName() + "】" + "材料用料申请数量大于材料批次计划量");
                                    paramsCheckDsVO.setContent("该项目" + Optional.ofNullable("【" + useApplySubVO.getPartName() + "】").orElse("") + "本次申请数量："
                                            + ComputeUtil.nullToZero(applyNum).setScale(2, BigDecimal.ROUND_HALF_UP) + "，已申请数量："
                                            + ComputeUtil.nullToZero(alreadyApplyNum).setScale(2, BigDecimal.ROUND_HALF_UP) + "，批次计划数量*" + roleValue + "%："
                                            + warnNum.setScale(2, BigDecimal.ROUND_HALF_UP) + "，超出数量："
                                            + ComputeUtil.safeSub(sumNum, warnNum).setScale(2, BigDecimal.ROUND_HALF_UP));
                                } else {
                                    paramsCheckDsVO.setWarnName("材料用料申请数量大于材料批次计划量");
                                    paramsCheckDsVO.setContent("该项目本次申请数量："
                                            + applyNum.setScale(2, BigDecimal.ROUND_HALF_UP) + "，已申请数量："
                                            + ComputeUtil.nullToZero(alreadyApplyNum).setScale(2, BigDecimal.ROUND_HALF_UP) + "，批次计划数量*" + roleValue + "%："
                                            + warnNum.setScale(2, BigDecimal.ROUND_HALF_UP) + "，超出数量："
                                            + ComputeUtil.safeSub(sumNum, warnNum).setScale(2, BigDecimal.ROUND_HALF_UP));
                                }
                                updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                            }
                        }

                    }
                }
            }
            // 【预算零星材料金额】控制【用料申请零星材料金额】
            CommonResponse<List<BillParamVO>> response4 = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_COST_MNY, curOrgId);
            if (!response4.isSuccess()) {
                throw new BusinessException("【预算零星材料金额】控制【用料申请零星材料金额】，获取控制参数失败，失败原因：" + response4.getMsg());
            }
            List<BillParamVO> billParamVOS4 = response4.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS4)) {
                Long projectId = vo.getProjectId();
                BudgetProjectProParamControlVO controlVO = new BudgetProjectProParamControlVO();
                controlVO.setProjectId(projectId);
                controlVO.setCostType(2);
                CommonResponse<BudgetProjectProQuantityAndMnyVO> costMnyResponse = budgetProjectProApi.fetchQuantityAndMny(controlVO);
                if (!costMnyResponse.isSuccess()) {
                    throw new BusinessException("预算编制数据失败原因：" + costMnyResponse.getMsg());
                }
                BudgetProjectProQuantityAndMnyVO costMnyVo = costMnyResponse.getData();
                if (1==vo.getSporadicMaterialFlag()&&costMnyVo!=null&&costMnyVo.getSporadicMaterialMny()!=null&&ComputeUtil.isGreaterThan(costMnyVo.getSporadicMaterialMny(),BigDecimal.ZERO)) {
                    BigDecimal sporadicMaterialMny = costMnyVo.getSporadicMaterialMny();//零星材料金额
                    LambdaQueryWrapper<UseApplyEntity> wrapper = Wrappers.lambdaQuery();
                    wrapper.ne(vo.getId()!=null,UseApplyEntity::getId,vo.getId());
                    wrapper.eq(UseApplyEntity::getProjectId,projectId);
                    wrapper.eq(UseApplyEntity::getSporadicMaterialFlag,1);
                    wrapper.eq(UseApplyEntity::getDr,0);
                    List<UseApplyEntity> useApplyEntities = useApplyMapper.selectList(wrapper);
                    //用料申请零星材料总金额
                    BigDecimal useAppMny = useApplyEntities.stream().filter(v -> null != v.getEstimateMoney()).map(UseApplyEntity::getEstimateMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                    //加本次暂估金额
                    useAppMny=ComputeUtil.safeAdd(useAppMny,vo.getEstimateMoney());
                    for (BillParamVO billParamVO : billParamVOS4) {
                        if (0 != billParamVO.getControlType()) {
                            // 比例
                            BigDecimal roleValue = billParamVO.getRoleValue();
                            BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                                //预警价
                                BigDecimal _sporadicMaterialMny = sporadicMaterialMny.multiply(divide);

                                if (ComputeUtil.isGreaterThan(useAppMny, _sporadicMaterialMny)) {
                                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                    paramsCheckDsVO.setWarnItem( "零星材料申请金额超预算中零星材料金额");
                                    paramsCheckDsVO.setWarnName("零星材料申请金额大于预算中零星材料金额");
                                    paramsCheckDsVO.setContent("该项目零星材料申请金额：" + useAppMny.setScale(2, BigDecimal.ROUND_HALF_UP)
                                            + "，预算零星材料金额*" + roleValue + "%:" + _sporadicMaterialMny.setScale(2, BigDecimal.ROUND_HALF_UP)
                                            + ",超出金额" + ComputeUtil.safeSub(useAppMny,_sporadicMaterialMny).setScale(2, BigDecimal.ROUND_HALF_UP)
                                    );
                                    updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                }
                        }
                    }
                }
            }

        }
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            pc.setWarnType("alert");
            pc.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            pc.setWarnType("warn");
            pc.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }


    @Override
    public CommonResponse<UseApplyVO> getSumNumCommon(UseApplyVO vo) {
        List<UseApplySubVO> useApplySubEntities = vo.getUseApplySubEntities();
        Map<Long, List<UseApplySubVO>> listMap = useApplySubEntities.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.groupingBy(UseApplySubVO::getMaterialId));
        //当前单子累计物资量
        Map<Long, BigDecimal> numMap = new HashMap<>();
        listMap.forEach((k, v) -> numMap.put(k, v.stream().filter(s -> s.getApplyNum() != null).map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add)));
        List<Long> materialIds = new ArrayList<>(listMap.keySet());
        if (CollectionUtils.isEmpty(materialIds)) {
            return CommonResponse.success("查询物资累计量,进度量,总量成功!", vo);
        }
        Map<String, Object> queryParam = new HashMap<>();
        queryParam.put("projectId", vo.getProjectId());
        queryParam.put("pId", vo.getId());
        queryParam.put("materialIds", materialIds);
        List<UseApplySubVO> useApplySubVOS = baseMapper.countApplyNumCommon(queryParam);
        queryParam.put("partNameFlag", 1);
        List<UseApplySubVO> useApplySubVOSForPart = baseMapper.countApplyNumCommon(queryParam);
        List<UseApplySubVO> BatchPartVO = baseMapper.countBatchPlanNumCommon(queryParam);

        Long orgId = vo.getOrgId();
        List<InstoreMaterialVO> instoreMaterialVOList = null;
        if (orgId != null) {
            instoreMaterialVOList = instoreMaterialService.storeNumCount(orgId, materialIds);
        }
        if (CollectionUtils.isNotEmpty(useApplySubEntities)) {
            Map<Long, BigDecimal> storeNumMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(instoreMaterialVOList)) {
                storeNumMap = instoreMaterialVOList.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getStoreNum()));
            }
            Map<Long, BigDecimal> level3Map = useApplySubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getApplyNum()));
            Map<Long, BigDecimal> level5Map = useApplySubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getSumEstimateMny()));
            Map<Long, List<UseApplySubVO>> level4Map = useApplySubEntities.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.groupingBy(UseApplySubVO::getMaterialId));
            Map<String, BigDecimal> batchNumMap = BatchPartVO.stream().collect(Collectors.toMap(s -> s.getMaterialId() + s.getPartName(), s -> s.getBatchPlanNum()));
            Map<String, BigDecimal> applyPartMap = useApplySubVOSForPart.stream().collect(Collectors.toMap(k -> k.getMaterialId() + k.getPartName(), k -> k.getApplyNum()));
            Map<Long, BigDecimal> sumAppluNumMap = new HashMap<>();
            level4Map.forEach((k, v) -> sumAppluNumMap.put(k, v.stream().filter(s -> s.getApplyNum() != null).map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add)));
            for (UseApplySubVO d : useApplySubEntities) {
                Long materialId = d.getMaterialId();
                String partName = d.getPartName();
                if (materialId == null) {
                    continue;
                }
                BigDecimal applyed = level3Map.get(materialId);
                BigDecimal applyedForPart = applyPartMap.get(materialId + partName);
                BigDecimal thisAddApplyed = ComputeUtil.safeAdd(applyed, d.getApplyNum());
                BigDecimal thisAddApplyedForPart = ComputeUtil.safeAdd(applyedForPart, d.getApplyNum());
                BigDecimal sumEstimateMoney = level5Map.get(materialId);
                BigDecimal thisAddSumEstimateMoney = ComputeUtil.safeAdd(sumEstimateMoney, d.getEstimateMoney());
                /** 获取该项目下物资退货数量 **/
                Map<String, Object> param = new HashMap<>();
                param.put("projectId", vo.getProjectId());
                param.put("materialId", d.getMaterialId());
                List<OutStoreSubVO> outStoreSubVOS = outStoreSubService.queryReturnGoodsMaterialNum(param);
                Map<Long, BigDecimal> outStoreMap = outStoreSubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getOutStoreNumber()));
                BigDecimal returnGoodsNum = outStoreMap.get(materialId);
                applyed = BigDecimalUtils.safeSub(applyed, returnGoodsNum);
                if (applyed.compareTo(BigDecimal.ZERO) < 0) {
                    applyed = new BigDecimal(0);
                }
                /** 获取该项目下物资退货数量 **/
//                    thisAddApplyed = ComputeUtil.safeAdd(applyed, d.getApplyNum());
                thisAddApplyed = ComputeUtil.safeAdd(applyed, sumAppluNumMap.get(materialId));
                if (thisAddApplyed.compareTo(BigDecimal.ZERO) < 0) {
                    thisAddApplyed = new BigDecimal(0);
                }
                /** 获取该项目下物资总计划数量 **/
                List<MaterialMasterPlanSubVO> masterPlanSubVOS = materialMasterPlanSubMapper.queryMasterPlanSubNum(param);
                Map<Long, Double> masterPlanMap = masterPlanSubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getNum()));
                Map<Long, BigDecimal> masterPlanMnyMap = masterPlanSubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getAmount()));
                Double masterPlanNum = masterPlanMap.get(materialId);
                /** 获取该项目下物资总计划数量 **/
                d.setOrderNum(ComputeUtil.nullToZero(thisAddApplyed));
                d.setSumApplyNum(ComputeUtil.nullToZero(applyed));
                d.setMasterPlanNum(masterPlanNum != null ? new BigDecimal(masterPlanNum) : BigDecimal.ZERO.setScale(8));
                d.setSumApplyNumForPart(ComputeUtil.nullToZero(applyedForPart));
                d.setOrderNumForPart(ComputeUtil.nullToZero(thisAddApplyedForPart));
                d.setBatchPlanNum(ComputeUtil.nullToZero(batchNumMap.get(materialId + partName)));
                d.setSumEstimateMny(sumEstimateMoney);
                d.setThisAddSumEstimateMny(thisAddSumEstimateMoney);
                d.setPlanTotalMny(ComputeUtil.nullToZero(masterPlanMnyMap.get(materialId)));
                // storeNumMap
                d.setStoreNum(ComputeUtil.nullToZero(storeNumMap.get(materialId)));
                d.setIsFinish(0);
            }
        }

        return CommonResponse.success("查询物资累计量,进度量,总量成功!", vo);
    }

    /**
     * @param queryParam
     * @description: 查询项目用料, 物资已完成状态, 施工计划 使用
     * 世纪阳光专业分包模式使用
     * @return: java.util.List<com.ejianc.business.material.vo.UseApplySubVO>
     * @author songlx
     * @date: 2021/9/28
     */
    @Override
    public List<UseApplyFinishVO> materialFinishCount(Map<String, Object> queryParam) {
        return baseMapper.materialFinishCount(queryParam);
    }

    /**
     *
     * @param projectId
     * @param materialIds
     * @return
     */
    @Override
    public List<MaterialApplyCountVO> queryMaterialApplyCount(Long projectId, List<Long> materialIds) {
        return baseMapper.queryMaterialApplyCount(projectId, materialIds);
    }

    /**
     * @description: 查询用料申请参照合计版
     *
     * @param pageData
     * @param queryParam
     * @param projectId
     * @return {@link List< UseApplySubEntity>}
     * @author songlx
     * @date: 2022/11/29
     */
    @Override
    public List<UseApplySubEntity> queryAllApplyData(IPage<UseApplySubEntity> pageData, QueryParam queryParam, Long projectId) {
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<UseApplySubEntity> list = baseMapper.queryAllApplyData(pageData, wrapper, projectId);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryApplySubList(IPage<UseApplySubEntity> pageData, QueryParam queryParam) {
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<UseApplySubEntity> list = baseMapper.queryApplySubList(pageData, wrapper);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryAllApplyDataForPurchaseOrder(IPage<UseApplySubEntity> pageData, QueryParam queryParam, Long projectId) {
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<UseApplySubEntity> list = baseMapper.queryAllApplyDataForPurchaseOrder(pageData, wrapper, projectId);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryApplySubListForPurchaseOrder(IPage<UseApplySubEntity> pageData, QueryParam queryParam) {
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<UseApplySubEntity> list = baseMapper.queryApplySubListForPurchaseOrder(pageData, wrapper);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryApplySubListForInstore(IPage<UseApplySubEntity> pageData, QueryParam queryParam) {
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<UseApplySubEntity> list = baseMapper.queryApplySubListForInstore(pageData, wrapper);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryAllApplyDataForInstore(IPage<UseApplySubEntity> pageData, QueryParam queryParam, Long projectId) {
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<UseApplySubEntity> list = baseMapper.queryAllApplyDataForInstore(pageData, wrapper, projectId);
        return list;
    }

    @Override
    public void updatePurchaseFlag(Long id, Integer purchaseFlag) {
        if (id != null) {
            LambdaUpdateWrapper<UseApplyEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(UseApplyEntity::getId, id);
            updateWrapper.set(UseApplyEntity::getPurchaseFlag, purchaseFlag);
            super.update(updateWrapper);
        }
    }
}