package com.ejianc.business.dataModel.consts;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 单据类型和单据子表的枚举
 */
public enum DataModelEnum {

    物资总计划("BT210302000000004", "materialSubList"),

    物资总计划变更("BT210306000000001", "materialSubList"),

    物资采购合同("BT200608000000001", "materialDetailList"),

    物资采购合同变更("BT200613000000001", "materialDetailList"),

    项目用料申请("BT200602000000001","useApplySubEntities"),

    收料入库单("BT200611000000015","instoreMaterialList"),

    直入直出单("BT200616000000005","instoreMaterialList"),

    物资合同结算单("BT200610000000004","materialDetails");


    private String code;

    private String name;
    private String className;

    private static Map<String, DataModelEnum> enumMap = new HashMap();

    private DataModelEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }



    public static void setEnumMap(Map<String, DataModelEnum> enumMap) {
        DataModelEnum.enumMap = enumMap;
    }

    public static DataModelEnum getByCode(String code) {
        return (DataModelEnum)enumMap.get(code);
    }

    static {
        enumMap = (Map) EnumSet.allOf(DataModelEnum.class).stream().collect(Collectors.toMap(DataModelEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
