package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * @author CJ
 * @Description: 物资合同-物资明细
 * @date 2020/6/9 13:54
 */
@TableName(value = "ejc_material_materialcontract_detail")
public class MaterialContractDetailSubEntity extends BaseEntity {

    private static final long serialVersionUID = 2389356274288088478L;

    /**
     * 物资分类Id
     */
    @TableField(value = "material_type_id")
    private Long materialTypeId;


    /**
     * 物资分类名称
     */
    @TableField(value = "material_type_name")
    private String materialTypeName;

    /**
     * 物资名称
     */
    @TableField(value = "material_name")
    private String materialName;

    /**
     * 规则/型号
     */
    @TableField(value = "spec")
    private String spec;

    /**
     * 计量单位
     */
    @TableField(value = "measure_unit")
    private String measureUnit;

    /**
     * 品牌
     */
    @TableField(value = "supplier_name")
    private java.lang.String supplierName;
    /**
     * 数量
     */
    @TableField(value = "count")
    private BigDecimal count;

    /**
     * 单价
     */
    @TableField(value = "unit_price")
    private BigDecimal unitPrice;

    /**
     * 金额
     */
    @TableField(value = "total_amount")
    private BigDecimal totalAmount;

    /**
     * 备注
     */
    @TableField(value = "material_remark")
    private String materialRemark;

    /**
     * 物资来源类型：1-物料档案，2-用料申请，3-询价单，4-导入，5-总计划，6-批次计划
     */
    @TableField(value = "source_type")
    private String sourceType;

    @TableField(value = "source_type_name")
    private String sourceTypeName;
    @TableField(value = "source_type_id")
    private Long sourceTypeId; //来源主表id



    /**
     * 物资来源单据Id
     */
    @TableField(value = "source_Id")
    private String sourceId;

    /**
     * 物资Id
     */
    @TableField(value = "material_id")
    private String materialId;

    /**
     * 物资合同Id
     */
    @TableField(value = "material_contract_id")
    private Long materialContractId;

    //其他字段
    /**
     * 变更项对应主表主键
     */
    @TableField(value = "change_id")
    private Long changeId;

    /**
     * 变更项子表主键Id
     */
    @TableField(value = "change_bid")
    private Long changBid;

    /**
     * 变更类型
     */
    @TableField(value = "change_type")
    private Integer changeType;
    @TableField(exist = false)
    private Integer matchStatus; // 匹配状态：0-未匹配，1-已匹配，2-模糊匹配，
    @TableField(exist = false)
    private String matchStatusDescription;
    @TableField(value = "assist_unit_name")
    private String assistUnitName; // 辅单位
    @TableField(value = "unit_assist_unit")
    private BigDecimal unitAssistUnit; // 单位/辅单位
    @TableField(value = "num_assist_unit")
    private BigDecimal numAssistUnit; // 数量/辅单位=【数量】*【单位/辅单位】
    @TableField(value = "price_assist_unit")
    private BigDecimal priceAssistUnit; // 单价/辅单位=【金额】/【数量/辅单位】
    @TableField(exist = false)
    private BigDecimal residualQuantity;//剩余数量

    /**
     * 物资编码
     */
    @TableField(value = "material_code")
    private String materialCode;


    public Long getSourceTypeId() {
        return sourceTypeId;
    }

    public void setSourceTypeId(Long sourceTypeId) {
        this.sourceTypeId = sourceTypeId;
    }

    public String getSourceTypeName() {
        return sourceTypeName;
    }

    public void setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
    }

    public BigDecimal getResidualQuantity() {
        return residualQuantity;
    }

    public void setResidualQuantity(BigDecimal residualQuantity) {
        this.residualQuantity = residualQuantity;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getMaterialId() {
        return materialId;
    }

    public void setMaterialId(String materialId) {
        this.materialId = materialId;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getMeasureUnit() {
        return measureUnit;
    }

    public void setMeasureUnit(String measureUnit) {
        this.measureUnit = measureUnit;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getCount() {
        return count;
    }

    public void setCount(BigDecimal count) {
        this.count = count;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getMaterialRemark() {
        return materialRemark;
    }

    public void setMaterialRemark(String materialRemark) {
        this.materialRemark = materialRemark;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getMaterialContractId() {
        return materialContractId;
    }

    public void setMaterialContractId(Long materialContractId) {
        this.materialContractId = materialContractId;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Long getChangBid() {
        return changBid;
    }

    public void setChangBid(Long changBid) {
        this.changBid = changBid;
    }

    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    public Integer getMatchStatus() {
        return matchStatus;
    }

    public void setMatchStatus(Integer matchStatus) {
        this.matchStatus = matchStatus;
    }

    public String getMatchStatusDescription() {
        return matchStatusDescription;
    }

    public void setMatchStatusDescription(String matchStatusDescription) {
        this.matchStatusDescription = matchStatusDescription;
    }

    public String getAssistUnitName() {
        return assistUnitName;
    }

    public void setAssistUnitName(String assistUnitName) {
        this.assistUnitName = assistUnitName;
    }

    public BigDecimal getUnitAssistUnit() {
        return unitAssistUnit;
    }

    public void setUnitAssistUnit(BigDecimal unitAssistUnit) {
        this.unitAssistUnit = unitAssistUnit;
    }

    public BigDecimal getNumAssistUnit() {
        return numAssistUnit;
    }

    public void setNumAssistUnit(BigDecimal numAssistUnit) {
        this.numAssistUnit = numAssistUnit;
    }

    public BigDecimal getPriceAssistUnit() {
        return priceAssistUnit;
    }

    public void setPriceAssistUnit(BigDecimal priceAssistUnit) {
        this.priceAssistUnit = priceAssistUnit;
    }
}
