package com.ejianc.business.material.service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface IInstoreMaterialService extends IBaseService<InstoreMaterialEntity> {

    List<InstoreMaterialVO> querylist(QueryWrapper<InstoreMaterialEntity> queryWrapper);

    IPage<InstoreMaterialVO> queryStoreCanUseNumPageData(String searchText,String searchObject,String outDate,
                                                         Long storeId, Integer pageNum, Integer pageSize);

    IPage<InstoreMaterialVO> storematerialList(Long storeId, String searchText, Integer pageNumber, Integer pageSize);

    BigDecimal countAmount(QueryParam param);

    InstoreMaterialVO censusStorematerial(Long storeIid);

    /**
     * 查询指定仓库可用物资列表，相同物资数量、金额合并
     *
     * @param searchText
     * @param outDate
     * @param storeId
     * @param pageNumber
     * @param pageSize
     * @param materialIds
     * @param map
     * @return
     */
    IPage<InstoreMaterialVO> queryUsableSubMaterialList(String searchText, String outDate, Long storeId, Integer pageNumber, Integer pageSize, List<Long> materialIds, HashMap<String, String> map);

    /**
     * 查询指定物资在指定仓库中的各个入库单中的库存情况，盘点使用
     *
     * @param storeId
     * @param checkDate
     * @param materialId
     * @param inventory
     * @return
     */
    List<InstoreMaterialVO> querySubMaterialStoreInfo(Long storeId, Date checkDate, Long materialId, double inventory);


    /**
     * @param vo
     * @description: 参数校验
     * @return: com.ejianc.business.finance.vo.ParamsCheckVO
     * @author songlx
     * @date: 2021-05-27
     */
    ParamsCheckVO checkParams(MaterialPriceVO vo);

    /**
     * @description: 库存量：该材料在该项目下所有仓库中的现存量合计值 + 该项目本上级所有公司仓的现存量合计值。
     *
     * @return {@link java.util.List<com.ejianc.business.material.vo.InstoreMaterialVO>}
     * @author songlx
     * @date: 2024/2/18
     */
    List<InstoreMaterialVO> storeNumCount(Long orgId, List<Long> materialIds);
}
