package com.ejianc.business.material.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/1  用料申请主实体
 * @Description UseApplyEntity
 */

public class UseApplyVO extends BaseVO {

    private static final long serialVersionUID = 2779265683203439571L;

    /**
     * 单据状态
     */
    private Integer billState;

    /**
     * 申请单号
     */
    private String billCode;

    /**
     * 申请单名称
     */
    private String name;

    /**
     * 项目名称
     */
    private String projectName;
    private Integer sporadicMaterialFlag;//是否零星材料(0:否1:是)
    /**
     * 项目名称参照
     */
    private Long projectId;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 组织参照
     */
    private Long orgId;

    /**
     * 申请材料种类
     */
    private String materialTypeName;

    /**
     * 预估金额
     */
    private BigDecimal estimateMoney;
    private Integer purchaseFlag;//是否已采购(0:否1:是)
    /**
     * 计划进场日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planEnterDate;

    /**
     * 申请时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate;

    /**
     * 申请人
     */
    private String applyPerson;

    /**
     * 备注
     */
    private String memo;

    /**
     * 收货人
     */
    private String consignee;

    /**
     * 收货人电话
     */
    private String consigneePhone;

    /**
     * 收货地址
     */
    private String consigneeAddress;


    /**
     * 编制日期  使用创建时间 createTime
     */

    private java.lang.Long areaId; // 区域id
    private java.lang.String areaCode; // 区域编码
    private java.lang.String areaName; // 区域名称
    private java.lang.Long purchaseTypeId; // 采购类型id
    private java.lang.String purchaseTypeCode; // 采购类型编码
    private java.lang.String purchaseTypeName; // 采购类型名称
    private java.lang.Integer isAbove; // 是否超量1是0否
    private java.lang.Integer isExceed; // 是否超量1是0否（工程云通用）


    private Integer assignState; // 分配状态0未分配1已分配
    private Long purchaseManagerId; // 采购负责人
    private String purchaseManagerName; // 采购负责人

    private String receiverIds;// 任务接收人ids

    /**
     * 子表
     */
    private List<UseApplySubVO> useApplySubEntities = new ArrayList<>();


    public String getReceiverIds() {
        return receiverIds;
    }

    public void setReceiverIds(String receiverIds) {
        this.receiverIds = receiverIds;
    }

    public Integer getAssignState() {
        return assignState;
    }

    public void setAssignState(Integer assignState) {
        this.assignState = assignState;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getPurchaseManagerId() {
        return purchaseManagerId;
    }
    @ReferDeserialTransfer
    public void setPurchaseManagerId(Long purchaseManagerId) {
        this.purchaseManagerId = purchaseManagerId;
    }

    public String getPurchaseManagerName() {
        return purchaseManagerName;
    }

    public void setPurchaseManagerName(String purchaseManagerName) {
        this.purchaseManagerName = purchaseManagerName;
    }

    public String getConsigneeAddress() {
        return consigneeAddress;
    }

    public void setConsigneeAddress(String consigneeAddress) {
        this.consigneeAddress = consigneeAddress;
    }

    public Long getAreaId() {
        return areaId;
    }

    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaName() {
        return areaName;
    }

    public Integer getSporadicMaterialFlag() {
        return sporadicMaterialFlag;
    }

    public void setSporadicMaterialFlag(Integer sporadicMaterialFlag) {
        this.sporadicMaterialFlag = sporadicMaterialFlag;
    }

    public Integer getPurchaseFlag() {
        return purchaseFlag;
    }

    public void setPurchaseFlag(Integer purchaseFlag) {
        this.purchaseFlag = purchaseFlag;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPurchaseTypeId() {
        return purchaseTypeId;
    }

    @ReferDeserialTransfer
    public void setPurchaseTypeId(Long purchaseTypeId) {
        this.purchaseTypeId = purchaseTypeId;
    }

    public String getPurchaseTypeCode() {
        return purchaseTypeCode;
    }

    public void setPurchaseTypeCode(String purchaseTypeCode) {
        this.purchaseTypeCode = purchaseTypeCode;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public Integer getIsAbove() {
        return isAbove;
    }

    public void setIsAbove(Integer isAbove) {
        this.isAbove = isAbove;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public BigDecimal getEstimateMoney() {
        return estimateMoney;
    }

    public void setEstimateMoney(BigDecimal estimateMoney) {
        this.estimateMoney = estimateMoney;
    }

    public Date getPlanEnterDate() {
        return planEnterDate;
    }

    public void setPlanEnterDate(Date planEnterDate) {
        this.planEnterDate = planEnterDate;
    }

    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }

    public String getApplyPerson() {
        return applyPerson;
    }

    public void setApplyPerson(String applyPerson) {
        this.applyPerson = applyPerson;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getConsignee() {
        return consignee;
    }

    public void setConsignee(String consignee) {
        this.consignee = consignee;
    }

    public String getConsigneePhone() {
        return consigneePhone;
    }

    public void setConsigneePhone(String consigneePhone) {
        this.consigneePhone = consigneePhone;
    }

    public Integer getIsExceed() {
        return isExceed;
    }

    public void setIsExceed(Integer isExceed) {
        this.isExceed = isExceed;
    }

    public List<UseApplySubVO> getUseApplySubEntities() {
        return useApplySubEntities;
    }

    public void setUseApplySubEntities(List<UseApplySubVO> useApplySubEntities) {
        this.useApplySubEntities = useApplySubEntities;
    }
}
