/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller.api;

import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.vo.InstoreAccountSumVO;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.UseApplyFinishVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/materialInstore/"})
public class MaterialInstoreApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IInstoreService instoreService;
    @Autowired
    IUseApplyService useApplyService;

    @RequestMapping(value={"instoreNumCount"}, method={RequestMethod.POST})
    CommonResponse<List<InstoreMaterialVO>> instoreNumCount(@RequestBody Map<String, Object> queryParam) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", this.instoreService.instoreNumCount(queryParam));
    }

    @RequestMapping(value={"materialFinishCount"}, method={RequestMethod.POST})
    CommonResponse<List<UseApplyFinishVO>> materialFinishCount(@RequestBody Map<String, Object> queryParam) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", this.useApplyService.materialFinishCount(queryParam));
    }

    @RequestMapping(value={"amountSum"}, method={RequestMethod.POST})
    CommonResponse<List<InstoreAccountSumVO>> amountSum(@RequestParam(value="projectIds") List<Long> projectIds) {
        List<InstoreAccountSumVO> instoreAccountSumVOS = this.instoreService.amountSum(projectIds);
        if (CollectionUtils.isNotEmpty(instoreAccountSumVOS)) {
            instoreAccountSumVOS.forEach(t2 -> {
                BigDecimal surplusAmt = ComputeUtil.safeSub((BigDecimal)t2.getInAmount(), (BigDecimal)t2.getOutAmount());
                t2.setTotalAmount(ComputeUtil.isGreaterThan((BigDecimal)surplusAmt, (BigDecimal)t2.getSettleAmount()) ? surplusAmt : t2.getSettleAmount());
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", instoreAccountSumVOS);
    }
}

