package com.ejianc.business.delivery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
//import com.ejianc.business.constant.InteractiveConstants;
import com.ejianc.business.delivery.enums.StoreStatusEnum;
import com.ejianc.business.delivery.service.IMaterialDeliveryService;
//import com.ejianc.business.delivery.vo.MaterialDeliveryDetailTbVO;
import com.ejianc.business.delivery.vo.MaterialDeliveryDetailVO;
//import com.ejianc.business.delivery.vo.MaterialDeliveryTbVO;
import com.ejianc.business.delivery.vo.MaterialDeliveryVO;
//import com.ejianc.business.delivery.enums.AutomaticWeighEnums;
import com.ejianc.business.delivery.enums.CloseFlagEnum;
import com.ejianc.business.delivery.enums.DeliverCheckStateEnum;
import com.ejianc.business.delivery.enums.OrderDeliverStateEnum;
import com.ejianc.business.delivery.bean.MaterialDeliveryDetailEntity;
import com.ejianc.business.delivery.bean.MaterialDeliveryEntity;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.bean.PurchaseOrderDetailEntity;
import com.ejianc.business.material.bean.PurchaseOrderEntity;
import com.ejianc.business.material.service.IInstoreMaterialService;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IPurchaseOrderService;
import com.ejianc.business.delivery.mapper.MaterialDeliveryMapper;
import com.ejianc.business.delivery.service.IMaterialDeliveryDetailService;
import com.ejianc.business.delivery.vo.*;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 消耗材送货单
 *
 * @author generator
 */
@Service("materialDeliveryService")
public class MaterialDeliveryServiceImpl extends BaseServiceImpl<MaterialDeliveryMapper, MaterialDeliveryEntity> implements IMaterialDeliveryService {
    private Logger logger = LoggerFactory.getLogger(getClass());

    private static final String BILL_CODE = "MATERIAL_DELIVERY";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;
    /** 材料订单信息 */
    @Autowired
    private IPurchaseOrderService orderService;
    @Autowired
    private IMaterialDeliveryDetailService deliveryDetailService;
    @Autowired
    private ISystemDataPushService systemDataPushService;

    /** 通知送货单 */
//    @Value("${proMaterial.pushMaterialDelivery}")
//    private String pushMaterialDelivery;
//    /** 通知订单送货状态 */
//    @Value("${proMaterial.pushMaterialOrderDeliver}")
//    private String pushMaterialOrderDeliver;

    @Autowired
    private IInstoreService storeService;

    @Autowired
    private IInstoreMaterialService storeMaterialService;

    /**
     * 查询送货单
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @Override
    public IPage<MaterialDeliveryVO> queryDeliverList(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName"); // 合同名称
        fuzzyFields.add("projectName"); // 项目名称
        fuzzyFields.add("orgName"); // 采购方名称
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        if (!param.getParams().containsKey("closeFlag")) {
//            param.getParams().put("closeFlag", new Parameter(QueryParam.EQ, CloseFlagEnum.NORMAL.getCode()));
//        }
        // 默认创建时间倒序
        if (param.getOrderMap().isEmpty()) {
            param.getOrderMap().put("createTime", QueryParam.DESC);
        }
        IPage<MaterialDeliveryEntity> page = super.queryPage(param, false);
        IPage<MaterialDeliveryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialDeliveryVO.class));
        return pageData;
    }

    /**
     * 保存、修改送货单
     *
     * @param saveOrUpdateVO 送货单数据
     * @return 保存数据
     */
    @Override
    public MaterialDeliveryVO saveDeliver(MaterialDeliveryVO saveOrUpdateVO) {
        // 校验是否存在未生效的送货单
        Long orderId = saveOrUpdateVO.getOrderId();
        PurchaseOrderEntity orderEntity = orderService.selectById(orderId);
//        if (CloseFlagEnum.CLOSE.getCode().equals(orderEntity.getOrderFlag())) {
//            throw new BusinessException("当前订单已关闭！");
//        }
        QueryParam checkParam = new QueryParam();
        checkParam.getParams().put("orderId", new Parameter(QueryParam.EQ, orderId));
        checkParam.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                        BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                        BillStateEnum.UNAPPROVED.getBillStateCode(),
                        BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode())));
        // 校验排除当前的送货当
        if (saveOrUpdateVO.getId() != null) {
            checkParam.getParams().put("id", new Parameter(QueryParam.NE, saveOrUpdateVO.getId()));
        }
        List<MaterialDeliveryEntity> checkList = super.queryList(checkParam);
        if (CollectionUtils.isNotEmpty(checkList)) {
            throw new BusinessException("当前订单存在未生效的送货单！");
        }

        // 校验子表是否全部都是已送货或者未送货
        if (CollectionUtils.isEmpty(saveOrUpdateVO.getMaterialDeliveryDetailList())) {
            throw new BusinessException("送货单列表不能为空！");
        }
//        List<Integer> automaticWeighList = saveOrUpdateVO.getMaterialDeliveryDetailList().stream()
//                .filter(e -> !"del".equals(e.getRowState())).map(MaterialDeliveryDetailVO::getDetailAutomaticWeigh)
//                .collect(Collectors.toList());
//        if (CollectionUtils.isNotEmpty(automaticWeighList)
//                && automaticWeighList.contains(AutomaticWeighEnums.关闭自动称重.getCode())
//                && automaticWeighList.contains(AutomaticWeighEnums.开启自动称重.getCode())) {
//            throw new BusinessException("送货单明细必须全部是自动称重或全部不是自动称重的材料，不能两者混合发货！");
//        }
//        // 设置主表为自动称重或非自动称重
//        Integer automaticWeigh = CollectionUtils.isNotEmpty(automaticWeighList) ?
//                automaticWeighList.get(0) : AutomaticWeighEnums.关闭自动称重.getCode();
//        saveOrUpdateVO.setAutomaticWeigh(automaticWeigh);

        MaterialDeliveryEntity entity = BeanMapper.map(saveOrUpdateVO, MaterialDeliveryEntity.class);
        entity.setLinkId(orderEntity.getEmployeeId());
        entity.setLinkName(orderEntity.getEmployeeName());
        entity.setOrderExpiryDate(orderEntity.getGoodsDate());
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam
                    .build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        // 计算数量
        // 查询订单信息
//        MaterialOrderEntity orderEntity = orderService.selectById(entity.getOrderId());
        // 各个材料的接收数量
        Map<Long, BigDecimal> receiveNumsSumMap = orderEntity.getPurchaseOrderDetailList().stream().collect(
                Collectors.toMap(PurchaseOrderDetailEntity::getId, PurchaseOrderDetailEntity::getReceiveNum));
        // 查询已送货订单的数量
        Map<Long, BigDecimal> map = this.sumDeliveredGroupByDetailId(orderId);
        // 对当前发货单进行计算
        for (MaterialDeliveryDetailEntity deliveryDetailEntity : entity.getMaterialDeliveryDetailList()) {
            Long orderDetailId = deliveryDetailEntity.getOrderDetailId();
            // 接收数量
            BigDecimal receiveNumsSum = receiveNumsSumMap.get(orderDetailId);
            // 已发货数量
            BigDecimal shippedNumSum = ComputeUtil.nullToZero(map.get(orderDetailId))
                    .add(deliveryDetailEntity.getDeliveryNum());
            // 未发货数量
            BigDecimal notShippedNumSum = receiveNumsSum.subtract(shippedNumSum);
            if (notShippedNumSum.compareTo(BigDecimal.ZERO) < 0) {
                notShippedNumSum = BigDecimal.ZERO;
            }
            deliveryDetailEntity.setReceiveNumsSum(receiveNumsSum);
            deliveryDetailEntity.setShippedNumSum(shippedNumSum);
            deliveryDetailEntity.setNotShippedNumSum(notShippedNumSum);
        }
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, MaterialDeliveryVO.class);
    }

    /**
     * 变更送货单状态
     *
     * @param saveOrUpdateVO 需要变更的送货单信息
     * @return 变更结果
     */
    @Override
    public Boolean updateDeliverState(MaterialDeliveryVO saveOrUpdateVO) {
        logger.info("进入送货单变更状态接口>>>>>>>>>>>>>>>>>>>>>>>>");
        logger.info("接收到数据:{}", JSONObject.toJSONString(saveOrUpdateVO));
        if (null == saveOrUpdateVO.getSourceId()) {
            throw new BusinessException("送货单信息为空！");
        }
        MaterialDeliveryEntity entity = super.selectById(saveOrUpdateVO.getSourceId());
        if (null == entity) {
            throw new BusinessException("送货单信息为空！");
        }
        if (saveOrUpdateVO.getCheckStatus() == null && saveOrUpdateVO.getCloseFlag() == null){
            throw new BusinessException("状态不能为空！");
        }
        if (saveOrUpdateVO.getCheckStatus() != null) {
            entity.setCheckStatus(saveOrUpdateVO.getCheckStatus());
        }
        if (saveOrUpdateVO.getCloseFlag() != null) {
            entity.setCloseFlag(saveOrUpdateVO.getCloseFlag());
        }
        boolean flag = super.saveOrUpdate(entity, false);
        logger.info("送货单变更状态接口结束<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return flag;
    }

    /**
     * 根据订单初始化送货单详情
     *
     * @param orderId 订单id
     * @return 送货单详情
     */
    @Override
    public MaterialDeliveryVO queryInitDelivery(Long orderId) {
        PurchaseOrderEntity orderEntity = orderService.selectById(orderId);
        MaterialDeliveryVO vo = BeanMapper.map(orderEntity, MaterialDeliveryVO.class);
        vo.setOrderId(orderEntity.getId());
        vo.setOrderBillCode(orderEntity.getBillCode());
        vo.setEmployeeId(null);
        vo.setEmployeeName(null);
        vo.setDeliverName(null);
        vo.setDeliverPhone(null);
        vo.setArriveDate(null);
        vo.setLicensePlate(null);
        vo.setDepartmentId(null);
        vo.setDepartmentName(null);
        vo.setCloseFlag(null);
        vo.setId(null);
        vo.setCheckStatus(DeliverCheckStateEnum.WAIT_CHECK.getCode());
        vo.setMemo(null);
//        vo.setCheckType(orderEntity.getContractPropertyCode());
//        vo.setCheckTypeName(orderEntity.getContractPropertyName());
        vo.setCloseFlag(CloseFlagEnum.NORMAL.getCode());
        vo.setArriveDate(new Date());
        vo.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        List<MaterialDeliveryDetailVO> list = new ArrayList<>();
        for (PurchaseOrderDetailEntity orderDetailEntity : orderEntity.getPurchaseOrderDetailList()) {
            // 未送货数量大于0
            BigDecimal notShippedNumSum = ComputeUtil.safeSub(orderDetailEntity.getReceiveNum(), orderDetailEntity.getSumSendNum());
            if (ComputeUtil.isGreaterThan(notShippedNumSum, BigDecimal.ZERO)) {
                MaterialDeliveryDetailVO detailVO = BeanMapper.map(orderDetailEntity,MaterialDeliveryDetailVO.class);
                detailVO.setOrderId(orderDetailEntity.getPid());
                detailVO.setOrderDetailId(orderDetailEntity.getId());
                // 订单发货数量默认未发货数量
                detailVO.setDeliveryNum(notShippedNumSum);
                detailVO.setCheckNum(null);
                detailVO.setReceiveNumsSum(orderDetailEntity.getReceiveNum());
                detailVO.setShippedNumSum(orderDetailEntity.getSumSendNum());
                detailVO.setId(null);
                list.add(detailVO);
            }
        }
        vo.setMaterialDeliveryDetailList(list);
        return vo;
    }

    /**
     * 根据orderId查询当前订单下已送货的材料数量
     *
     * @param orderId 订单id
     * @return 已送货材料数量
     */
    @Override
    public Map<Long, BigDecimal> sumDeliveredGroupByDetailId(Long orderId) {
        // 查询送货单
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orderId", new Parameter(QueryParam.EQ, orderId));
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                        BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<MaterialDeliveryEntity> deliveryList = super.queryList(queryParam);
        logger.info("已送货的送货单信息：{}", JSONObject.toJSONString(deliveryList));
        Map<Long, BigDecimal> map = new HashMap<>();
        if (CollectionUtils.isNotEmpty(deliveryList)) {
            List<Long> deliveryIdList = new ArrayList<>();
            for (MaterialDeliveryEntity entity : deliveryList) {
                deliveryIdList.add(entity.getId());
            }
            // 查询子表信息
            // 送货单已送货的明细
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("deliveryId", new Parameter(QueryParam.IN, deliveryIdList));
            List<MaterialDeliveryDetailEntity> deliveryDetailList = deliveryDetailService.queryList(detailParam);
            // 对送货单相同明细进行计算
            for (MaterialDeliveryDetailEntity detail : deliveryDetailList) {
                Long orderDetailId = detail.getOrderDetailId();
                if (map.containsKey(orderDetailId)) {
                    BigDecimal sum = detail.getDeliveryNum().add(map.get(orderDetailId));
                    map.put(orderDetailId, sum);
                }
                else {
                    map.put(orderDetailId, detail.getDeliveryNum());
                }
            }
        }
        return map;
    }

    /**
     * 处理终审后事件
     *
     * @param id 送货单id
     */
    @Override
    public MaterialDeliveryVO saveCommitAfter(Long id) {
        logger.info("进入推送送货单方法>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        // 状态修改为待验收
        MaterialDeliveryEntity materialDeliveryEntity = super.selectById(id);
        // 查询订单是否已关闭
        Long orderId = materialDeliveryEntity.getOrderId();
        PurchaseOrderEntity orderEntity = orderService.selectById(orderId);
//        if (CloseFlagEnum.CLOSE.getCode().equals(orderEntity.getOrderFlag())) {
//            throw new BusinessException("订单已关闭，提交失败！");
//        }

        materialDeliveryEntity.setCheckStatus(DeliverCheckStateEnum.WAIT_CHECK.getCode());
        // 单据状态手动修改为已提交
        materialDeliveryEntity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
        super.saveOrUpdate(materialDeliveryEntity, false);
        // 校验订单下的所有送货单数量，是否已经送完
        // 查询订单
        Map<Long, BigDecimal> map = this.sumDeliveredGroupByDetailId(orderId);
        logger.info("已送货材料信息：{}", JSONObject.toJSONString(map));
        Integer orderDeliverState = OrderDeliverStateEnum.PART_DELIVERED.getCode();
        // 全部送货的材料数量
        int fullFlag = 0;
        // 对订单明细计算
        for (PurchaseOrderDetailEntity entity : orderEntity.getPurchaseOrderDetailList()) {
            // 如果接收数量是0，则不用送货，此条材料计算为已送货的材料
            if (BigDecimal.ZERO.compareTo(entity.getReceiveNum()) == 0) {
                fullFlag++;
                continue;
            }
            BigDecimal delivery = map.get(entity.getId());
            // 送货单送货数量为空，代表该材料没有送，则肯定是部分送货
            if (delivery == null) continue;
            entity.setSumSendNum(delivery); // 送货数量
            // a > b，代表该材料送货数量大于等于接收数量
            if (delivery.compareTo(entity.getReceiveNum()) > -1) {
//                fullFlag = true;
                fullFlag++;
//                entity.setNotShippedNumSum(BigDecimal.ZERO); // 未送货数量
            }
            // a < b，代表有材料未送完
            else {
//                fullFlag = false;
//                entity.setNotShippedNumSum(entity.getReceiveNumsSum().subtract(delivery)); // 未送货数量
            }
        }
        // 如果全部送货的材料数量 = 接收的材料数量，则全部送货
        if (fullFlag > 0 && fullFlag == orderEntity.getPurchaseOrderDetailList().size()) {
            orderDeliverState = OrderDeliverStateEnum.FULL_DELIVERED.getCode();
        }
        // 状态不同切订单状态不为已送货
        if (!orderDeliverState.equals(orderEntity.getOrderState())
                && !OrderDeliverStateEnum.FULL_DELIVERED.getCode().equals(orderEntity.getOrderState())) {
            orderEntity.setOrderState(orderDeliverState);
        }
        orderService.saveOrUpdate(orderEntity, false);
//        logger.info("剩余订单信息：{}", JSONObject.toJSONString(orderEntity));
////			String url = "delivery/supplierPushDelivery";
//        logger.info("开始通知施工方发货单信息>>>>>>>>>>>>>>>>>>>");
////        String url = pushMaterialDelivery;
//        String url = InteractiveConstants.PUSH_MATERIAL_DELIVERY;
//        MaterialDeliveryTbVO tbVO = BeanMapper.map(materialDeliveryEntity, MaterialDeliveryTbVO.class);
//        tbVO.setSourceId(materialDeliveryEntity.getId());
//        tbVO.setMaterialDeliveryDetailList(null);
//        if (CollectionUtils.isNotEmpty(materialDeliveryEntity.getMaterialDeliveryDetailList())) {
//            List<MaterialDeliveryDetailTbVO> tbVOList = new ArrayList<>();
//            for (MaterialDeliveryDetailEntity deliveryDetailEntity : materialDeliveryEntity
//                    .getMaterialDeliveryDetailList()) {
//                MaterialDeliveryDetailTbVO detailTbVO = BeanMapper.map(deliveryDetailEntity,
//                        MaterialDeliveryDetailTbVO.class);
//                detailTbVO.setSourceId(materialDeliveryEntity.getId());
//                detailTbVO.setSourceDetailId(deliveryDetailEntity.getId());
//                tbVOList.add(detailTbVO);
//            }
//            tbVO.setMaterialDeliveryDetailList(tbVOList);
//        }
//        String postData = JSONObject.toJSONString(tbVO);
//        String systemId = materialDeliveryEntity.getSystemId();
//        logger.info("发送参数===url:{},postData:[{}],systemId:{}", url, postData, systemId);
//        CommonResponse<String> commonResponse = systemDataPushService
//                .exchangeDataWithThirdSystem(url, RequestMethod.POST, postData, systemId);
//        CommonUtils.checkCommonResponse(commonResponse, logger);
//        logger.info("通知施工方发货单信息结束<<<<<<<<<<<<<<<<<<<<");
//
//        logger.info("开始通知施工方订单送货状态>>>>>>>>>>>>>>>>>>>");
////        String orderUrl = pushMaterialOrderDeliver;
//        String orderUrl = InteractiveConstants.PUSH_MATERIAL_ORDER_DELIVER;
//        MaterialOrderVO orderVO = new MaterialOrderVO();
//        orderVO.setId(orderEntity.getId());
//        orderVO.setDeliverState(orderEntity.getDeliverState());
//        String orderPostData = JSONObject.toJSONString(orderVO);
//        CommonResponse<String> orderCommonResponse = systemDataPushService
//                .exchangeDataWithThirdSystem(orderUrl, RequestMethod.POST, orderPostData, systemId);
//        CommonUtils.checkCommonResponse(orderCommonResponse, logger);
//        logger.info("通知施工方订单送货状态结束<<<<<<<<<<<<<<<<<<<");
//        logger.info("推送送货单方法结束<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return BeanMapper.map(materialDeliveryEntity, MaterialDeliveryVO.class);
    }

    @Override
    public void writeBack(List<InstoreMaterialVO> storeList, boolean flag) {
        if(CollectionUtils.isEmpty(storeList)){
            return;
        }
        Map<Long, List<InstoreMaterialVO>> storeMap = storeList.stream().collect(Collectors.groupingBy(InstoreMaterialVO::getSourceMainId));
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, new ArrayList<>(storeMap.keySet())));
        List<MaterialDeliveryEntity> list = super.queryList(param);
        if(CollectionUtils.isEmpty(list)){
            return;
        }
        Map<Long, MaterialDeliveryEntity> map = list.stream().collect(Collectors.toMap(x->x.getId(), x->x));
        List<Long> ids = list.stream().map(x->x.getId()).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("deliveryId", new Parameter(QueryParam.IN, ids));
        List<MaterialDeliveryDetailEntity> detailList = deliveryDetailService.queryList(queryParam);
        Map<Long, List<MaterialDeliveryDetailEntity>> detailMap = detailList.stream().collect(Collectors.groupingBy(MaterialDeliveryDetailEntity::getDeliveryId));

        List<Long> detailIds = detailList.stream().map(x->x.getId()).collect(Collectors.toList());
        Map<String, Map<Long, BigDecimal>> storeNumMap = this.getInStoreNumMap(detailIds);

        for(Long id : map.keySet()){
            MaterialDeliveryEntity entity = map.get(id);
            // 子表为空，默认全部入库
            if(!detailMap.containsKey(id)){
                entity.setStoreStatus(StoreStatusEnum.FULL_STORE.getCode());
                continue;
            }
            Map<Long, BigDecimal> numMap = new HashMap<>();
            if(storeNumMap.containsKey(String.valueOf(id))){
                numMap = storeNumMap.get(String.valueOf(id));
            }
            Integer status = StoreStatusEnum.WAIT_STORE.getCode();
            // 全部入库的数量
            int fullFlag = 0;
            for (MaterialDeliveryDetailEntity detail : detailMap.get(id)) {
                // 如果送货数量是0，则不用入库，此条材料计算为已入库
                if (ComputeUtil.isEmpty(detail.getDeliveryNum())) {
                    fullFlag++;
                    continue;
                }
                // 数量为空，代表该材料没有入库
                if(!numMap.containsKey(detail.getId())){
                    continue;
                }
                BigDecimal num = numMap.get(detail.getId());
                // 入库数量大于等于送货数量为已入库
                if (ComputeUtil.isGreaterOrEqual(num, detail.getDeliveryNum())) {
                    fullFlag++;
                }
            }
            Integer size = detailMap.get(id).size();
            if (fullFlag > 0) {
                if (fullFlag == size) {
                    status = StoreStatusEnum.FULL_STORE.getCode();
                } else {
                    status = StoreStatusEnum.PART_STORE.getCode();
                }
            }
            entity.setStoreStatus(status);
        }
        super.saveOrUpdateBatch(map.values());
    }

    @Override
    public List<MaterialDeliveryDetailVO> querySubData(IPage<MaterialDeliveryDetailEntity> pageData, QueryParam queryParam) {
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<MaterialDeliveryDetailVO> list = baseMapper.querySubData(pageData, wrapper);
        return list;
    }

    /**
     * 根据发货单明细id查询对应已入库数量
     *
     * @param ids 发货单明细id
     * @return 已入库数量
     */
    private Map<String, Map<Long, BigDecimal>> getInStoreNumMap(List<Long> ids) {
        if(CollectionUtils.isEmpty(ids)){
            return new HashMap<>();
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter(QueryParam.IN, ids));
        List<InstoreMaterialEntity> storeList = storeMaterialService.queryList(queryParam);
        if(CollectionUtils.isEmpty(storeList)){
            return new HashMap<>();
        }
        Set<Long> storeIds = storeList.stream().map(InstoreMaterialEntity::getStoreId).collect(Collectors.toSet());
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, new ArrayList<>(storeIds)));
        List<InstoreEntity> list = storeService.queryList(param);
        List<Long> pid = list.stream().map(x->x.getId()).collect(Collectors.toList());
        storeList = storeList.stream().filter(x->pid.contains(x.getStoreId())).collect(Collectors.toList());

        Map<String, Map<Long, BigDecimal>> result = storeList.stream().collect(Collectors.groupingBy(InstoreMaterialEntity::getSourceMainId,
                Collectors.toMap(InstoreMaterialEntity::getSourceId, InstoreMaterialEntity::getInstoreNumber, ComputeUtil::safeAdd)));
        return result;
    }

}
