package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/10 采购结算单 主表
 * @Description PurchaseSettlementEntity
 */
@TableName("ejc_material_purchase_settlement")
public class PurchaseSettlementEntity extends BaseEntity {
    /**
     * 单据状态
     */
    @TableField(value = "bill_state")
    private Integer billState;

    /**
     * 结算编号
     */
    @TableField(value = "bill_code")
    private String billCode;

    /**
     * 合同名称
     */
    @TableField(value = "contract_name")
    private String contractName;

    /**
     * 合同id
     */
    @TableField(value = "contract_id")
    private Long contractId;

    /**
     * 合同采购方式
     */
    @TableField(value = "purchase_method")
    private String purchaseMethod;

    /**
     * 属于项目 ？ 1是，0不是
     */
    @TableField(value = "belong_to_project")
    private String belongToProject;

    /**
     * 项目名称
     */
    @TableField(value = "project_name")
    private String projectName;

    /**
     * 所属项目编码
     */
    @TableField(value = "project_code")
    private String projectCode;

    /**
     * 项目名称参照
     */
    @TableField(value = "project_id")
    private Long projectId;

    /**
     * 所属组织名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 所属组织参照
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 结算日期
     */
    @TableField(value = "settlement_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settlementDate;

    /**
     * 经办人
     */
    @TableField(value = "employee_id")
    private Long employeeId;

    /**
     * 经办人名称
     */
    @TableField(value = "employee_name")
    private String employeeName;

    /**
     * 本期结算金额（含税）
     */
    @TableField(value = "current_settlement_amount_tax")
    private BigDecimal currentSettlementAmountTax;

    /**
     * 累计预付款
     */
    @TableField(value = "accumulated_advance_payment")
    private BigDecimal accumulatedAdvancePayment;

    /**
     * 本期冲抵金额
     */
    @TableField(value = "offset_amount_in_current_period")
    private BigDecimal offsetAmountInCurrentPeriod;

    /**
     * 剩余冲抵金额
     */
    @TableField(value = "remaining_offset_amount")
    private BigDecimal remainingOffsetAmount;

    /**
     * 备注
     */
    @TableField(value = "memo")
    private String memo;

    /**
     * 编制人
     */
    @TableField(value = "creator_name")
    private String creatorName;

    /**
     * 供应商id
     */
    @TableField(value = "supplier_id")
    private Long supplierId;

    /**
     * 供应商名称
     */
    @TableField(value = "supplier_name")
    private String supplierName;

    /**
     * 合同金额
     */
    @TableField(value = "contract_amount")
    private BigDecimal contractAmount;

    /**
     * 税率
     */
    @TableField(value = "taxRate")
    private BigDecimal taxRate;

    /**
     * 本期结算金额（不含税）
     */
    @TableField(value = "current_settlement_amount")
    private BigDecimal currentSettlementAmount;

    /**
     * 税金
     */
    @TableField(value = "tax")
    private BigDecimal tax;

    /**
     * 已结算金额
     */
    @TableField(value = "settled_amount")
    private BigDecimal settledAmount;

    /**
     * 含本期已结算金额
     */
    @TableField(value="sum_settled_amount")
    private BigDecimal sumSettledAmount;

    /**
     * 已结算比例
     */
    @TableField(value = "settled_proportion")
    private BigDecimal settledProportion;

    /**
     * 累计已申请金额(资金返写，累计值)
     */
    @TableField(value = "current_apply_amount")
    private BigDecimal currentApplyAmount;

    /**
     * 剩余可以申请金额 = 本期结算金额（含税）-累计已申请金额-本期抵扣金额
     * 初始化时候，此值=本期结算金额（含税）-本期抵扣金额
     */
    @TableField(value = "remain_can_apply_amount")
    private BigDecimal remainCanApplyAmount;

    /**
     * 本期已付金额(资金返写，累计值)
     */
    @TableField(value = "current_paid_amount")
    private BigDecimal currentPaidAmount;

    /**
     * 已付金额(该合同截止到本期已付金额)
     */
    @TableField(value = "paid_amount")
    private BigDecimal paidAmount;

    /**
     * 已付比例
     */
    @TableField(value = "paid_proportion")
    private BigDecimal paidProportion;


    /**
     * 成本关联科目状态(1:是，0：否)
     */
    @TableField(value = "relation_flag")
    private String relationFlag = "0";

    /**
     * 成本分摊状态(1:是，0：否)
     */
    @TableField(value = "proportion_flag")
    private String proportionFlag = "0";

    @TableField(exist = false)
    @SubEntity(serviceName = "purchaseSettlementMaterialDetailService")
    private List<PurchaseSettlementMaterialDetailEntity> materialDetails = new ArrayList<>();

    @TableField(exist = false)
    @SubEntity(serviceName = "purchaseSettlementOtherFeeService")
    private List<PurchaseSettlementOtherFeeEntity> feeEntities = new ArrayList<>();

    @TableField(value = "settle_type")
    private String settleType; // 结算类型，0-过程结算，1-最终结算

    /**
     * 已收票金额
     */
    @TableField(value = "sum_invoice_tax_mny")
    private BigDecimal sumInvoiceTaxMny;

    @TableField(value="brand_id")
    private Long brandId; // 品牌id
    @TableField(value="brand_name")
    private String brandName; // 品牌
    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }
    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }
    public BigDecimal getSumInvoiceTaxMny() {
        return sumInvoiceTaxMny;
    }

    public void setSumInvoiceTaxMny(BigDecimal sumInvoiceTaxMny) {
        this.sumInvoiceTaxMny = sumInvoiceTaxMny;
    }

    public String getSettleType() {
        return settleType;
    }

    public void setSettleType(String settleType) {
        this.settleType = settleType;
    }

    public BigDecimal getSumSettledAmount() {
        return sumSettledAmount;
    }

    public void setSumSettledAmount(BigDecimal sumSettledAmount) {
        this.sumSettledAmount = sumSettledAmount;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getPurchaseMethod() {
        return purchaseMethod;
    }

    public void setPurchaseMethod(String purchaseMethod) {
        this.purchaseMethod = purchaseMethod;
    }

    public String getBelongToProject() {
        return belongToProject;
    }

    public void setBelongToProject(String belongToProject) {
        this.belongToProject = belongToProject;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

	public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Date getSettlementDate() {
        return settlementDate;
    }

    public void setSettlementDate(Date settlementDate) {
        this.settlementDate = settlementDate;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public BigDecimal getCurrentSettlementAmountTax() {
        return currentSettlementAmountTax;
    }

    public void setCurrentSettlementAmountTax(BigDecimal currentSettlementAmountTax) {
        this.currentSettlementAmountTax = currentSettlementAmountTax;
    }

    public BigDecimal getAccumulatedAdvancePayment() {
        return accumulatedAdvancePayment;
    }

    public void setAccumulatedAdvancePayment(BigDecimal accumulatedAdvancePayment) {
        this.accumulatedAdvancePayment = accumulatedAdvancePayment;
    }

    public BigDecimal getOffsetAmountInCurrentPeriod() {
        return offsetAmountInCurrentPeriod;
    }

    public void setOffsetAmountInCurrentPeriod(BigDecimal offsetAmountInCurrentPeriod) {
        this.offsetAmountInCurrentPeriod = offsetAmountInCurrentPeriod;
    }

    public BigDecimal getRemainingOffsetAmount() {
        return remainingOffsetAmount;
    }

    public void setRemainingOffsetAmount(BigDecimal remainingOffsetAmount) {
        this.remainingOffsetAmount = remainingOffsetAmount;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getCreatorName() {
        return creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getCurrentSettlementAmount() {
        return currentSettlementAmount;
    }

    public void setCurrentSettlementAmount(BigDecimal currentSettlementAmount) {
        this.currentSettlementAmount = currentSettlementAmount;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getSettledAmount() {
        return settledAmount;
    }

    public void setSettledAmount(BigDecimal settledAmount) {
        this.settledAmount = settledAmount;
    }

    public BigDecimal getSettledProportion() {
        return settledProportion;
    }

    public void setSettledProportion(BigDecimal settledProportion) {
        this.settledProportion = settledProportion;
    }

    public BigDecimal getCurrentApplyAmount() {
        return currentApplyAmount;
    }

    public void setCurrentApplyAmount(BigDecimal currentApplyAmount) {
        this.currentApplyAmount = currentApplyAmount;
    }

    public BigDecimal getRemainCanApplyAmount() {
        return remainCanApplyAmount;
    }

    public void setRemainCanApplyAmount(BigDecimal remainCanApplyAmount) {
        this.remainCanApplyAmount = remainCanApplyAmount;
    }

    public BigDecimal getCurrentPaidAmount() {
        return currentPaidAmount;
    }

    public void setCurrentPaidAmount(BigDecimal currentPaidAmount) {
        this.currentPaidAmount = currentPaidAmount;
    }

    public BigDecimal getPaidAmount() {
        return paidAmount;
    }

    public void setPaidAmount(BigDecimal paidAmount) {
        this.paidAmount = paidAmount;
    }

    public BigDecimal getPaidProportion() {
        return paidProportion;
    }

    public void setPaidProportion(BigDecimal paidProportion) {
        this.paidProportion = paidProportion;
    }

    public List<PurchaseSettlementMaterialDetailEntity> getMaterialDetails() {
        return materialDetails;
    }

    public void setMaterialDetails(List<PurchaseSettlementMaterialDetailEntity> materialDetails) {
        this.materialDetails = materialDetails;
    }

    public List<PurchaseSettlementOtherFeeEntity> getFeeEntities() {
        return feeEntities;
    }

    public void setFeeEntities(List<PurchaseSettlementOtherFeeEntity> feeEntities) {
        this.feeEntities = feeEntities;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }
}
