package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.material.bean.PurchaseOrderDetailEntity;
import com.ejianc.business.material.bean.PurchaseOrderEntity;
import com.ejianc.business.material.bean.UseApplySubEntity;
import com.ejianc.business.material.mapper.PurchaseOrderMapper;
import com.ejianc.business.material.service.IPurchaseOrderService;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.vo.*;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.bean.MaterialMasterPlanSubEntity;
import com.ejianc.business.plan.mapper.MaterialMasterPlanMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanSubMapper;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 采购订单
 *
 * @author generator
 *
 */
@Service("purchaseOrderService")
public class PurchaseOrderServiceImpl extends BaseServiceImpl<PurchaseOrderMapper, PurchaseOrderEntity> implements IPurchaseOrderService {

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IUseApplyService useApplyService;

    @Autowired
    private MaterialMasterPlanMapper materialMasterPlanMapper;
    @Autowired
    private MaterialMasterPlanSubMapper materialMasterPlanSubMapper;


    //用料申请量
    private static String PARAM_APPLY_CONTROL_COUNT = "P-8S560862";

    //总计划量
    private static String PARAM_PLAN_CONTROL_COUNT = "P-93M6k263";

    @Override
    public ParamsCheckVO checkParams(PurchaseOrderVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        List<PurchaseOrderDetailVO> purchaseOrderDetailList = vo.getPurchaseOrderDetailList();
        String[] paramsArray = {"none", "warn", "alert"};
        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());

        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType(paramsArray[0]);
        if (CollectionUtils.isNotEmpty(purchaseOrderDetailList) && (int) purchaseOrderDetailList.stream().filter(in -> in.getMaterialId() != null).count() > 0) {
            purchaseOrderDetailList = purchaseOrderDetailList.stream().filter(in -> in.getMaterialId() != null).collect(Collectors.toList());

            //当前表单同类物资合计
            Map<Long, PurchaseOrderDetailVO> thisMap = new HashMap<>();
            purchaseOrderDetailList.forEach(item -> {
                if (thisMap.containsKey(item.getMaterialId())) {
                    PurchaseOrderDetailVO purchaseOrderDetailVO = thisMap.get(item.getMaterialId());
                    purchaseOrderDetailVO.setOrderNum(ComputeUtil.nullToZero(ComputeUtil.safeAdd(purchaseOrderDetailVO.getOrderNum(), item.getOrderNum())));
                } else {
                    thisMap.put(item.getMaterialId(), item);
                }
            });

            List<Long> materialIds = new ArrayList<>(thisMap.keySet());

            //【物资总计划量】控制【采购订单量】
            CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_CONTROL_COUNT, curOrgId);
            if (!response.isSuccess()) {
                throw new BusinessException("【物资总计划量】控制【采购订单量】，获取控制参数失败，失败原因：" + response.getMsg());
            }
            List<BillParamVO> billParamVOS = response.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS)) {
                // 根据项目取得总计划数据
                Long projectId = vo.getProjectId();
                QueryWrapper<MaterialMasterPlanEntity> wrapper = new QueryWrapper<>();
                wrapper.eq("project_id", projectId);
                List<MaterialMasterPlanEntity> materialMasterPlanEntities = materialMasterPlanMapper.selectList(wrapper);

                Map<Long, BigDecimal> planMap = new HashMap<>();
                if (CollectionUtils.isNotEmpty(materialMasterPlanEntities)) {
                    QueryWrapper<MaterialMasterPlanSubEntity> planSubWrapper = new QueryWrapper<>();
                    List<Long> planIds = materialMasterPlanEntities.stream().map(MaterialMasterPlanEntity::getId).collect(Collectors.toList());
                    planSubWrapper.in("material_master_plan_id", planIds);
                    List<MaterialMasterPlanSubEntity> materialMasterPlanSubEntities = materialMasterPlanSubMapper.selectList(planSubWrapper);
                    materialMasterPlanSubEntities.forEach(item -> {
                        Double num = item.getNum();
                        if (planMap.get(item.getMaterialId()) != null) {
                            planMap.put(item.getMaterialId(), ComputeUtil.safeAdd(BigDecimal.valueOf(num), planMap.get(item.getMaterialId())));
                        } else {
                            planMap.put(item.getMaterialId(), ComputeUtil.toBigDecimal(num));
                        }
                    });
                }
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                        //获取已生效的量
                        List<MaterialPriceVO> vos = baseMapper.queryMaterialOrderCount(vo.getId(), vo.getProjectId(), materialIds);
                        Map<Long, BigDecimal> numVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                        thisMap.forEach((k, d) -> {
                            BigDecimal num = d.getOrderNum();
                            BigDecimal applyNum = ComputeUtil.nullToZero(planMap.get(d.getMaterialId()));
                            BigDecimal hasNum = ComputeUtil.nullToZero(numVOMap.get(d.getMaterialId()));
                            BigDecimal allNum = ComputeUtil.safeAdd(hasNum, num);
                            //百分比数量
                            BigDecimal _applyNum = applyNum.multiply(divide);
                            if (allNum.compareTo(_applyNum) > 0) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "orderNum");
                                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getModel()) ? " [" + d.getModel() + "]" : ""));
                                paramsCheckDsVO.setWarnName("采购订单量大于物资总计划量");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("该材料本次订单量：").append(num.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("，含本次累计订单量：").append(allNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("，物资总计划量*").append(roleValue).append("%: ").append(_applyNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("。超出数量：").append(ComputeUtil.safeSub(allNum, _applyNum).setScale(2, BigDecimal.ROUND_HALF_UP));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                            }
                        });
                    }
                }
            }

            //【用料申请量】控制【采购订单量】
            CommonResponse<List<BillParamVO>> response3 = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_APPLY_CONTROL_COUNT,curOrgId);
            if (!response3.isSuccess()) {
                throw new BusinessException("【用料申请量】控制【采购订单量】，获取控制参数失败，失败原因：" + response3.getMsg());
            }
            List<BillParamVO> billParamVOS3 = response3.getData();

            if (CollectionUtils.isNotEmpty(billParamVOS3)) {
                for (BillParamVO billParamVO : billParamVOS3) {
                    if (0 != billParamVO.getControlType()) {

                        //获取已生效的量
                        List<MaterialPriceVO> vos = baseMapper.queryMaterialOrderCount(vo.getId(), vo.getProjectId(), materialIds);
                        //获取用料申请量
                        List<MaterialApplyCountVO> applyCountVOS = useApplyService.queryMaterialApplyCount(vo.getProjectId(), materialIds);

                        Map<Long, BigDecimal> numVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                        Map<Long, BigDecimal> applyVOMap = applyCountVOS.stream().collect(Collectors.toMap(MaterialApplyCountVO::getMaterialId, MaterialApplyCountVO::getApplyNum));
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                        thisMap.forEach((k, d) -> {
                            BigDecimal num = d.getOrderNum();
                            BigDecimal applyNum = ComputeUtil.nullToZero(applyVOMap.get(d.getMaterialId()));
                            BigDecimal hasNum = ComputeUtil.nullToZero(numVOMap.get(d.getMaterialId()));
                            BigDecimal allNum = ComputeUtil.safeAdd(hasNum, num);
                            //百分比数量
                            BigDecimal _applyNum = applyNum.multiply(divide);
                            if (allNum.compareTo(_applyNum) > 0) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "orderNum");
                                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getModel()) ? " [" + d.getModel() + "]" : ""));
                                paramsCheckDsVO.setWarnName("采购订单量大于用料申请量");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("该材料本次订单量：").append(num.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("，含本次累计订单量：").append(allNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("，用料申请数量*").append(roleValue).append("%: ").append(_applyNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                        .append("。超出数量：").append(ComputeUtil.safeSub(allNum, _applyNum).setScale(2, BigDecimal.ROUND_HALF_UP));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                            }
                        });
                    }
                }
            }

        }
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            pc.setWarnType("alert");
            pc.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            pc.setWarnType("warn");
            pc.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public List<PurchaseOrderDetailVO> querySubData(IPage<PurchaseOrderDetailEntity> pageData, QueryParam queryParam) {
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<PurchaseOrderDetailVO> list = baseMapper.querySubData(pageData, wrapper);
        return list;
    }

    /**
     * @description: 根据订单id，获取该订单的入库（未结算过的）明细
     *
     * @param orderIdList
     * @return {@link List< InstoreMaterialVO>}
     * @author songlx
     * @date: 2023/4/21
     */
    @Override
    public List<InstoreMaterialVO> getInstoreMaterialByPurchaseOrder(List<Long> orderIdList) {
        return baseMapper.getInstoreMaterialByPurchaseOrder(orderIdList);
    }
}
