package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.utlis.ArchivesUtil;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.plan.bean.BatchPlanEntity;
import com.ejianc.business.plan.bean.BatchPlanSubEntity;
import com.ejianc.business.plan.service.IBatchPlanService;
import com.ejianc.business.plan.service.IBatchPlanSubService;
import com.ejianc.business.plan.vo.BatchPlanSubVO;
import com.ejianc.business.plan.vo.BatchPlanVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.MaterialInsertArchiveVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 批次计划主实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("batchPlan")
public class BatchPlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBatchPlanSubService batchPlanSubService;

    private static final String BILL_CODE = "BATCH_PLAN";//此处需要根据实际修改

    @Autowired
    private IBatchPlanService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ArchivesUtil archivesUtil;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BatchPlanVO> saveOrUpdate(@RequestBody BatchPlanVO saveOrUpdateVO) {
        BatchPlanEntity entity = BeanMapper.map(saveOrUpdateVO, BatchPlanEntity.class);
        UserContext userContext = sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0) {
            if(StringUtils.isNotBlank(saveOrUpdateVO.getBillCode())) {
                //编码重复校验
                BatchPlanVO voByCode = service.queryByCode(saveOrUpdateVO.getBillCode());
                if(null != voByCode && (null == saveOrUpdateVO.getId() || !voByCode.getId().equals(saveOrUpdateVO.getId()))) {
                    return CommonResponse.error("保存失败，编码重复！");
                }
            }else{
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            //设置编制人
            entity.setCreateUserName(userContext.getUserName());
        } else {
            entity.setModifyUserName(userContext.getUserName());
        }

//        //校验项目是否已有批次计划
//        List<BatchPlanEntity> voByProjects = service.queryByProjectId(saveOrUpdateVO.getProjectId(), saveOrUpdateVO.getId());
//        if (CollectionUtils.isNotEmpty(voByProjects)) {
//            return CommonResponse.error("保存失败，该项目下已存在未生效的物资批次计划，请勿重复添加！");
//        }
        long id = IdWorker.getId();
        if (entity.getId() == null) {
            entity.setId(id);
        }
        List<BatchPlanSubVO> batchPlanSubVOList = saveOrUpdateVO.getBatchPlanSubList();
        if (CollectionUtils.isNotEmpty(batchPlanSubVOList)) {
            for (BatchPlanSubVO batchPlanSubVO : batchPlanSubVOList) {
                String onlykey = batchPlanSubVO.getMaterialCategoryName() + batchPlanSubVO.getMaterialName() + batchPlanSubVO.getUnit() + batchPlanSubVO.getSpec()+batchPlanSubVO.getMaterialCode();
                batchPlanSubVO.setOnlyKey(onlykey);
            }
            MaterialInsertArchiveVO archiveVO = new MaterialInsertArchiveVO(null, entity.getId(), entity.getBillCode(), "物资批次计划");
            JSONObject jsonObject = archivesUtil.batchSaveArchive(archiveVO, batchPlanSubVOList, "materialCategoryId", "materialId",
                    "materialCategoryName", "materialName", "materialCode","unit", "spec", "errorMessage");
            String sourceList = JSON.toJSONString(jsonObject.get("sourceList"), SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat);
            List<BatchPlanSubVO> list = JSON.parseArray(sourceList, BatchPlanSubVO.class);
            List<BatchPlanSubEntity> batchPlanSubEntities = BeanMapper.mapList(list, BatchPlanSubEntity.class);
            entity.setBatchPlanSubList(batchPlanSubEntities);
        }

        service.saveOrUpdate(entity, false);
        BatchPlanVO vo = BeanMapper.map(entity, BatchPlanVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /***
     * @description: 参数校验
     * @param vo
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.ParamsCheckVO>
     */
    @RequestMapping(value = "/checkAllParams", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkAllParams(@RequestBody BatchPlanVO vo){
        ParamsCheckVO paramsCheckVO = service.checkAllParams(vo);
        return CommonResponse.success("参数校验成功！", paramsCheckVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BatchPlanVO> queryDetail(Long id) {
    	BatchPlanEntity entity = service.selectById(id);
    	BatchPlanVO vo = BeanMapper.map(entity, BatchPlanVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BatchPlanVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (BatchPlanVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(BatchPlanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BatchPlanVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("createUserName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        IPage<BatchPlanEntity> page = service.queryPage(param,false);
        IPage<BatchPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BatchPlanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * 校验项目是否可保存为批次计划
     * @param projectId
     * @return
     */
    @GetMapping(value = "projectPlanCheck")
    @ResponseBody
    public CommonResponse<String> projectPlanCheck(@RequestParam(value = "projectId") Long projectId,
                                                   @RequestParam(value = "billId", required = false) Long billId) {
        QueryWrapper<BatchPlanEntity> query = new QueryWrapper<>();
        if(billId!=null){
            query.notIn("id", billId);
        }
        query.eq("project_id", projectId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.notIn("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<BatchPlanEntity> entityByProjects = service.list(query);
        if(CollectionUtils.isNotEmpty(entityByProjects)) {
            return CommonResponse.error("该项目下已存在未生效的物资批次计划！");
        }
        return CommonResponse.success("该项目适用当前批次计划！");
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BatchPlanEntity> list = service.queryList(param);
        List<BatchPlanVO> exportVOS = new ArrayList<>();
        list.forEach(item -> {
            BatchPlanVO vo = BeanMapper.map(item, BatchPlanVO.class);
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            exportVOS.add(vo);
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", exportVOS);
        ExcelExport.getInstance().export("batchPlanExport.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refBatchPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BatchPlanSubVO>> refBatchPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        IPage<BatchPlanSubVO> resp = new Page<>();
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        //按照物资Id正序排列
        param.getOrderMap().put("id", QueryParam.ASC);

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //只查询审批通过的合同
        if(StringUtils.isBlank(condition)) {
            return CommonResponse.error("查询失败，参数中缺少condition！");
        }
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        if(null == conditionMap.get("projectId")) {
            return CommonResponse.error("查询失败，参数condition中缺少项projectId！");
        }
        List<Integer> approvedBillState = new ArrayList<>();
        QueryWrapper<BatchPlanEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", conditionMap.get("projectId"));
        //查询审批通过
        approvedBillState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        approvedBillState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryWrapper.in("bill_state", approvedBillState);
        List<BatchPlanEntity> entitys = service.list(queryWrapper);
        if(CollectionUtils.isEmpty(entitys)) {
            resp.setTotal(0L);
            resp.setSize(pageSize);
            resp.setCurrent(pageNumber);
            resp.setRecords(new ArrayList<>());
            resp.setPages(0);
        } else {
            //param.getParams().put("planId", new Parameter(QueryParam.EQ, entitys.get(0).getId()));
            Page<BatchPlanSubVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
            QueryWrapper wrapper = changeToQueryWrapper(param);
            wrapper.eq("dr",0);
            wrapper.eq("project_id",conditionMap.get("projectId"));
            wrapper.in("bill_state",Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode()));
            //wrapper.apply("(count + applyNum) < num ");
            wrapper.groupBy("material_id","part_name");
            wrapper.having("(count + applyNum) < num ");
            List<BatchPlanSubVO> list =  batchPlanSubService.queryPlanSubList(page,wrapper);
            IPage<BatchPlanSubVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(list);
            resp.setPages(pageData.getPages());
            resp.setCurrent(pageData.getCurrent());
            resp.setTotal(pageData.getTotal());
            resp.setSize(pageData.getSize());

            List<BatchPlanSubVO> dataList = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(pageData.getRecords())) {
                dataList = BeanMapper.mapList(pageData.getRecords(), BatchPlanSubVO.class);
                for (BatchPlanSubVO vo :dataList) {
                    // 剩余数量 = 计划量-申请量-合同量
                    BigDecimal num_temp = ComputeUtil.safeSub(vo.getNum(), vo.getApplyNum());
                    BigDecimal surplusNum = ComputeUtil.safeSub(num_temp, vo.getCount());
                    vo.setSurplusNum(surplusNum);
                }
            }
            resp.setRecords(dataList);
        }
        return CommonResponse.success("查询参照数据成功！", resp);
    }


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "batch-plan-material-import.xlsx", "物料导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     *
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<BatchPlanSubVO> successList = new ArrayList<>();
            List<BatchPlanSubVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 9) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    BatchPlanSubVO batchPlanSubVO = new BatchPlanSubVO();
                    if (StringUtils.isBlank(datas.get(1))) {
                        batchPlanSubVO.setErrorMessage("物资名称为必填项");
                    } else {
                        String materialCategoryName = datas.get(0).toString().trim();
                        batchPlanSubVO.setMaterialCategoryName(materialCategoryName);
                    }
                    if (StringUtils.isBlank(datas.get(1))) {
                        batchPlanSubVO.setErrorMessage("物资名称为必填项");
                    } else if (datas.get(1).length() > 30) {
                        batchPlanSubVO.setErrorMessage("物资名称填写长度为0~30字");
                    } else {
                        batchPlanSubVO.setMaterialName(datas.get(1).trim());
                    }
                    if (StringUtils.isBlank(datas.get(2))) {
                        batchPlanSubVO.setErrorMessage("规格型号为必填项");
                    } else if (datas.get(2).length() > 200) {
                        batchPlanSubVO.setErrorMessage("规格型号填写长度为0~200字");
                    } else {
                        batchPlanSubVO.setSpec(datas.get(2).trim());
                    }
                    if (!Objects.isNull(datas.get(3))) {
                        batchPlanSubVO.setUnit(datas.get(3).trim());
                    }

                    batchPlanSubVO.setSupplierName(datas.get(4));
                    if (StringUtils.isNotBlank(datas.get(7)) && datas.get(7).length() > 64) {
                        batchPlanSubVO.setErrorMessage("物料编码填写长度为0~64字");
                    } else {
                        batchPlanSubVO.setMaterialCode(datas.get(7));
                    }
                    if (StringUtils.isNotBlank(datas.get(8)) && datas.get(8).length() > 50) {
                        batchPlanSubVO.setErrorMessage("备注填写长度为0~50字");
                    } else {
                        batchPlanSubVO.setMemo(datas.get(8));
                    }
                    batchPlanSubVO.setSourceType("3");
                    if (StringUtils.isNotBlank(datas.get(5))) {
                        try {
                            batchPlanSubVO.setNum(new BigDecimal(datas.get(5)));
                            if (batchPlanSubVO.getNum().longValue() < 0) {
                                batchPlanSubVO.setErrorMessage("数量必须大于0");
                            }
                        } catch (Exception e) {
                            batchPlanSubVO.setErrorMessage("数量必须为数字");
                        }
                    } else {
                        batchPlanSubVO.setErrorMessage("数量为必填项");
                    }
                    if (StringUtils.isNotBlank(datas.get(6))) {
                        try {
                            batchPlanSubVO.setPrice(ComputeUtil.scale(new BigDecimal(datas.get(6)), 8));
                            if (batchPlanSubVO.getPrice().doubleValue() < 0) {
                                batchPlanSubVO.setErrorMessage("单价必须大于0");
                            }
                        } catch (Exception e) {
                            batchPlanSubVO.setErrorMessage("单价为必须为数字");
                        }
                    } else {
                        batchPlanSubVO.setPrice(new BigDecimal(0));
                    }
                    if (batchPlanSubVO.getNum() != null && batchPlanSubVO.getPrice() != null) {
                        BigDecimal amount = batchPlanSubVO.getPrice().multiply(batchPlanSubVO.getNum());
                        batchPlanSubVO.setMny(amount);
                    }
                    if (StringUtils.isBlank(batchPlanSubVO.getErrorMessage())) {
                        //通过物料名称、规格、计量单位获取物料
//                        MaterialVO vo = new MaterialVO();
//                        vo.setName(instoreMaterialVO.getMaterialName());
//                        vo.setSpec(instoreMaterialVO.getMaterialSpec());
//                        vo.setUnitName(instoreMaterialVO.getMaterialUnit());
//                        CommonResponse<List<MaterialVO>> listCommonResponse = materialApi.queryMaterialList(vo);
//                        if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty(listCommonResponse.getData())) {
//                            MaterialVO materialVo = listCommonResponse.getData().get(0);
//                            instoreMaterialVO.setMaterialCategoryId(materialVo.getCategoryId());
//                            instoreMaterialVO.setMaterialCategoryName(materialVo.getCategoryName());
//                            instoreMaterialVO.setMaterialId(materialVo.getId());
                        String onlykey = batchPlanSubVO.getMaterialCategoryName() + batchPlanSubVO.getMaterialName() + batchPlanSubVO.getUnit() + batchPlanSubVO.getSpec();
                        batchPlanSubVO.setOnlyKey(onlykey);
                        successList.add(batchPlanSubVO);
//                            continue;
//
//                        } else {
//                            instoreMaterialVO.setErrorMessage("该物资不存在");
//                        }
                        batchPlanSubVO.setId((long) i);
//                        errorList.add(instoreMaterialVO);
                    } else {
                        errorList.add(batchPlanSubVO);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(successList)) {
                JSONObject match = archivesUtil.findMatch(successList, "materialCategoryId", "materialId",
                        "materialCategoryName", "materialName", "materialCode","unit", "spec", "errorMessage");
                successList = (List<BatchPlanSubVO>) match.get("sourceList");
                List<BatchPlanSubVO> errorList1 = (List<BatchPlanSubVO>) match.get("errorList");
                errorList.addAll(errorList1);
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

}
