package com.ejianc.business.delivery.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.delivery.bean.MaterialDeliveryDetailEntity;
import com.ejianc.business.delivery.bean.MaterialDeliveryEntity;
import com.ejianc.business.delivery.vo.MaterialDeliveryDetailVO;
import com.ejianc.business.delivery.vo.MaterialDeliveryVO;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 消耗材送货单
 *
 * @author generator
 */
public interface IMaterialDeliveryService extends IBaseService<MaterialDeliveryEntity> {

    /**
     * 查询送货单
     *
     * @param param 查询参数
     * @return 查询结果
     */
    IPage<MaterialDeliveryVO> queryDeliverList(QueryParam param);

    /**
     * 保存、修改送货单
     *
     * @param saveOrUpdateVO 送货单数据
     * @return 保存数据
     */
    MaterialDeliveryVO saveDeliver(MaterialDeliveryVO saveOrUpdateVO);

    /**
     * 变更送货单状态
     *
     * @param saveOrUpdateVO 需要变更的送货单信息
     * @return 变更结果
     */
    Boolean updateDeliverState(MaterialDeliveryVO saveOrUpdateVO);

    /**
     * 根据订单初始化送货单详情
     *
     * @param orderId 订单id
     * @return 送货单详情
     */
    MaterialDeliveryVO queryInitDelivery(Long orderId);

    /**
     * 根据orderId查询当前订单下已送货的材料数量
     *
     * @param orderId 订单id
     * @return 已送货材料数量
     */
    Map<Long, BigDecimal> sumDeliveredGroupByDetailId(Long orderId);

    /**
     * 处理终审后时间
     *
     * @param id 送货单id
     * @return 推送后数据
     */
    MaterialDeliveryVO saveCommitAfter(Long id);

    /**
     * 回写发货单入库状态
     * @param storeList
     * @param flag
     */
    void writeBack(List<InstoreMaterialVO> storeList, boolean flag);

    List<MaterialDeliveryDetailVO> querySubData(IPage<MaterialDeliveryDetailEntity> pageData, QueryParam queryParam);
}
