package com.ejianc.business.material.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.material.bean.PurchaseOrderDetailEntity;
import com.ejianc.business.material.bean.PurchaseOrderEntity;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.PurchaseOrderDetailVO;
import com.ejianc.business.material.vo.PurchaseOrderVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * 采购订单
 * 
 * @author generator
 * 
 */
public interface IPurchaseOrderService extends IBaseService<PurchaseOrderEntity> {

    ParamsCheckVO checkParams(PurchaseOrderVO vo);

    List<PurchaseOrderDetailVO> querySubData(IPage<PurchaseOrderDetailEntity> pageData, QueryParam queryParam);

    /**
     * @description: 根据订单id，获取该订单的入库（未结算过的）明细
     *
     * @param orderIdList
     * @return {@link List< InstoreMaterialVO>}
     * @author songlx
     * @date: 2023/4/21
     */
    List<InstoreMaterialVO> getInstoreMaterialByPurchaseOrder(List<Long> orderIdList);
}
