/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.pub.MaterialStoreState;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="instore")
public class InstoreBpmService
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IInstoreService iInstoreService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    IUseApplyService useApplyService;
    @Autowired
    private ICostDetailApi iCostDetailApi;

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        this.logger.info("-----------\u5ba1\u6279\u8282\u70b9\u5ba1\u6279\u4e2d\u65f6\u8282\u70b9\u5ba1\u6279\u540e\u56de\u8c03-----------");
        this.logger.info("\u5f00\u59cb\u65f6\u95f4-----------" + other.get("taskStartTime"));
        this.logger.info("\u5ba1\u6279\u610f\u89c1-----------" + other.get("comment"));
        this.logger.info("other-----------" + other);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5ba1\u6279\u901a\u8fc7\u540e\u7684\u56de\u8c03\u5f00\u59cb-------------------");
        this.updateUseApplySubCheckNum(billId);
        this.logger.info("\u5ba1\u6279\u901a\u8fc7\u540e\u7684\u56de\u8c03\uff0c\u4fee\u6539\u7684\u72b6\u6001------" + MaterialStoreState.STORED.getCode());
        return this.changeStoreState(billId, MaterialStoreState.STORED.getCode());
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse response = this.iCostDetailApi.checkShareFlag(billId);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5f03\u5ba1\u540e\u7684\u56de\u8c03\u5f00\u59cb-------------------");
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            this.logger.info("\u6536\u6599\u5165\u5e93\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u64a4\u56de\u64cd\u4f5c\u6821\u9a8c\u7ed3\u675f\uff0c\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u539f\u56e0\uff1a{}", new Object[]{billId, billTypeCode, resp.getMsg()});
            return CommonResponse.error((String)resp.getMsg());
        }
        this.logger.info("\u5f03\u5ba1\u540e\u7684\u56de\u8c03\uff0c\u4fee\u6539\u7684\u72b6\u6001------" + MaterialStoreState.STORED.getCode());
        this.updateUseApplySubCheckNum(billId);
        return this.changeStoreState(billId, MaterialStoreState.STORING.getCode());
    }

    public CommonResponse<String> changeStoreState(Long billId, Integer state) {
        InstoreEntity entity = (InstoreEntity)((Object)this.iInstoreService.selectById(billId));
        if (entity == null) {
            CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5173\u5165\u5e93\u5355\uff01");
        }
        if (!ListUtil.isEmpty(entity.getInstoreMaterialList())) {
            entity.getInstoreMaterialList().forEach(sub -> sub.setStoreState(state));
        }
        this.iInstoreService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success();
    }

    public void updateUseApplySubCheckNum(Long billId) {
        List applyIds;
        InstoreEntity instoreEntity = (InstoreEntity)((Object)this.iInstoreService.selectById(billId));
        List<InstoreMaterialEntity> instoreMaterialList = instoreEntity.getInstoreMaterialList();
        if (CollectionUtils.isNotEmpty(instoreMaterialList) && CollectionUtils.isNotEmpty(applyIds = instoreMaterialList.stream().filter(t2 -> t2.getApplyId() != null).map(InstoreMaterialEntity::getApplyId).distinct().collect(Collectors.toList()))) {
            for (Long applyId : applyIds) {
                this.useApplyService.updateSumCheckNum(applyId);
            }
        }
    }
}

