/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bidprice.material.api.ImaterialPicketageApi;
import com.ejianc.business.bidprice.material.vo.MaterialPicketageVO;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.finance.api.IFinanceLoadReimburseApi;
import com.ejianc.business.finance.api.IFinancePayReimburseApi;
import com.ejianc.business.finance.api.IFinancePaySporadicApi;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.material.bean.MaterialContractDetailSubEntity;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.bean.MaterialContractOtherCostSubEntity;
import com.ejianc.business.material.bean.PurchaseSettlementEntity;
import com.ejianc.business.material.controller.SqlParam;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.service.IContractChangeService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.business.material.vo.MaterialContractPriceQueryVO;
import com.ejianc.business.material.vo.MaterialContractPriceResultVO;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.MaterialReportVo;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.warn.MaterialWarnVo;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.sub.api.ISubContractApi;
import com.ejianc.business.utils.ListSplitUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="materialService")
public class MaterialContractServiceImpl
extends BaseServiceImpl<MaterialContractMapper, MaterialContractEntity>
implements IMaterialContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String DEFAULT_RULE_CODE = "materialContract";
    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";
    @Autowired
    private IIncomeContractApi incomeContractApi;
    @Autowired
    private ISubContractApi subContractApi;
    @Autowired
    private IEquipmentContractApi equipmentContractApi;
    @Autowired
    private IOtherContractApi otherContractApi;
    @Autowired
    private IFinancePayReimburseApi financePayReimburseApi;
    @Autowired
    private IFinancePaySporadicApi financePaySporadicApi;
    @Autowired
    private IFinanceLoadReimburseApi financeLoadReimburseApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private MaterialContractMapper materialContractMapper;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IContractChangeService contractChangeService;
    @Autowired
    private IPurchaseSettlementService purchaseSettlementService;
    @Autowired
    private ImaterialPicketageApi materialPicketageApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String PARAM_TOTAL_MNY = "P-t58ih142";
    private static final String PARAM_NUM = "P-uFOcn644";
    private static final String PARAM_TAX_MNY = "P-14dTg745";
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    private static String PARAM_PLAN_COUNT = "P-8N9Au207";
    private static String PARAM_PLAN_PRICE = "P-2Ux27w08";
    private static String PARAM_PRICE_AREA = "P-126hYD10";
    @Autowired
    private IRmatContractApi rmatContractApi;

    @Override
    public List<MaterialContractVO> queryContractTaxWarnContract(List<SqlParam> sqlParamList) {
        ArrayList<MaterialContractVO> result = new ArrayList<MaterialContractVO>();
        List lists = ListSplitUtil.splistList(sqlParamList, (int)10);
        for (List list : lists) {
            result.addAll(this.materialContractMapper.queryContractTaxWarnContract(list));
        }
        return result;
    }

    @Override
    public MaterialContractVO save(MaterialContractVO materialContractVO) {
        boolean b;
        MaterialContractEntity saveEntity = null;
        UserContext userContext = this.sessionManager.getUserContext();
        materialContractVO.setBaseMoney(materialContractVO.getAmountWithoutTax());
        materialContractVO.setBaseTaxMoney(materialContractVO.getAmountWithTax());
        materialContractVO.setBeforeChangeMny(materialContractVO.getAmountWithoutTax());
        materialContractVO.setBeforeChangeTaxMny(materialContractVO.getAmountWithTax());
        BigDecimal totalAmountWith = new BigDecimal(0).setScale(8, 4);
        MaterialContractEntity dbEntity = null;
        if (null != materialContractVO.getId()) {
            dbEntity = (MaterialContractEntity)((Object)super.selectById((Serializable)materialContractVO.getId()));
        }
        if (dbEntity != null) {
            saveEntity = (MaterialContractEntity)((Object)BeanMapper.map((Object)materialContractVO, MaterialContractEntity.class));
            saveEntity.setCreateTime(dbEntity.getCreateTime());
            saveEntity.setCreateUserCode(dbEntity.getCreateUserCode());
            saveEntity.setCreateUserName(dbEntity.getCreateUserName());
            saveEntity.setModifyUserName(userContext.getUserName());
        } else {
            materialContractVO.setCreateUserName(userContext.getUserName());
            materialContractVO.setChangeVersion(Integer.valueOf(1));
            materialContractVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            materialContractVO.setChangeState(MaterialContractVO.CONTRACT_CHANGE_STATE_UNCHANGED);
            saveEntity = (MaterialContractEntity)((Object)BeanMapper.map((Object)materialContractVO, MaterialContractEntity.class));
        }
        if (CollectionUtils.isNotEmpty(saveEntity.getMaterialDetailList())) {
            totalAmountWith = totalAmountWith.add(saveEntity.getMaterialDetailList().stream().filter(detail -> !"del".equals(detail.getRowState()) && null != detail.getTotalAmount()).map(MaterialContractDetailSubEntity::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        if (CollectionUtils.isNotEmpty(saveEntity.getOtherCostList())) {
            totalAmountWith = totalAmountWith.add(saveEntity.getOtherCostList().stream().filter(cost -> !"del".equals(cost.getRowState()) && null != cost.getCostAmount()).map(MaterialContractOtherCostSubEntity::getCostAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
            saveEntity.getOtherCostList().stream().filter(cost -> null == cost.getCostAmount()).forEach(cost -> cost.setCostAmount(new BigDecimal(0)));
        }
        if (b = super.saveOrUpdate((Object)saveEntity, false)) {
            this.countContractNumAndMnyByEnquiry(saveEntity.getEnquiryPriceBillId());
        }
        return (MaterialContractVO)BeanMapper.map((Object)((Object)saveEntity), MaterialContractVO.class);
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Integer> resp = new HashMap();
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"sum(base_tax_money) as originalAmount, sum(amount_with_tax) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap();
            resp.put("originalAmount", 0);
            resp.put("curAmount", 0);
        }
        return resp;
    }

    @Override
    public boolean codeCheck(Long id, String code) {
        QueryParam check = new QueryParam();
        if (id != null) {
            check.getParams().put("id", new Parameter("ne", (Object)id));
        }
        check.getParams().put("code", new Parameter("eq", (Object)code));
        check.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List contractEntityList = super.queryList(check, false);
        if (CollectionUtils.isNotEmpty((Collection)contractEntityList)) {
            return false;
        }
        check.getParams().remove("id");
        check.getParams().put("material_contract_id", new Parameter("ne", (Object)id));
        check.getParams().put("bill_state", new Parameter("ne", (Object)BillStateEnum.PASSED_STATE.getBillStateCode()));
        List changeList = this.contractChangeService.queryList(check, false);
        return !CollectionUtils.isNotEmpty((Collection)changeList);
    }

    @Override
    public void checkContract(Long id) {
        MaterialContractEntity contractEntity = (MaterialContractEntity)((Object)super.selectById((Serializable)id));
        if (contractEntity == null) {
            throw new BusinessException("\u6240\u9009\u5408\u540c\u4e0d\u5b58\u5728\uff01");
        }
        if (contractEntity.getBillState() != 1 && contractEntity.getBillState() != 3) {
            throw new BusinessException("\u6240\u9009\u5408\u540c\u672a\u751f\u6548\uff01");
        }
    }

    @Override
    public List<Map<String, Object>> queryAllWarnContracts(List<SqlParam> sqlParamList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List lists = ListSplitUtil.splistList(sqlParamList, (int)10);
        for (List list : lists) {
            result.addAll(this.materialContractMapper.queryAllWarnContracts(list));
        }
        return result;
    }

    @Override
    public List<MaterialWarnVo> materialProjectOutMny(List<Long> tenantIds) {
        return ((MaterialContractMapper)this.baseMapper).materialProjectOutMny(tenantIds);
    }

    @Override
    public List<MaterialReportVo> getMonthMaterialMny(Long projectId, Integer lastDay) {
        return ((MaterialContractMapper)this.baseMapper).getMonthMaterialMny(projectId, lastDay);
    }

    @Override
    public MaterialReportVo getMaterialContract(Long projectId) {
        BigDecimal mny = BigDecimal.ZERO;
        BigDecimal settleMny = BigDecimal.ZERO;
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(MaterialContractEntity::getProjectId, (Object)projectId);
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.in(MaterialContractEntity::getBillState, billStatus);
        List quoteEntities = super.list((Wrapper)lambda);
        for (MaterialContractEntity ce : quoteEntities) {
            mny = mny.add(ce.getAmountWithTax() == null ? BigDecimal.ZERO : ce.getAmountWithTax());
        }
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda2.eq(PurchaseSettlementEntity::getProjectId, (Object)projectId);
        lambda2.eq(BaseEntity::getDr, (Object)0);
        lambda2.in(PurchaseSettlementEntity::getBillState, billStatus);
        List purchaseSettlementEntities = this.purchaseSettlementService.list((Wrapper)lambda2);
        for (PurchaseSettlementEntity ce : purchaseSettlementEntities) {
            settleMny = settleMny.add(ce.getCurrentSettlementAmountTax() == null ? BigDecimal.ZERO : ce.getCurrentSettlementAmountTax());
        }
        MaterialReportVo vo = new MaterialReportVo();
        vo.setMny(mny);
        vo.setNum(Integer.valueOf(quoteEntities.size()));
        vo.setSettleMny(settleMny);
        return vo;
    }

    @Override
    public List<MaterialContractVO> queryWarnContracts(List<Long> tenantAllIds) {
        return this.materialContractMapper.queryWarnContracts(tenantAllIds);
    }

    @Override
    public List<MaterialContractVO> queryWarnPrePayContracts(List<Long> tenantAllIds) {
        return this.materialContractMapper.queryWarnPrePayContracts(tenantAllIds);
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public MaterialPriceVO queryPrice(Integer isJc, Long contractId, MaterialPriceVO vo) {
        Long projectId = vo.getProjectId();
        List detail = vo.getDetail();
        if (CollectionUtils.isNotEmpty((Collection)detail)) {
            List<MaterialPriceVO> materialPrices;
            MaterialPriceVO p;
            Long materialId;
            List<MaterialPriceVO> materialPriceVOS;
            List<Long> materialIds = detail.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
            if (projectId != null && 1 != isJc && CollectionUtils.isNotEmpty(materialPriceVOS = this.materialContractMapper.queryPlanPriceByProjectId(projectId, materialIds))) {
                Map<Long, MaterialPriceVO> priceVOMap = materialPriceVOS.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                for (MaterialPriceVO v : detail) {
                    materialId = v.getMaterialId();
                    p = priceVOMap.get(materialId);
                    if (null == p) continue;
                    v.setPlanNum(p.getPlanNum());
                    v.setPlanPrice(p.getPlanPrice());
                }
            }
            if (CollectionUtils.isNotEmpty(materialPrices = this.materialContractMapper.querySettlePriceByTenantId(InvocationInfoProxy.getTenantid(), materialIds))) {
                Map<Long, MaterialPriceVO> priceVO = materialPrices.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                for (MaterialPriceVO v : detail) {
                    materialId = v.getMaterialId();
                    p = priceVO.get(materialId);
                    if (null == p) continue;
                    v.setMinPrice(p.getMinPrice());
                    v.setMaxPrice(p.getMaxPrice());
                    v.setPriceArea(p.getMinPrice().setScale(2, 4) + "~" + p.getMaxPrice().setScale(2, 4));
                    v.setBuyPrice(p.getBuyPrice());
                }
            }
        }
        return vo;
    }

    @Override
    public ParamsCheckVO checkParams(Integer isJc, Long contractId, MaterialPriceVO vo) {
        List billParamVOS;
        CommonResponse sghtkzc;
        Object res;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<String, List<ParamsCheckDsVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        List<MaterialPriceVO> detailList = vo.getDetail();
        HashMap numMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)detailList) && (int)detailList.stream().filter(in -> in.getMaterialId() != null).count() > 0) {
            CommonResponse response1;
            detailList = detailList.stream().filter(in -> in.getMaterialId() != null).collect(Collectors.toList());
            detailList.forEach(detail -> {
                MaterialPriceVO numVO = (MaterialPriceVO)numMap.get(detail.getMaterialId());
                if (numVO != null) {
                    numVO.setNum(com.ejianc.business.utils.ComputeUtil.safeAdd((BigDecimal)numVO.getNum(), (BigDecimal)detail.getNum()));
                    numVO.setPrice(com.ejianc.business.utils.ComputeUtil.isLessThan((BigDecimal)detail.getPrice(), (BigDecimal)numVO.getPrice()) ? detail.getPrice() : numVO.getPrice());
                    numVO.setTotalAmount(com.ejianc.business.utils.ComputeUtil.safeAdd((BigDecimal)numVO.getTotalAmount(), (BigDecimal)detail.getTotalAmount()));
                } else {
                    numMap.put(detail.getMaterialId(), detail);
                }
            });
            vo.setDetail(new ArrayList(numMap.values()));
            List detail2 = vo.getDetail();
            if (isJc == 0) {
                CommonResponse response12;
                Object materialIds;
                CommonResponse response;
                StringBuffer stringBuffer;
                ParamsCheckDsVO paramsCheckDsVO;
                BigDecimal roleValue;
                List subIds = detail2.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                BudgetProjectProParamControlVO paramControlVO = new BudgetProjectProParamControlVO();
                paramControlVO.setProjectId(vo.getProjectId());
                paramControlVO.setCostType(CostTypeEnum.MATERIAL_COST_TYPE.getType());
                paramControlVO.setIds(subIds);
                res = this.budgetProjectProApi.fetchQuantityAndMny(paramControlVO);
                if (!res.isSuccess()) {
                    throw new BusinessException("\u9884\u7b97\u6750\u6599\u8d39\u603b\u91d1\u989d\uff0c\u67e5\u8be2\u9879\u76ee\u9884\u7b97\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg());
                }
                if (null != res.getData()) {
                    CommonResponse response2;
                    BudgetProjectDetailProVO detailProVO;
                    CommonResponse response13;
                    BudgetProjectProQuantityAndMnyVO quantityAndMnyVO = (BudgetProjectProQuantityAndMnyVO)res.getData();
                    Map detailProMap = quantityAndMnyVO.getDetailProMap();
                    CommonResponse response3 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, curOrgId);
                    if (!response3.isSuccess()) {
                        throw new BusinessException("\u3010\u9884\u7b97\u6750\u6599\u8d39\u603b\u91d1\u989d\u3011 \u63a7 \u3010\u7269\u8d44\u603b\u8ba1\u5212\u91d1\u989d\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response3.getMsg());
                    }
                    List billParamVOS2 = (List)response3.getData();
                    if (CollectionUtils.isNotEmpty((Collection)billParamVOS2)) {
                        for (BillParamVO billParamVO : billParamVOS2) {
                            if (0 == billParamVO.getControlType()) continue;
                            roleValue = billParamVO.getRoleValue();
                            BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                            Iterator budgetTaxMnyResult = quantityAndMnyVO.getMaterialTaxMny().multiply(scale);
                            BigDecimal bigDecimal = this.materialContractMapper.sumLastTotalAmountWithTax(vo.getProjectId(), vo.getContractId());
                            BigDecimal currentAmountWithTax = vo.getAmountWithTax();
                            BigDecimal bigDecimal2 = bigDecimal.add(currentAmountWithTax);
                            CommonResponse response14 = this.rmatContractApi.fetchContractTaxMny(vo.getProjectId());
                            if (!response14.isSuccess()) {
                                throw new BusinessException("\u5468\u8f6c\u6750\u5408\u540c\u6309\u7167\u9879\u76ee\u7ef4\u5ea6\uff0c\u5408\u540c\u603b\u91d1\u989d\u83b7\u53d6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response3.getMsg());
                            }
                            BigDecimal amountWithTax = ((BigDecimal)response14.getData()).add(bigDecimal2);
                            if (amountWithTax.compareTo((BigDecimal)((Object)budgetTaxMnyResult)) <= 0) continue;
                            BigDecimal over = amountWithTax.subtract((BigDecimal)((Object)budgetTaxMnyResult));
                            paramsCheckDsVO = new ParamsCheckDsVO(vo.getContractId(), "amountWithoutTax");
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem("\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u603b\u91d1\u989d\u8d85\u9884\u7b97\u6750\u6599\u8d39\u603b\u91d1\u989d");
                            paramsCheckDsVO.setWarnName("\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u603b\u91d1\u989d\u5927\u4e8e\u9884\u7b97\u6750\u6599\u8d39\u603b\u91d1\u989d * " + roleValue + "%");
                            stringBuffer = new StringBuffer();
                            stringBuffer.append("\u8be5\u9879\u76ee\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u603b\u91d1\u989d\uff1a").append(amountWithTax.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u9884\u7b97\u6750\u6599\u8d39\u603b\u91d1\u989d * ").append(roleValue).append("%\uff1a").append(((BigDecimal)((Object)budgetTaxMnyResult)).setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(over.setScale(2, RoundingMode.HALF_UP)).append("\u5143\u3002");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            MaterialContractServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                    if (!(response13 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_NUM, curOrgId)).isSuccess()) {
                        throw new BusinessException("\u9884\u7b97\u6750\u6599\u6e05\u5355\u91cf\u63a7\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response13.getMsg());
                    }
                    List billParamVOS1 = (List)response13.getData();
                    if (CollectionUtils.isNotEmpty((Collection)detail2) && CollectionUtils.isNotEmpty((Collection)billParamVOS1) && !detailProMap.isEmpty()) {
                        Map<Long, MaterialPriceVO> lastSubMap = this.materialContractMapper.sumLastTotalNumAndTotalAmount(vo.getContractId(), vo.getProjectId(), numMap.keySet());
                        HashMap currentMergeMap = new HashMap();
                        if (lastSubMap.isEmpty()) {
                            currentMergeMap.putAll(numMap);
                        } else {
                            for (Map.Entry entry : lastSubMap.entrySet()) {
                                Long materialId = (Long)entry.getKey();
                                if (!numMap.containsKey(materialId)) continue;
                                MaterialPriceVO materialPriceVO = (MaterialPriceVO)entry.getValue();
                                MaterialPriceVO cur = (MaterialPriceVO)numMap.get(materialId);
                                Iterator num = materialPriceVO.getNum();
                                materialPriceVO.setNum(((BigDecimal)((Object)num)).add(cur.getNum()));
                                entry.setValue(materialPriceVO);
                            }
                            currentMergeMap.putAll(lastSubMap);
                        }
                        for (BillParamVO billParamVO : billParamVOS1) {
                            if (0 == billParamVO.getControlType()) continue;
                            Iterator roleValue2 = billParamVO.getRoleValue();
                            BigDecimal bigDecimal = ((BigDecimal)((Object)roleValue2)).divide(new BigDecimal("100"));
                            HashMap dProMap = new HashMap();
                            for (Map.Entry entry : detailProMap.entrySet()) {
                                BudgetProjectDetailProVO detailProVO2 = (BudgetProjectDetailProVO)entry.getValue();
                                BudgetProjectDetailProVO budgetProjectDetailProVO = new BudgetProjectDetailProVO();
                                BigDecimal num = detailProVO2.getNum() == null ? BigDecimal.ZERO : detailProVO2.getNum();
                                budgetProjectDetailProVO.setNum(num.multiply(bigDecimal));
                                dProMap.put(entry.getKey(), budgetProjectDetailProVO);
                            }
                            for (Map.Entry entry : currentMergeMap.entrySet()) {
                                BigDecimal dNum;
                                Long materialId = (Long)entry.getKey();
                                MaterialPriceVO materialPriceVO = (MaterialPriceVO)entry.getValue();
                                if (!dProMap.containsKey(materialId)) continue;
                                detailProVO = (BudgetProjectDetailProVO)dProMap.get(materialId);
                                BigDecimal cNum = materialPriceVO.getNum();
                                if (cNum.compareTo(dNum = detailProVO.getNum()) <= 0) continue;
                                BigDecimal over = cNum.subtract(dNum);
                                ParamsCheckDsVO paramsCheckDsVO2 = new ParamsCheckDsVO(materialId, "num");
                                paramsCheckDsVO2.setOrgName(billParamVO.getOrgName());
                                paramsCheckDsVO2.setWarnItem(materialPriceVO.getMaterialName() + "-" + materialPriceVO.getMeasureUnit() + "-" + materialPriceVO.getSpec());
                                paramsCheckDsVO2.setWarnName("\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u6750\u6599\u6e05\u5355\u91cf\u5927\u4e8e\u9884\u7b97\u6750\u6599\u6e05\u5355\u91cf * " + roleValue2 + "%");
                                StringBuffer stringBuffer2 = new StringBuffer();
                                stringBuffer2.append("\u6863\u6848\u7d2f\u8ba1\u6570\u91cf\uff1a").append(cNum.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u9884\u7b97\u6750\u6599\u6e05\u5355\u91cf * ").append(roleValue2).append("%\uff1a").append(dNum.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u8d85\u51fa\u91cf\uff1a").append(over.setScale(2, RoundingMode.HALF_UP)).append("\u3002");
                                paramsCheckDsVO2.setContent(stringBuffer2.toString());
                                MaterialContractServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO2);
                            }
                        }
                    }
                    if (!(response2 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TAX_MNY, curOrgId)).isSuccess()) {
                        throw new BusinessException("\u9884\u7b97\u6750\u6599\u6e05\u5355\u91d1\u989d\u63a7\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response2.getMsg());
                    }
                    List billParamVOS22 = (List)response2.getData();
                    if (CollectionUtils.isNotEmpty((Collection)detail2) && CollectionUtils.isNotEmpty((Collection)billParamVOS22) && !detailProMap.isEmpty()) {
                        Map<Long, MaterialPriceVO> lastSubMap = this.materialContractMapper.sumLastTotalNumAndTotalAmount(vo.getContractId(), vo.getProjectId(), numMap.keySet());
                        HashMap hashMap = new HashMap();
                        if (lastSubMap.isEmpty()) {
                            hashMap.putAll(numMap);
                        } else {
                            for (Map.Entry entry : lastSubMap.entrySet()) {
                                Long materialId = (Long)entry.getKey();
                                if (!numMap.containsKey(materialId)) continue;
                                MaterialPriceVO subVO = (MaterialPriceVO)entry.getValue();
                                MaterialPriceVO cur = (MaterialPriceVO)numMap.get(materialId);
                                Iterator amount = subVO.getTotalAmount();
                                subVO.setTotalAmount(((BigDecimal)((Object)amount)).add(cur.getTotalAmount()));
                                entry.setValue(subVO);
                            }
                            hashMap.putAll(lastSubMap);
                        }
                        for (BillParamVO billParamVO : billParamVOS22) {
                            if (0 == billParamVO.getControlType()) continue;
                            BigDecimal roleValue3 = billParamVO.getRoleValue();
                            BigDecimal scale = roleValue3.divide(new BigDecimal("100"));
                            HashMap dProMap = new HashMap();
                            for (Map.Entry entry : detailProMap.entrySet()) {
                                detailProVO = (BudgetProjectDetailProVO)entry.getValue();
                                BudgetProjectDetailProVO budgetProjectDetailProVO = new BudgetProjectDetailProVO();
                                BigDecimal materialTaxMnyCost = detailProVO.getMaterialTaxMnyCost() == null ? BigDecimal.ZERO : detailProVO.getMaterialTaxMnyCost();
                                budgetProjectDetailProVO.setMaterialTaxMnyCost(materialTaxMnyCost.multiply(scale));
                                dProMap.put(entry.getKey(), budgetProjectDetailProVO);
                            }
                            for (Map.Entry entry : hashMap.entrySet()) {
                                BigDecimal dMaterialTaxMnyCost;
                                Long materialId = (Long)entry.getKey();
                                MaterialPriceVO materialPriceVO = (MaterialPriceVO)entry.getValue();
                                if (!dProMap.containsKey(materialId)) continue;
                                BudgetProjectDetailProVO detailProVO3 = (BudgetProjectDetailProVO)dProMap.get(materialId);
                                BigDecimal cTotalAmount = materialPriceVO.getTotalAmount();
                                if (cTotalAmount.compareTo(dMaterialTaxMnyCost = detailProVO3.getMaterialTaxMnyCost()) <= 0) continue;
                                BigDecimal over = cTotalAmount.subtract(dMaterialTaxMnyCost);
                                ParamsCheckDsVO paramsCheckDsVO3 = new ParamsCheckDsVO(materialId, "totalAmount");
                                paramsCheckDsVO3.setOrgName(billParamVO.getOrgName());
                                paramsCheckDsVO3.setWarnItem(materialPriceVO.getMaterialName() + "-" + materialPriceVO.getMeasureUnit() + "-" + materialPriceVO.getSpec());
                                paramsCheckDsVO3.setWarnName("\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u6750\u6599\u91d1\u989d\u5927\u4e8e\u9884\u7b97\u6750\u6599\u6e05\u5355\u91d1\u989d * " + roleValue3 + "%");
                                StringBuffer stringBuffer3 = new StringBuffer();
                                stringBuffer3.append(" \u6863\u6848\u7d2f\u8ba1\u91d1\u989d\uff1a").append(cTotalAmount.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u9884\u7b97\u6750\u6599\u6e05\u5355\u91d1\u989d * ").append(roleValue3).append("%\uff1a").append(dMaterialTaxMnyCost.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(over.setScale(2, RoundingMode.HALF_UP)).append("\u3002");
                                paramsCheckDsVO3.setContent(stringBuffer3.toString());
                                MaterialContractServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO3);
                            }
                        }
                    }
                }
                if (!(response = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_COUNT, curOrgId)).isSuccess()) {
                    throw new BusinessException("\u3010\u7269\u8d44\u603b\u8ba1\u5212\u91cf\u3011\u63a7\u5236\u3010\u7269\u8d44\u5408\u540c\u91cf\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
                }
                List billParamVOS3 = (List)response.getData();
                if (CollectionUtils.isNotEmpty((Collection)billParamVOS3)) {
                    for (BillParamVO billParamVO : billParamVOS3) {
                        if (0 == billParamVO.getControlType()) continue;
                        materialIds = detail2.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                        List<Object> vos = new ArrayList();
                        vos = this.materialContractMapper.queryMaterialContractCount(contractId, vo.getProjectId(), (List<Long>)materialIds);
                        Map<Long, BigDecimal> priceVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                        BigDecimal roleValue4 = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue4.divide(BigDecimal.valueOf(100L));
                        for (MaterialPriceVO d : detail2) {
                            BigDecimal bigDecimal = d.getNum();
                            BigDecimal planNum = d.getPlanNum().multiply(divide);
                            BigDecimal hasNum = priceVOMap.get(d.getMaterialId()) != null ? priceVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                            BigDecimal allNum = hasNum.add(bigDecimal);
                            if (allNum.compareTo(planNum) <= 0) continue;
                            paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "count");
                            paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                            paramsCheckDsVO.setWarnName("\u5408\u540c\u6570\u91cf\u5927\u4e8e\u603b\u8ba1\u5212\u6570\u91cf");
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            stringBuffer = new StringBuffer();
                            stringBuffer.append("\u672c\u6b21\u5408\u540c\u6570\u91cf\uff1a").append(bigDecimal.setScale(2, 4)).append("\uff0c\u5df2\u7b7e\u8ba2\u6570\u91cf\uff1a").append(hasNum.setScale(2, 4)).append("\uff0c\u603b\u8ba1\u5212\u6570\u91cf*").append(roleValue4).append("%: ").append(planNum.setScale(2, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(allNum.subtract(planNum).setScale(2, 4));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            MaterialContractServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                }
                if (!(response12 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_PRICE, curOrgId)).isSuccess()) {
                    throw new BusinessException("\u603b\u8ba1\u5212\u4ef7\u683c\u3010\u7269\u8d44\u603b\u8ba1\u5212\u4ef7\u3011\u63a7\u5236\u3010\u7269\u8d44\u5408\u540c\u4ef7\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response12.getMsg());
                }
                List billParamVOS1 = (List)response12.getData();
                if (CollectionUtils.isNotEmpty((Collection)billParamVOS1)) {
                    materialIds = billParamVOS1.iterator();
                    while (materialIds.hasNext()) {
                        BillParamVO billParamVO;
                        billParamVO = (BillParamVO)materialIds.next();
                        if (0 == billParamVO.getControlType()) continue;
                        roleValue = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                        for (MaterialPriceVO materialPriceVO : detail2) {
                            BigDecimal bigDecimal;
                            BigDecimal _planPrice;
                            BigDecimal price = materialPriceVO.getPrice();
                            if (price.compareTo(_planPrice = (bigDecimal = materialPriceVO.getPlanPrice()).multiply(divide)) <= 0) continue;
                            ParamsCheckDsVO paramsCheckDsVO4 = new ParamsCheckDsVO(materialPriceVO.getMaterialId(), "unitPrice");
                            paramsCheckDsVO4.setWarnItem(materialPriceVO.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)materialPriceVO.getSpec()) ? " [" + materialPriceVO.getSpec() + "]" : ""));
                            paramsCheckDsVO4.setWarnName("\u5408\u540c\u5355\u4ef7\u5927\u4e8e\u603b\u8ba1\u5212\u5355\u4ef7");
                            paramsCheckDsVO4.setOrgName(billParamVO.getOrgName());
                            StringBuffer stringBuffer4 = new StringBuffer();
                            stringBuffer4.append("\u672c\u6b21\u5408\u540c\u5355\u4ef7\uff1a").append(price.setScale(2, 4)).append("\uff0c\u603b\u8ba1\u5212\u5355\u4ef7*").append(roleValue).append("%: ").append(_planPrice.setScale(2, 4)).append("\u3002\u8d85\u51fa\u5355\u4ef7\uff1a").append(price.subtract(_planPrice).setScale(2, 4));
                            paramsCheckDsVO4.setContent(stringBuffer4.toString());
                            MaterialContractServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO4);
                        }
                    }
                }
            }
            if (!(response1 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PRICE_AREA, curOrgId)).isSuccess()) {
                throw new BusinessException("\u7ed3\u7b97\u5386\u53f2\u4ef7\u683c\u533a\u95f4\u3010\u5386\u53f2\u4ef7\u3011\u63a7\u5236\u3010\u7269\u8d44\u5408\u540c\u4ef7\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response1.getMsg());
            }
            List billParamVOS1 = (List)response1.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS1)) {
                for (BillParamVO billParamVO : billParamVOS1) {
                    if (0 == billParamVO.getControlType()) continue;
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                    for (MaterialPriceVO d : detail2) {
                        BigDecimal price = d.getPrice();
                        BigDecimal maxPrice = d.getMaxPrice() == null ? BigDecimal.ZERO : d.getMaxPrice();
                        BigDecimal minPrice = d.getMinPrice();
                        if (maxPrice.compareTo(BigDecimal.ZERO) <= 0) continue;
                        BigDecimal _maxPrice = maxPrice.multiply(divide);
                        BigDecimal bigDecimal = minPrice.multiply(divide);
                        if (price.compareTo(_maxPrice) <= 0) continue;
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "unitPrice");
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                        paramsCheckDsVO.setWarnName("\u5408\u540c\u5355\u4ef7\u5927\u4e8e\u5386\u53f2\u4ef7");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u5408\u540c\u5355\u4ef7\uff1a").append(price.setScale(2, 4)).append("\uff0c\u7269\u8d44\u5386\u53f2\u4ef7*").append(roleValue).append("%: ").append(bigDecimal.setScale(2, 4)).append("~").append(_maxPrice.setScale(2, 4)).append("\u3002\u8d85\u51fa\u6700\u9ad8\u4ef7\uff1a").append(price.subtract(_maxPrice).setScale(2, 4));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        MaterialContractServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                    }
                }
            }
        }
        if (isJc.equals(0) && (sghtkzc = this.paramConfigApi.getBillParamByCodeAndOrgId(SGHTZJE_K_SJZCJE, curOrgId)).isSuccess() && null != sghtkzc.getData() && CollectionUtils.isNotEmpty((Collection)(billParamVOS = (List)sghtkzc.getData()))) {
            BigDecimal sjzcje = this.getSjzcje(vo.getContractId(), vo.getProjectId(), vo.getAmountWithTax());
            res = this.incomeContractApi.fetchSghtzje(vo.getProjectId());
            if (!res.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u65bd\u5de5\u5408\u540c\u5de5\u603b\u91d1\u989d\u5931\u8d25");
            }
            BigDecimal sght = (BigDecimal)res.getData();
            for (BillParamVO billParamVO : billParamVOS) {
                BigDecimal roleValue;
                BigDecimal scale;
                BigDecimal sghtzje;
                if (0 == billParamVO.getControlType() || sjzcje.compareTo(sghtzje = NumberUtil.mul((Number)sght, (Number)(scale = NumberUtil.div((Number)(roleValue = billParamVO.getRoleValue()), (Number)new BigDecimal("100"), (int)8)))) <= 0) continue;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u8be5\u9879\u76ee\u5b9e\u9645\u652f\u51fa\u603b\u91d1\u989d\uff1a").append(sjzcje.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u65bd\u5de5\u5408\u540c\u5de5\u603b\u91d1\u989d*").append(roleValue).append("%\uff1a").append(sghtzje.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)sjzcje, (BigDecimal)sghtzje).setScale(2, RoundingMode.HALF_UP));
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                paramsCheckDsVO.setWarnItem("\u5b9e\u9645\u652f\u51fa\u603b\u91d1\u989d\u8d85\u65bd\u5de5\u5408\u540c\u603b\u91d1\u989d");
                paramsCheckDsVO.setWarnName("\u5b9e\u9645\u652f\u51fa\u603b\u91d1\u989d\u5927\u4e8e\u65bd\u5de5\u5408\u540c\u603b\u91d1\u989d");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                MaterialContractServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
            }
        }
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            pc.setWarnType("alert");
            pc.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            pc.setWarnType("warn");
            pc.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    private BigDecimal getSjzcje(Long contractId, Long projectId, BigDecimal mny) {
        CommonResponse fbCommonResponse;
        BigDecimal wz = BigDecimal.ZERO;
        if (contractId != null) {
            wz = ((MaterialContractMapper)this.baseMapper).fetchSjzcje(projectId, contractId);
        }
        if (!(fbCommonResponse = this.subContractApi.fetchSjzcje(projectId)).isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5206\u5305\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal fb = (BigDecimal)fbCommonResponse.getData();
        CommonResponse zzcCommonResponse = this.rmatContractApi.fetchSjzcje(projectId);
        if (!zzcCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5468\u8f6c\u6750\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal zzc = (BigDecimal)zzcCommonResponse.getData();
        CommonResponse sbcgCommonResponse = this.equipmentContractApi.fetchSjzcjePurchase(projectId);
        if (!sbcgCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u8bbe\u5907\u91c7\u8d2d\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal sbcg = (BigDecimal)sbcgCommonResponse.getData();
        CommonResponse sbzlCommonResponse = this.equipmentContractApi.fetchSjzcjeRent(projectId);
        if (!sbzlCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u8bbe\u5907\u79df\u8d41\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal sbzl = (BigDecimal)sbzlCommonResponse.getData();
        CommonResponse qtCommonResponse = this.otherContractApi.fetchSjzcje(projectId);
        if (!qtCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5176\u4ed6\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal qt = (BigDecimal)qtCommonResponse.getData();
        CommonResponse fybxCommonResponse = this.financePayReimburseApi.fetchSjzcje(projectId);
        if (!fybxCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u8d39\u7528\u62a5\u9500\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal fybx = (BigDecimal)fybxCommonResponse.getData();
        CommonResponse lxCommonResponse = this.financePaySporadicApi.fetchSjzcje(projectId);
        if (!lxCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u96f6\u661f\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal lx = (BigDecimal)lxCommonResponse.getData();
        CommonResponse yjCommonResponse = this.financeLoadReimburseApi.fetchSjzcje(projectId);
        if (!yjCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5907\u7528\u91d1\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal yj = (BigDecimal)yjCommonResponse.getData();
        return NumberUtil.add((BigDecimal[])new BigDecimal[]{mny, fb, wz, zzc, sbcg, sbzl, qt, fybx, lx, yj});
    }

    @Override
    public BigDecimal fetchAmountWithTax(Long projectId) {
        return this.materialContractMapper.sumLastTotalAmountWithTax(projectId, null);
    }

    @Override
    public MaterialPicketageVO countContractNumAndMnyByEnquiry(Long ... enquiryPriceBillIds) {
        if (enquiryPriceBillIds != null) {
            for (Long enquiryPriceBillId : enquiryPriceBillIds) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.select(new String[]{"count(1) as num, IFNULL(sum(amount_with_tax),0) as money"}).eq((Object)"enquiry_price_bill_id", (Object)enquiryPriceBillId);
                Map map = this.getMap((Wrapper)queryWrapper);
                MaterialPicketageVO materialPicketageVO = new MaterialPicketageVO();
                if (MapUtils.isNotEmpty((Map)map)) {
                    Integer num = map.get("num") != null ? Integer.valueOf(map.get("num").toString()) : 0;
                    BigDecimal money = com.ejianc.business.utils.ComputeUtil.toBigDecimal(map.get("money"));
                    materialPicketageVO.setId(enquiryPriceBillId);
                    materialPicketageVO.setContractSign(num);
                    materialPicketageVO.setContractSignMny(money);
                } else {
                    materialPicketageVO.setId(enquiryPriceBillId);
                    materialPicketageVO.setContractSign(Integer.valueOf(0));
                    materialPicketageVO.setContractSignMny(BigDecimal.ZERO);
                }
                this.materialPicketageApi.updateContractSignMny(materialPicketageVO);
            }
        }
        return null;
    }

    @Override
    public BigDecimal fetchSjzcje(Long projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        return ((MaterialContractMapper)this.baseMapper).fetchSjzcje(projectId, null);
    }

    @Override
    public CommonResponse<String> onFile(OtherContractVO contractVO) {
        MaterialContractEntity entity = (MaterialContractEntity)((Object)this.selectById(contractVO.getId()));
        if ("1".equals(entity.getFileState())) {
            throw new BusinessException("\u4e0d\u80fd\u91cd\u590d\u5f52\u6863");
        }
        entity.setFileState("1");
        this.saveOrUpdate((Object)entity, false);
        CommonResponse back = this.attachmentApi.updateAttachRef(contractVO.getId(), contractVO.getAttachIds());
        if (!back.isSuccess()) {
            throw new BusinessException("\u5f52\u6863\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u5f52\u6863\u6210\u529f\uff01");
    }

    @Override
    public Map<Long, List<MaterialContractPriceResultVO>> queryMaterialContractPrice(MaterialContractPriceQueryVO queryVO) {
        List<MaterialContractPriceResultVO> resultVOS = this.materialContractMapper.queryMaterialContractPrice(queryVO.getProjectId(), queryVO.getMaterialIds());
        Map<Long, List<MaterialContractPriceResultVO>> map = null;
        map = CollectionUtils.isNotEmpty(resultVOS) ? resultVOS.stream().collect(Collectors.groupingBy(MaterialContractPriceResultVO::getMaterialId)) : new HashMap<Long, List<MaterialContractPriceResultVO>>();
        return map;
    }
}

