package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 采购订单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_purchase_order")
public class PurchaseOrderEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 申请单号
    @TableField(value="name")
    private String name; // 申请单名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="bill_date")
    private Date billDate; // 单据日期
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="contract_id")
    private Long contractId; // 合同名称
    @TableField(value="contract_name")
    private String contractName; // 合同
    @TableField(value="project_id")
    private Long projectId; // 项目名称
    @TableField(value="project_name")
    private String projectName; // 项目
    @TableField(value="org_id")
    private Long orgId; // 组织参照
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商
    @TableField(value="supplier_name")
    private String supplierName; // 供应商
    @TableField(value="purchase_type_id")
    private Long purchaseTypeId; // 采购类型id
    @TableField(value="purchase_type_name")
    private String purchaseTypeName; // 采购类型名称

    /**
     * 合同采购方式：
     * 1、当合同的所属组织类型为：集团、公司、分公司、经理部时，采购方式为公司集采合同（及需求中定义的框架合同）
     * 2、当合同的所属组织类型为项目部时，采购方式为项目自采合同
     */
    @TableField(value = "purchase_mode")
    private String purchaseMode;

    @TableField(value="employee_id")
    private Long employeeId; // 联系人
    @TableField(value="employee_name")
    private String employeeName; // 联系人
    @TableField(value="employee_phone")
    private String employeePhone; // 联系人电话
    @TableField(value="goods_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date goodsDate; // 要求到货日期
    @TableField(value="goods_address")
    private String goodsAddress; // 送货地址
    @TableField(value="goods_rule")
    private String goodsRule; // 送货要求

    @TableField(value="total_tax_mny")
    private BigDecimal totalTaxMny; // 订单金额

    @TableField(value="apply_id")
    private Long applyId; // 用料申请id
    @TableField(value="send_to_supplier")
    private Integer sendToSupplier; // 是否发给供应商
    @TableField(value="order_state")
    private Integer orderState; // orderState: 0待确认1已确认2已发货(部分发货) 3已发货(全部发货)
    @TableField(value="supplier_linker")
    private String supplierLinker; // 供方联系人
    @TableField(value="supplier_linker_phone")
    private String supplierLinkerPhone; // 供方联系电话
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="purchaseOrderDetailService")
    private List<PurchaseOrderDetailEntity> purchaseOrderDetailList = new ArrayList<>(); // 采购订单子表


    public Long getApplyId() {
        return applyId;
    }

    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }

    public Integer getSendToSupplier() {
        return sendToSupplier;
    }

    public void setSendToSupplier(Integer sendToSupplier) {
        this.sendToSupplier = sendToSupplier;
    }

    public Integer getOrderState() {
        return orderState;
    }

    public void setOrderState(Integer orderState) {
        this.orderState = orderState;
    }

    public String getSupplierLinker() {
        return supplierLinker;
    }

    public void setSupplierLinker(String supplierLinker) {
        this.supplierLinker = supplierLinker;
    }

    public String getSupplierLinkerPhone() {
        return supplierLinkerPhone;
    }

    public void setSupplierLinkerPhone(String supplierLinkerPhone) {
        this.supplierLinkerPhone = supplierLinkerPhone;
    }

    public BigDecimal getTotalTaxMny() {
        return totalTaxMny;
    }

    public void setTotalTaxMny(BigDecimal totalTaxMny) {
        this.totalTaxMny = totalTaxMny;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getPurchaseTypeId() {
        return purchaseTypeId;
    }

    public void setPurchaseTypeId(Long purchaseTypeId) {
        this.purchaseTypeId = purchaseTypeId;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public String getPurchaseMode() {
        return purchaseMode;
    }

    public void setPurchaseMode(String purchaseMode) {
        this.purchaseMode = purchaseMode;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEmployeePhone() {
        return employeePhone;
    }

    public void setEmployeePhone(String employeePhone) {
        this.employeePhone = employeePhone;
    }
    public Date getGoodsDate() {
        return goodsDate;
    }

    public void setGoodsDate(Date goodsDate) {
        this.goodsDate = goodsDate;
    }
    public String getGoodsAddress() {
        return goodsAddress;
    }

    public void setGoodsAddress(String goodsAddress) {
        this.goodsAddress = goodsAddress;
    }
    public String getGoodsRule() {
        return goodsRule;
    }

    public void setGoodsRule(String goodsRule) {
        this.goodsRule = goodsRule;
    }
    

    public List<PurchaseOrderDetailEntity> getPurchaseOrderDetailList() {
        return purchaseOrderDetailList;
    }

    public void setPurchaseOrderDetailList(List<PurchaseOrderDetailEntity> purchaseOrderDetailList) {
        this.purchaseOrderDetailList = purchaseOrderDetailList;
    }
}
