package com.ejianc.business.delivery.enums;

public enum StoreStatusEnum {

    WAIT_STORE(0,"待入库"),
    PART_STORE(1,"部分入库"),
    FULL_STORE(2,"全部入库");

    private Integer code;

    private String description;

    StoreStatusEnum(Integer code, String description){
        this.code = code;
        this.description = description;
    };


    /**
     * 获取状态
     * @return 状态
     */
    public Integer getCode() {
        return this.code;
    }

    /**
     * 获取状态注释
     * @return 状态注释
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * 根据状态获取状态枚举
     * @param planState 状态
     * @return 状态枚举
     */
    public static StoreStatusEnum getEnumByStateCode(Integer planState) {
        for (StoreStatusEnum enu : StoreStatusEnum.values()) {
            if (enu.getCode().equals(planState)) return enu;
        }
        return null;
    }

    /**
     * 根据状态获取状态注释
     * @param planState 状态
     * @return 状态注释
     */
    public static String getDescriptionByStateCode(Integer planState){
        StoreStatusEnum enu = getEnumByStateCode(planState);
        if (enu != null) return enu.getDescription();
        return null;
    }
}
