package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 采购订单子表
 *
 * @author generator
 *
 */
@TableName("ejc_material_purchase_order_detail")
public class PurchaseOrderDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "pid")
    private Long pid; // 主表id
    @TableField(value = "material_type_id")
    private Long materialTypeId; // 物资分类id
    @TableField(value = "material_type_name")
    private String materialTypeName; // 物资分类名称
    @TableField(value = "material_id")
    private Long materialId; // 物资id
    @TableField(value = "material_name")
    private String materialName; // 物资名称
    @TableField(value = "model")
    private String model; // 规格型号
    @TableField(value = "unit")
    private String unit; // 计量单位
    @TableField(value = "brand_id")
    private Long brandId; // 品牌
    @TableField(value = "brand_name")
    private String brandName; // 品牌
    @TableField(value = "order_num")
    private BigDecimal orderNum; // 订货量
    @TableField(value = "price")
    private BigDecimal price; // 单价
    @TableField(value = "memo")
    private String memo; // 备注
    @TableField(value = "source_type")
    private Integer sourceType; // 物资来源类型：1-物资档案，2-用料申请，3-合同清单，4-导入
    @TableField(value = "source_id")
    private Long sourceId; // 物资来源单据Id
    @TableField(value = "tax_mny")
    private BigDecimal taxMny; // 金额
    /**
     * 物资编码
     */
    @TableField(value = "material_code")
    private String materialCode;

    @TableField(value = "source_detail_id")
    private Long sourceDetailId; // 来源单据明细Id
    @TableField(value = "receive_num")
    private BigDecimal receiveNum; // 接收数量
    @TableField(value = "sum_send_num")
    private BigDecimal sumSendNum; // 供应商累计发货量
    @TableField(value = "purchase_contract_id")
    private Long purchaseContractId; // 采购合同
    @TableField(value = "purchase_contract_name")
    private String purchaseContractName; // 采购合同
    @TableField(value = "purchase_contract_price")
    private BigDecimal purchaseContractPrice; // 合同单价
    @TableField(value="expect_arrive_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date expectArriveDate; // 预计到货日期

    public Date getExpectArriveDate() {
        return expectArriveDate;
    }

    public void setExpectArriveDate(Date expectArriveDate) {
        this.expectArriveDate = expectArriveDate;
    }

    public BigDecimal getReceiveNum() {
        return receiveNum;
    }

    public void setReceiveNum(BigDecimal receiveNum) {
        this.receiveNum = receiveNum;
    }

    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }

    public BigDecimal getSumSendNum() {
        return sumSendNum;
    }

    public void setSumSendNum(BigDecimal sumSendNum) {
        this.sumSendNum = sumSendNum;
    }

    public Long getPurchaseContractId() {
        return purchaseContractId;
    }

    public void setPurchaseContractId(Long purchaseContractId) {
        this.purchaseContractId = purchaseContractId;
    }

    public String getPurchaseContractName() {
        return purchaseContractName;
    }

    public void setPurchaseContractName(String purchaseContractName) {
        this.purchaseContractName = purchaseContractName;
    }

    public BigDecimal getPurchaseContractPrice() {
        return purchaseContractPrice;
    }

    public void setPurchaseContractPrice(BigDecimal purchaseContractPrice) {
        this.purchaseContractPrice = purchaseContractPrice;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }


    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public BigDecimal getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(BigDecimal orderNum) {
        this.orderNum = orderNum;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

}
