package com.ejianc.business.material.controller;

import com.ejianc.business.material.service.ViewLimitService;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.io.Serializable;

/**
 * @author songlx@version 1.0
 * @description: 直入直出量价分离控制
 * @date 2022/5/31
 */
@RestController
@RequestMapping("/viewLimit/")
public class ViewLimitController implements Serializable {


    private Logger logger = LoggerFactory.getLogger(this.getClass());


    // 支出合同【修改合同状态】按钮可用角色白名单
    private static final String PARAM_CHANGE_CONTRACT_STATUS_CODE = "P-7mm73935";

    @Autowired
    private ViewLimitService viewLimitService;

    /***
     * @description: ；量价分离参数
     * 是否可以看金额和单价
     *
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.Boolean>
     * @author songlx
     * @date: 2022/5/31
     */
    @RequestMapping(value = "canView", method = RequestMethod.GET)
    public CommonResponse<Boolean> canView() {
        //判断当前用户角色是否在限制角色里
        Boolean b = viewLimitService.noView();
        //因为此处返回的是是否可用，则取反!b
        return CommonResponse.success("查询量价分离权限成功！", !b);
    }


    /**
     * @description: 支出合同【修改合同状态】按钮可用角色白名单
     *
     * @return {@link CommonResponse< Boolean>}
     * @author songlx
     * @date: 2022/8/9
     */
    @RequestMapping(value = "canUseChangeContractBtn", method = RequestMethod.GET)
    public CommonResponse<Boolean> canUseChangeContractBtn() {
        Boolean b = viewLimitService.getCanFlagByRoleAndParam(PARAM_CHANGE_CONTRACT_STATUS_CODE);
        return CommonResponse.success("查询支出合同【修改合同状态】按钮可用角色白名单成功！", b);
    }


}
