package com.ejianc.business.material.controller.api;

import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.vo.warn.MaterialWarnVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/materialWarn/")
public class MaterialWarnApi {
    @Autowired
    private IMaterialContractService materialService;
    /**
     * 租户下，按照项目分类，支出合同累计金额-物资合同累计
     * @param tenantIds
     * @return
     */
    @PostMapping(value = "materialProjectOutMny")
    public CommonResponse<List<MaterialWarnVo>> materialProjectOutMny(@RequestBody List<Long> tenantIds) {
        return CommonResponse.success("获取物资合同支出累计",materialService.materialProjectOutMny(tenantIds));
    }
}
