package com.ejianc.business.material.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.dataModel.vo.MaterialDataModelVO;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.controller.SqlParam;
import com.ejianc.business.material.vo.*;
import com.ejianc.business.material.vo.warn.MaterialWarnVo;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Mapper
public interface MaterialContractMapper extends BaseCrudMapper<MaterialContractEntity> {

    /**
     * 查询所有满足预警条件的项目合同
     *
     * @param sqlParamList
     * @return
     */
    List<Map<String, Object>> queryAllWarnContracts(@Param(value = "sqlParamList") List<SqlParam> sqlParamList);

    List<MaterialContractVO> queryContractTaxWarnContract(@Param(value = "sqlParamList") List<SqlParam> sqlParamList);

    List<MaterialWarnVo> materialProjectOutMny(@Param(value = "tenantIds") List<Long> tenantIds);

    List<MaterialReportVo> getMonthMaterialMny(@Param(value = "projectId") Long projectId, @Param(value = "lastDay") Integer lastDay);

    List<MaterialContractVO> queryWarnContracts(@Param(value = "tenantAllIds") List<Long> tenantAllIds);

    List<MaterialContractVO> queryWarnPrePayContracts(@Param(value = "tenantAllIds") List<Long> tenantAllIds);


    /***
     * @description: 根据项目id查询该项目物资总计划明细价格
     *
     * @param projectId
     * @return: java.util.List<com.ejianc.business.material.vo.MaterialPriceVO>
     * @author songlx
     * @date: 2021-05-25
     */
    List<MaterialPriceVO> queryPlanPriceByProjectId(@Param(value = "projectId") Long projectId, @Param(value = "materialIds") List<Long> materialIds);


    /***
     * @description: 根据租户id查询该物资结算价格区间
     *
     * @param tenantId tenantId
     * @return: java.util.List<com.ejianc.business.material.vo.MaterialPriceVO>
     * @author songlx
     * @date: 2021-05-25
     */
    List<MaterialPriceVO> querySettlePriceByTenantId(@Param(value = "tenantId") Long tenantId, @Param(value = "materialIds") List<Long> materialIds);

    /**
     * @description: 查询已生效的合同物资数量
     *
     * @param contractId
     * @param projectId
     * @param materialIds
     * @return: java.util.List<com.ejianc.business.material.vo.MaterialPriceVO>
     * @author songlx
     * @date: 2021-05-26
     */
    List<MaterialPriceVO> queryMaterialContractCount(@Param(value = "contractId") Long contractId, @Param(value = "projectId") Long projectId, @Param(value = "materialIds") List<Long> materialIds);

    /***
     * @description: 查询该物资结算价格区间
     *
     * @param projectId
     * @param contractId
     * @param orgId
     * @param materialIds
     * @return: java.util.List<com.ejianc.business.material.vo.MaterialPriceVO>
     * @author songlx
     * @date: 2021-05-27
     */
    List<MaterialPriceVO> querySettlePriceByParam(@Param(value = "projectId") Long projectId,
                                                  @Param(value = "contractId") Long contractId,
                                                  @Param(value = "orgId") Long orgId,
                                                  @Param(value = "materialIds") List<Long> materialIds);

    List<MaterialContractDetailSubVO> queryListByMaterial(Map<String, Object> queryParam);

    /**
     * 统计历史累计工程量和金额
     *
     * @param contractId  合同id
     * @param projectId   项目id
     * @param materialIds 物资档案ids
     *
     * @return {@link Map}<{@link Long}, {@link MaterialContractDetailSubVO}>
     */
    @MapKey(value = "materialId")
    Map<Long, MaterialPriceVO> sumLastTotalNumAndTotalAmount(@Param(value = "contractId") Long contractId,
                                                             @Param(value = "projectId") Long projectId,
                                                             @Param(value = "materialIds") Set<Long> materialIds);

    /**
     * 历史累计物资采购合同总金额(含变更中，有变更中取变更中的)
     *
     * @param projectId  项目id
     * @param contractId 合同id
     *
     * @return {@link BigDecimal}
     */
    BigDecimal sumLastTotalAmountWithTax(@Param(value = "projectId") Long projectId,
                                         @Param(value = "contractId") Long contractId);

    /**
     * @description: 查询材料数据模型
     */
    List<MaterialDataModelVO> queryMaterialDataModelList(@Param("projectId") Long projectId,
                                                         @Param("contractId") Long contractId,
                                                         @Param(Constants.WRAPPER) QueryWrapper queryWrapper);

    /**
     * 根据材料分类id查询合同大类数量
     *
     * @param projectId    项目id
     * @param contractId   合同id
     * @param queryWrapper 查询条件
     * @return 查询结果
     */
    List<MaterialDataModelVO> queryContractByMaterialTypeIdList(@Param("projectId") Long projectId,
                                                                @Param("contractId") Long contractId,
                                                                @Param(Constants.WRAPPER) QueryWrapper queryWrapper);

    List<MaterialDataModelVO> queryListByMaterialId(@Param("projectId") Long projectId,
                                                    @Param("contractId") Long contractId,
                                                    @Param(Constants.WRAPPER) QueryWrapper queryWrapper);

    List<MaterialDataModelVO> queryListByMaterialTypeId(@Param("projectId") Long projectId,
                                                        @Param("contractId") Long contractId,
                                                        @Param(Constants.WRAPPER) QueryWrapper queryWrapper);

    BigDecimal fetchSjzcje(@Param("projectId") Long projectId,
                           @Param("contractId") Long contractId);


    List<MaterialApplyCountVO> queryMaterialDetailCount(@Param(value = "projectId") Long projectId, @Param(value = "materialIds") List<Long> materialIds);

    List<MaterialContractPriceResultVO> queryMaterialContractPrice(@Param(value = "projectId") Long projectId, @Param(value = "materialIds") List<Long> materialIds);
}
