package com.ejianc.business.material.mapper;

import com.ejianc.business.material.vo.BuyPriceDetailVO;
import com.ejianc.business.material.vo.BuyPriceVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface ReportMapper {


    /**
     * @param tenantId
     * @param materialTypeId
     * @param startDay
     * @param endDay
     * @description: 采购价格分析
     * @return: java.util.List<com.ejianc.business.material.vo.BuyPriceVO>
     * @author songlx
     * @date: 2021-04-08
     */
    List<BuyPriceVO> queryBuyPriceList(@Param("tenantId") Long tenantId);


    /**
     * @param tenantId
     * @description: 查询价格分析明细列表
     * @return: java.util.List<com.ejianc.business.material.vo.BuyPriceDetailVO>
     * @author songlx
     * @date: 2021-04-09
     */
    List<BuyPriceDetailVO> queryBuyPriceDetailList(@Param("tenantId") Long tenantId);


    List<BuyPriceVO> queryBuyPrice(@Param("tenantId") Long tenantId, @Param("materialTypeIds") List<Long> materialTypeIds, @Param("startDate") String startDate, @Param("endDate") String endDate,
                                   @Param("materialTypeName")String materialTypeName, @Param("materialName") String materialName, @Param("model") String model, @Param("unit") String unit);
}
