package com.ejianc.business.material.mapper;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.material.vo.StoreDataVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

@Mapper
public interface StoreTopMapper {
    /**
     * 统计物料前10的物料
     * @param orgIds
     * @return
     */
    List<JSONObject> constructionStoreTop(@Param("orgIds") String orgIds);

    /**
     * 统计项目下的物料占用
     * @param orgIds
     * @param materialId
     * @return
     */
    List<JSONObject> constructionStoreTopProject(@Param("orgIds") String orgIds,@Param("materialId") Long materialId);

    /**
     * 统计项目下 物资合同的 物资价格
     * @param projectIds
     * @param materialId
     * @return
     */
    List<JSONObject> constructionStoreTopContract(@Param("projectIds") String projectIds,@Param("materialId") Long materialId,@Param("orgIds")String orgIds);

    /**
     * 按照合同统计
     * @param tenantId
     * @param materialId
     * @return
     */
    BigDecimal constructionStoreTopContractCompany(@Param("tenantId") Long tenantId,@Param("materialId") Long materialId );

    /**
     * 项目的已生效的物资总计划【总计划金额】合计值；
     * @param orgIds
     * @return
     */
    BigDecimal planTotalMny(@Param("orgIds") String orgIds);

    /**
     *  所有项目的已生效的收料入库/直入直出表体【金额】合计值；
     * @return
     */
    BigDecimal inStoreTotalMny(@Param("orgIds") String orgIds);

    /**
     * 所有项目的已生效的收料入库/直入直出表体【金额】合计值；
     * @param orgIds
     * @return
     */
    BigDecimal storeTotalMny(@Param("orgIds") String orgIds);

    /**
     * 根据orgId 返回项目统计数据
     * @param orgIds
     * @return
     */
    List<StoreDataVo> storeData(@Param("orgIds") String orgIds,@Param("planSort") String planSort,@Param("inStoreSort") String
            inStoreSort ,@Param("storeSort") String storeSort);

}
