package com.ejianc.business.material.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.material.bean.InstoreBillEntity;
import com.ejianc.business.material.vo.InstoreBillMaterialVO;
import com.ejianc.business.material.vo.InstoreBillVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

public interface IInstoreBillService extends IBaseService<InstoreBillEntity> {

	IPage<InstoreBillVO> queryForList(QueryParam queryParam, boolean isEs);

	void sureToReceive(InstoreBillEntity entity);

	void sureToReturn(InstoreBillEntity entity);

	void processCost(InstoreBillEntity entity);

	List<InstoreBillMaterialVO> instoreNumCount(Map<String, Object> queryParam);

	List<InstoreBillVO> amountSum(List<Long> projectIds);

	/**
	 * 向直入直出管理中推送数据
	 * @param billId
	 */
    void pushInstoreManage(Long billId);

	/**
	 *  判断直入直出单是否能弃审
	 * @param billId
	 */
	boolean instoreIsRevoke(Long billId);

	/**
	 *  删除直入直出管理 单据
	 * @param billId
	 */
	void deleteInstoreBill(Long billId);
}
