package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.mapper.InstoreMapper;
import com.ejianc.business.material.mapper.InstoreMaterialMapper;
import com.ejianc.business.material.pub.MaterialStoreState;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.service.IInstoreMaterialService;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.vo.InstoreAccountSumVO;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.InstoreVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;


@Service
public class InstoreService  extends BaseServiceImpl<InstoreMapper, InstoreEntity> implements IInstoreService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IOutStoreService iOutStoreService;
    @Autowired
    private ICostDetailApi iCostDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IInstoreMaterialService materialService;

    @Autowired
    private InstoreMaterialMapper instoreMaterialMapper;


    @Override
    public IPage<InstoreVO> queryForList(QueryParam queryParam, boolean isEs) {
        IPage<InstoreVO> voPage = null;
        IPage<InstoreEntity> entityPage = super.queryPage(queryParam,isEs);
        if(entityPage!=null){
            voPage = new Page<>();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(entityPage.getRecords(),InstoreVO.class));
        }
        return voPage;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void sureToReceive(InstoreEntity entity) {
        entity.getInstoreMaterialList().forEach(e->{
            e.setStoreId(entity.getStoreId());
            e.setStoreState(MaterialStoreState.STORED.getCode());
        });
        super.saveOrUpdate(entity,false);
        OutStoreEntity outStoreEntity = iOutStoreService.selectById(entity.getOutId());
        if(outStoreEntity == null ){
            throw new BusinessException("没有找到对应调拨出库单，确认收料失败！");
        }
        outStoreEntity.setReceiveState(entity.getReceiveState());
        outStoreEntity.setReceivePerson(entity.getReceivePerson());
        outStoreEntity.getOutStoreSubEntities().forEach(o-> o.setStoreState(MaterialStoreState.USED.getCode()));
        iOutStoreService.saveOrUpdate(outStoreEntity,false);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void sureToReturn(InstoreEntity entity) {
        super.saveOrUpdate(entity,false);
        OutStoreEntity outStoreEntity = iOutStoreService.selectById(entity.getOutId());
        if(outStoreEntity == null ){
            throw new BusinessException("没有找到对应调拨出库单，确认收料失败！");
        }
        outStoreEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        outStoreEntity.setReceiveState(entity.getReceiveState());
        outStoreEntity.setReceivePerson(entity.getReceivePerson());
        outStoreEntity.setReturnReason(entity.getPickReturnReason());
        outStoreEntity.getOutStoreSubEntities().forEach(o-> o.setStoreState(MaterialStoreState.OCCUPY.getCode()));
        iOutStoreService.saveOrUpdate(outStoreEntity,false);
    }

    @Override
    public void processCost(InstoreEntity entity) {
        String factor = "1";
        if(MaterialStoreType.RETURN_IN_STORE.getCode().equals(entity.getInstoreType())){
            factor = "-1";
        }
        if(ListUtil.isNotEmpty(entity.getInstoreMaterialList())){
            List<CostDetailVO> list = new ArrayList<>();
            boolean canPush = true;
            for (int i = 0;i<entity.getInstoreMaterialList().size();i++){
                InstoreMaterialEntity sub = entity.getInstoreMaterialList().get(i);
                if (null == sub.getSubjectId()) {
                    canPush = false;
                }
                CostDetailVO c = new CostDetailVO();
                c.setSubjectId(sub.getSubjectId());
                c.setSourceId(entity.getId());
                c.setSourceDetailId(sub.getId());
                c.setProjectId(entity.getProjectId());
                c.setHappenTaxMny(sub.getAmount() == null ? new BigDecimal("0.00") : sub.getAmount().multiply(new BigDecimal(factor)));
                if (sub.getAmount() == null) {
                    c.setHappenMny(new BigDecimal("0.00"));
                } else {
                    BigDecimal rate = new BigDecimal("1.00");
                    if ("-1".equals(factor)) {//物资退库
                        rate = rate.add(sub.getTaxRate() == null ? new BigDecimal("0.00") : sub.getTaxRate().divide(new BigDecimal("100.00"), 8, BigDecimal.ROUND_HALF_UP));
                    } else {
                        rate = rate.add(entity.getTaxRate() == null ? new BigDecimal("0.00") : entity.getTaxRate().divide(new BigDecimal("100.00"), 8, BigDecimal.ROUND_HALF_UP));
                    }
                    BigDecimal happenMny = sub.getAmount().divide(rate, 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(factor));
                    c.setHappenMny(happenMny);
                }
                c.setHappenDate(entity.getInstoreDate());
                c.setMemo(entity.getNote());
                c.setCreateUserName(sessionManager.getUserContext().getUserName());
                c.setSourceType(MaterialStoreType.getEnumNameByCode(entity.getInstoreType()));
                c.setSourceTabType(MaterialStoreType.getEnumNameByCode(entity.getInstoreType()) + "_DETAIL");

                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
                LocalDate instoreDate = entity.getInstoreDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

                c.setCostType(CostTypeEnum.MATERIAL_COST_TYPE.getType()); // 费用类型 说明：按照预算枚举传
                c.setCostTypeName(CostTypeEnum.MATERIAL_COST_TYPE.getName()); // 费用类型名称 说明：按照预算枚举传
                c.setPeriod(instoreDate.format(df)); // 期间 说明：按发生日期（happenDate）格式化成年月（2022-09 ） 传
                c.setShareFlag(0); // 归集状态(1:是，0：否)    说明：传0
                // c.setShareId(); // 归集单据id 说明：不用传
                c.setSourceBillCode(entity.getBillCode()); // 来源单据编码 说明：XHCCHECK00000190
                if (Objects.equals(MaterialStoreType.RETURN_IN_STORE.getCode(), sub.getInstoreType())) {
                    c.setSourceBillName(MaterialStoreType.RETURN_IN_STORE.getDescription()); // 来源单据名称 说明：材料验收单
                    c.setSourceBillUrl("/ejc-material-frontend/#/pickReturn/card?id=" + entity.getId()); // 来源单据url 说明：/ejc-promaterial-frontend/#/check/contractCard?id=585483774737809479
                }
                if (Objects.equals(MaterialStoreType.STRAIGHT_IN_STORE.getCode(), sub.getInstoreType())) {
                    c.setSourceBillName(MaterialStoreType.STRAIGHT_IN_STORE.getDescription()); // 来源单据名称 说明：材料验收单
                    c.setSourceBillUrl("/ejc-material-frontend/#/straightInout/card?id=" + entity.getId()); // 来源单据url 说明：/ejc-promaterial-frontend/#/check/contractCard?id=585483774737809479
                }
                c.setNum(sub.getInstoreNumber() == null ? BigDecimal.ZERO : sub.getInstoreNumber()); // 发生数量 说明：子表有数量的都传，包含分包清单工程量

                // 以下信息物资、设备、周转材档案类传
                c.setMaterialId(sub.getMaterialId()); // 物资主键
                // c.setMaterialCode(sub.getMaterialCode()); // 物料编码
                c.setMaterialName(sub.getMaterialName()); // 物资名称
                c.setMaterialTypeId(sub.getMaterialCategoryId()); // 物资类别
                c.setMaterialTypeName(sub.getMaterialCategoryName()); // 物资类别名称
                c.setUnit(sub.getMaterialUnit()); // 单位名称
                // c.setUnitId(); // 单位主键
                c.setSpec(sub.getMaterialSpec()); // 规格型号

                list.add(c);
            }
            CommonResponse<String> response = iCostDetailApi.saveSubject(list);
            logger.info("推送成本" + MaterialStoreType.getStoreTypeNameByCode(entity.getInstoreType()) + "结果:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
            entity.setRelationFlag(canPush ? "1" : "0");
            // if(canPush){
            //     CommonResponse<String> response = iCostDetailApi.saveSubject(list);
            //     logger.info("推送成本"+MaterialStoreType.getStoreTypeNameByCode(entity.getInstoreType())+"结果:"+response.isSuccess()+" msg:"+response.getMsg()+" billId="+entity.getId());
            //     entity.setRelationFlag("1");
            // }else {
            //     CommonResponse<String> response = iCostDetailApi.deleteSubject(entity.getId());
            //     logger.info("删除成本"+MaterialStoreType.getStoreTypeNameByCode(entity.getInstoreType())+"结果:"+response.isSuccess()+" msg:"+response.getMsg()+" billId="+entity.getId());
            //     entity.setRelationFlag("0");
            // }
        }else {
            iCostDetailApi.deleteSubject(entity.getId());
            entity.setRelationFlag("0");
        }
    }

    @Override
    public List<InstoreMaterialVO> instoreNumCount(Map<String, Object> queryParam) {
        return instoreMaterialMapper.instoreNumCount(queryParam);
    }

    @Override
    public List<InstoreAccountSumVO> amountSum(List<Long> projectIds) {
        return instoreMaterialMapper.amountSum(projectIds);
    }

    @Override
    public BigDecimal calculateTotalSettlement(QueryParam queryParam) {
        QueryWrapper<InstoreEntity> query = changeToQueryWrapper(queryParam);
        query.select("sum(total_amount) as totalAmount");
        Map<String, Object> amount = super.getMap(query);
        return null != amount ? new BigDecimal(amount.get("totalAmount").toString()) : BigDecimal.ZERO.setScale(8);
    }

    @Override
    public List<MaterialContractDetailSubEntity> totalResidualQuantity(List<MaterialContractDetailSubEntity> records ){
        Map<Long, MaterialContractDetailSubEntity> detailMap = records.stream().collect(Collectors.toMap(MaterialContractDetailSubEntity::getId, e -> e));
        List<Long> ids=new ArrayList(detailMap.keySet());
        //查询对应清单的入库数量
        QueryWrapper<InstoreMaterialEntity> query = new QueryWrapper<>();
        query.select("source_id as sourceId,sum(instore_number) as instoreNumber");
        query.eq("source_type","contractMaterial");
        query.in("source_id",ids);
        query.groupBy("source_id");
        List<InstoreMaterialEntity> list = materialService.list(query);
        if (CollectionUtils.isEmpty(list)){
            for (MaterialContractDetailSubEntity entity:records){
                entity.setResidualQuantity(entity.getCount());
            }
            return records;
        }
        Map<Long, BigDecimal> collect = list.stream().collect(Collectors.toMap(InstoreMaterialEntity::getSourceId, InstoreMaterialEntity::getInstoreNumber));
        for (Long id:ids){
            BigDecimal bigDecimal = BigDecimal.ZERO;
            if (collect.containsKey(id)){
                bigDecimal= collect.get(id).compareTo(new BigDecimal(0E-8))==0?new BigDecimal(0):collect.get(id);;
            }
            MaterialContractDetailSubEntity detailSub = detailMap.get(id);
            if (bigDecimal.compareTo(detailSub.getCount())>-1){
                detailMap.remove(id);
            }else {
                detailSub.setResidualQuantity(detailSub.getCount().subtract(bigDecimal));
                detailMap.put(id,detailSub);
            }
        }
        Collection<MaterialContractDetailSubEntity> values = detailMap.values();
        return new ArrayList<>(values);
    }


    @Override
    public CommonResponse<String> updateInStoreSettleFlag(List<InstoreMaterialVO> vos){
        Map<String, List<InstoreMaterialVO>> groupList = vos.stream().collect(Collectors.groupingBy(InstoreMaterialVO::getSettleFlag));
        if (groupList.containsKey("1")){
            List<InstoreMaterialVO> settleTrueList = groupList.get("1");
            List<Long> settleTrueIds = settleTrueList.stream().map(e -> e.getId()).collect(Collectors.toList());
            LambdaUpdateWrapper<InstoreMaterialEntity> wrapper = new LambdaUpdateWrapper();
            wrapper.in(InstoreMaterialEntity::getId,settleTrueIds);
            wrapper.set(InstoreMaterialEntity::getSettleFlag,"1");
            materialService.update(wrapper);
        }
        if (groupList.containsKey("0")){
            List<InstoreMaterialVO> settleFalseList = groupList.get("0");
            List<Long> settleFalseIds = settleFalseList.stream().map(e -> e.getId()).collect(Collectors.toList());
            LambdaUpdateWrapper<InstoreMaterialEntity> wrapper = new LambdaUpdateWrapper();
            wrapper.in(InstoreMaterialEntity::getId,settleFalseIds);
            wrapper.set(InstoreMaterialEntity::getSettleFlag,"0");
            materialService.update(wrapper);
        }
        return CommonResponse.success("保存或修改单据成功！","");
    }

}
