package com.ejianc.business.material.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ComparePriceVO extends BaseVO {
    /**
     * 单据状态
     */
    private Integer billState;

    /**
     * 询比价单号
     */
    private String billCode;

    /**
     * 属于项目 ？ 0是，1不是
     */
    private Integer belongToProject;

    /**
     * 项目名称参照
     */
    private Long projectId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 所属组织名称
     */
    private String orgName;

    /**
     * 所属组织参照
     */
    private Long orgId;

    /**
     * 询价单名称
     */
    private String name;

    /**
     * 材料类别名称
     */
    private String materialTypeName;

    /**
     * 材料类别id
     */
    private Long materialTypeId;

    /**
     * 询价人
     */
    private String inquiryPerson;

    /**
     * 询价时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date inquiryDate;

    /**
     * 备注
     */
    private String memo;

    /**
     * 推荐供应商id
     */
    private String recommendSupplier;

    /**
     * 推荐供应商
     */
    private String recommendSupplierName;

    /**
     * 供应商价格
     */
    private BigDecimal recommendPrice;

    private List<ComparePriceSubVO> priceSubEntities = new ArrayList<>();

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBelongToProject() {
        return belongToProject;
    }

    public void setBelongToProject(Integer belongToProject) {
        this.belongToProject = belongToProject;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getInquiryPerson() {
        return inquiryPerson;
    }

    public void setInquiryPerson(String inquiryPerson) {
        this.inquiryPerson = inquiryPerson;
    }

    public Date getInquiryDate() {
        return inquiryDate;
    }

    public void setInquiryDate(Date inquiryDate) {
        this.inquiryDate = inquiryDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getRecommendSupplier() {
        return recommendSupplier;
    }

    public void setRecommendSupplier(String recommendSupplier) {
        this.recommendSupplier = recommendSupplier;
    }

    public String getRecommendSupplierName() {
        return recommendSupplierName;
    }

    public void setRecommendSupplierName(String recommendSupplierName) {
        this.recommendSupplierName = recommendSupplierName;
    }

    public BigDecimal getRecommendPrice() {
        return recommendPrice;
    }

    public void setRecommendPrice(BigDecimal recommendPrice) {
        this.recommendPrice = recommendPrice;
    }

    public List<ComparePriceSubVO> getPriceSubEntities() {
        return priceSubEntities;
    }

    public void setPriceSubEntities(List<ComparePriceSubVO> priceSubEntities) {
        this.priceSubEntities = priceSubEntities;
    }
}
