package com.ejianc.business.plan.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 物资总计划实体
 *
 * @author CJ
 * @Description: 物资总计划实体
 * @date 2021/3/2 16:41
 */
@TableName(value = "ejc_material_master_plan")
public class MaterialMasterPlanEntity extends BaseEntity {

    private static final long serialVersionUID = -6183263322057406178L;

    /**
     * 项目Id
     */
    @TableField(value = "project_id")
    private Long projectId;

    /**
     * 所属项目部Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属项目部名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 项目名称
     */
    @TableField(value = "project_name")
    private String projectName;
    /**
     * 计划编码
     */
    @TableField(value = "plan_code")
    private String planCode;
    /**
     * 总计划金额
     */
    @TableField(value = "total_plan_amt")
    private BigDecimal totalPlanAmt;
    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;

    @TableField(exist = false)
    @SubEntity(serviceName = "materialMasterPlanSubService", pidName = "materialMasterPlanId")
    private List<MaterialMasterPlanSubEntity> materialSubList;

    /**
     * 变更状态: 0-未变更，1-变更中，2-已变更
     */
    @TableField(value = "change_state")
    private Integer changeState;

    /**
     * 单据状态
     */
    @TableField(value = "bill_state")
    private Integer billState;

    /**
     * 变更中的变更计划Id
     */
    @TableField(value = "cur_changing_plan_id")
    private Long curChangingPlanId;

    /**
     * 创建人名称
     */
    @TableField(value = "create_user_name")
    private String createUserName;

    /**
     * 修改人名称
     */
    @TableField(value = "modify_user_name")
    private String modifyUserName;

    /**
     * 提交日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "commit_date")
    private Date commitDate;

    /**
     * 提交人名称
     */
    @TableField(value = "commit_user_name")
    private String commitUserName;

    /**
     * 提交人账号
     */
    @TableField(value = "commit_user_code")
    private String commitUserCode;

    /**
     * 生效日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "effective_date")
    private Date effectiveDate;

    /**
     * 变更版本
     */
    @TableField(value = "change_version")
    private Integer changeVersion;

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Long getCurChangingPlanId() {
        return curChangingPlanId;
    }

    public void setCurChangingPlanId(Long curChangingPlanId) {
        this.curChangingPlanId = curChangingPlanId;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getPlanCode() {
        return planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }

    public BigDecimal getTotalPlanAmt() {
        return totalPlanAmt;
    }

    public void setTotalPlanAmt(BigDecimal totalPlanAmt) {
        this.totalPlanAmt = totalPlanAmt;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<MaterialMasterPlanSubEntity> getMaterialSubList() {
        return materialSubList;
    }

    public void setMaterialSubList(List<MaterialMasterPlanSubEntity> materialSubList) {
        this.materialSubList = materialSubList;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
}
