/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dataModel.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.dataModel.consts.DataModelEnum;
import com.ejianc.business.dataModel.vo.MaterialDataModelVO;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialDataModelService")
public class MaterialDataModelService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MaterialContractMapper contractMapper;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;

    public List<MaterialDataModelVO> queryList(Long projectId, Long contractId, QueryWrapper<T> queryWrapper) {
        return this.contractMapper.queryMaterialDataModelList(projectId, contractId, queryWrapper);
    }

    public List<MaterialDataModelVO> queryContractByMaterialTypeIdList(Long projectId, Long contractId, QueryWrapper<T> queryWrapper) {
        return this.contractMapper.queryContractByMaterialTypeIdList(projectId, contractId, queryWrapper);
    }

    public List<MaterialDataModelVO> queryListByProjectId(JSONObject param) {
        this.logger.info("\u9879\u76ee\u6750\u6599\u60c5\u51b5\u5165\u53c2 : {}", (Object)param);
        Map<String, List<Long>> listMap = this.processData(param);
        this.logger.info("listMap\uff1a{}", (Object)JSONObject.toJSONString(listMap));
        Long projectId = param.getLong("projectId");
        String billTypeCode = param.getString("billTypeCode");
        boolean isTypeFlag = this.isMaterialTypeFlag(billTypeCode);
        List<Long> materialTypeIds = !isTypeFlag ? listMap.get("allMaterialTypeIds") : listMap.get("materialTypeIds");
        List<Long> materialIds = listMap.get("materialIds");
        this.logger.info("isTypeFlag:{}", (Object)isTypeFlag);
        this.logger.info("materialTypeIds:{}", (Object)JSONObject.toJSONString(materialTypeIds));
        this.logger.info("materialIds:{}", (Object)JSONObject.toJSONString(materialIds));
        List<MaterialDataModelVO> materialDataModelVOs = new ArrayList<MaterialDataModelVO>();
        if (CollectionUtils.isNotEmpty(materialIds) || CollectionUtils.isNotEmpty(materialTypeIds)) {
            materialDataModelVOs = this.queryMaterialDataList(projectId, null, materialIds, materialTypeIds);
        }
        if (CollectionUtils.isNotEmpty(materialDataModelVOs = this.getChildrenData(param, materialDataModelVOs))) {
            CommonResponse mapCommonResponse = this.budgetProjectProApi.getBudgetProjectProQuantityByProjectId(projectId);
            this.logger.info("\u67e5\u8be2\u9884\u7b97\u603b\u91cf\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)mapCommonResponse));
            if (mapCommonResponse.isSuccess()) {
                Map materialTypeMap = (Map)mapCommonResponse.getData();
                for (MaterialDataModelVO materialDataModelVO : materialDataModelVOs) {
                    if (materialTypeMap == null) continue;
                    BigDecimal budgetNum = (BigDecimal)materialTypeMap.get(materialDataModelVO.getMaterialId());
                    if (budgetNum == null) {
                        budgetNum = BigDecimal.ZERO;
                    }
                    materialDataModelVO.setBudgetNum(budgetNum);
                }
            }
            materialDataModelVOs = materialDataModelVOs.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<MaterialDataModelVO>(Comparator.comparing(o -> o.getMaterialId()))), ArrayList::new));
        }
        return materialDataModelVOs;
    }

    public List<MaterialDataModelVO> queryListByContractId(JSONObject param) {
        this.logger.info("\u5408\u540c\u6750\u6599\u60c5\u51b5\u5165\u53c2 : {}", (Object)param);
        Map<String, List<Long>> listMap = this.processData(param);
        Object bill = param.get((Object)"bill");
        JSONObject content = new JSONObject((Map)((HashMap)bill));
        String billTypeCode = (String)param.get((Object)"billTypeCode");
        boolean isTypeFlag = this.isMaterialTypeFlag(billTypeCode);
        Long contractId = null;
        if (DataModelEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode().equals(billTypeCode)) {
            contractId = content.getLong("id");
        } else if (content.get((Object)"contractId") != null) {
            JSONObject contract = new JSONObject((Map)((HashMap)content.get((Object)"contractId")));
            contractId = contract.getLong("id");
        }
        List<Long> materialTypeIds = !isTypeFlag ? listMap.get("allMaterialTypeIds") : listMap.get("materialTypeIds");
        List<Long> materialIds = listMap.get("materialIds");
        this.logger.info("isTypeFlag:{}", (Object)isTypeFlag);
        this.logger.info("materialTypeIds:{}", (Object)JSONObject.toJSONString(materialTypeIds));
        this.logger.info("materialIds:{}", (Object)JSONObject.toJSONString(materialIds));
        List<MaterialDataModelVO> materialDataModelVOs = new ArrayList<MaterialDataModelVO>();
        if (contractId != null && (CollectionUtils.isNotEmpty(materialIds) || CollectionUtils.isNotEmpty(materialTypeIds))) {
            materialDataModelVOs = this.queryMaterialDataList(null, contractId, materialIds, materialTypeIds);
        }
        materialDataModelVOs = this.getChildrenData(param, materialDataModelVOs);
        materialDataModelVOs = materialDataModelVOs.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<MaterialDataModelVO>(Comparator.comparing(o -> o.getMaterialId()))), ArrayList::new));
        return materialDataModelVOs;
    }

    private List<MaterialDataModelVO> queryMaterialDataList(Long projectId, Long contractId, List<Long> materialIdList, List<Long> materialTypeIdList) {
        this.logger.info("\u67e5\u8be2\u6570\u636e\u6a21\u578b\u53c2\u6570\uff1aprojectId:{},contractId:{}", (Object)projectId, (Object)contractId);
        this.logger.info("materialIdList\uff1a{}", (Object)JSONObject.toJSONString(materialIdList));
        this.logger.info("materialTypeIdList\uff1a{}", (Object)JSONObject.toJSONString(materialTypeIdList));
        ArrayList<MaterialDataModelVO> rtnList = new ArrayList<MaterialDataModelVO>();
        QueryWrapper materialWrapper = new QueryWrapper();
        materialWrapper.in(CollectionUtils.isNotEmpty(materialIdList), (Object)"material_id", materialIdList);
        List<MaterialDataModelVO> materialModelList = this.contractMapper.queryListByMaterialId(projectId, contractId, materialWrapper);
        rtnList.addAll(materialModelList);
        this.logger.info("\u67e5\u8be2\u6570\u636e\u6a21\u578b\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(rtnList));
        return rtnList;
    }

    private Map<String, List<Long>> processData(JSONObject param) {
        JSONArray jsonArray;
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        String materialTypeId = "materialTypeId";
        ArrayList<Long> materialIds = new ArrayList<Long>();
        ArrayList<Long> materialTypeIds = new ArrayList<Long>();
        ArrayList<Long> allMaterialTypeIds = new ArrayList<Long>();
        String billTypeCode = (String)param.get((Object)"billTypeCode");
        String subTableName = DataModelEnum.getByCode(billTypeCode).getName();
        Object bill = param.get((Object)"bill");
        JSONObject content = new JSONObject((Map)((HashMap)bill));
        if (content.get((Object)subTableName) != null && (jsonArray = content.getJSONArray(subTableName)) != null) {
            if (DataModelEnum.\u7269\u8d44\u603b\u8ba1\u5212.getCode().equals(billTypeCode) || DataModelEnum.\u7269\u8d44\u603b\u8ba1\u5212\u53d8\u66f4.getCode().equals(billTypeCode)) {
                materialTypeId = "materialCategoryId";
            }
            for (Object o : jsonArray) {
                JSONObject subContent = new JSONObject((Map)((HashMap)o));
                if (subContent.get((Object)"materialId") != null) {
                    String materialId = (String)subContent.get((Object)"materialId");
                    materialIds.add(Long.parseLong(materialId));
                } else {
                    String materialCategoryId = (String)subContent.get((Object)materialTypeId);
                    materialTypeIds.add(Long.parseLong(materialCategoryId));
                }
                if (subContent.get((Object)materialTypeId) == null) continue;
                allMaterialTypeIds.add(Long.parseLong(subContent.getString(materialTypeId)));
            }
        }
        map.put("materialTypeIds", materialTypeIds);
        map.put("materialIds", materialIds);
        map.put("allMaterialTypeIds", allMaterialTypeIds);
        return map;
    }

    private List<MaterialDataModelVO> getChildrenData(JSONObject param, List<MaterialDataModelVO> materialDataModelVOs) {
        JSONArray jsonArray;
        this.logger.info("\u6570\u636e\u6a21\u578b\u5904\u7406\u8fd4\u56de\u6570\u636e\uff1aparam:{}", (Object)param);
        this.logger.info("materialDataModelVOs:{}", (Object)JSONObject.toJSONString(materialDataModelVOs));
        ArrayList<MaterialDataModelVO> list = new ArrayList<MaterialDataModelVO>();
        Long projectId = param.getLong("projectId");
        String materialTypeId = "materialTypeId";
        String materialTypeName = "materialTypeName";
        String space = "space";
        String unit = "unit";
        String billTypeCode = (String)param.get((Object)"billTypeCode");
        String subTableName = DataModelEnum.getByCode(billTypeCode).getName();
        Object bill = param.get((Object)"bill");
        JSONObject content = new JSONObject((Map)((HashMap)bill));
        Map materialMap = materialDataModelVOs.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.toMap(MaterialDataModelVO::getMaterialId, Function.identity(), (key1, key2) -> key2));
        this.logger.info("\u6839\u636ematerialId\u7ec4\u88c5map\u7ed3\u679c:materialMap:{}", (Object)JSONObject.toJSONString(materialMap));
        Map materialTypeMap = materialDataModelVOs.stream().filter(s -> s.getMaterialId() == null).collect(Collectors.toMap(MaterialDataModelVO::getMaterialTypeId, Function.identity(), (key1, key2) -> key2));
        this.logger.info("\u6839\u636ematerialTypeId\u7ec4\u88c5map\u7ed3\u679c:materialTypeMap:{}", (Object)JSONObject.toJSONString(materialTypeMap));
        if (content.get((Object)subTableName) != null && (jsonArray = content.getJSONArray(subTableName)) != null) {
            if (DataModelEnum.\u7269\u8d44\u603b\u8ba1\u5212.getCode().equals(billTypeCode) || DataModelEnum.\u7269\u8d44\u603b\u8ba1\u5212\u53d8\u66f4.getCode().equals(billTypeCode) || DataModelEnum.\u6536\u6599\u5165\u5e93\u5355.getCode().equals(billTypeCode) || DataModelEnum.\u76f4\u5165\u76f4\u51fa\u5355.getCode().equals(billTypeCode)) {
                materialTypeName = "materialCategoryName";
                materialTypeId = "materialCategoryId";
            }
            if (DataModelEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode().equals(billTypeCode) || DataModelEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u53d8\u66f4.getCode().equals(billTypeCode)) {
                unit = "measureUnit";
            }
            if (DataModelEnum.\u6536\u6599\u5165\u5e93\u5355.getCode().equals(billTypeCode) || DataModelEnum.\u76f4\u5165\u76f4\u51fa\u5355.getCode().equals(billTypeCode)) {
                unit = "materialUnit";
                space = "materialSpec";
            }
            if (DataModelEnum.\u7269\u8d44\u5408\u540c\u7ed3\u7b97\u5355.getCode().equals(billTypeCode) || DataModelEnum.\u7269\u8d44\u603b\u8ba1\u5212\u53d8\u66f4.getCode().equals(billTypeCode) || DataModelEnum.\u9879\u76ee\u7528\u6599\u7533\u8bf7.getCode().equals(billTypeCode)) {
                space = "model";
            }
            for (Object o : jsonArray) {
                JSONObject subContent = new JSONObject((Map)((HashMap)o));
                MaterialDataModelVO materialDataModelVO = new MaterialDataModelVO();
                long materialType = Long.parseLong(subContent.get((Object)materialTypeId).toString());
                long materialId = Long.parseLong(subContent.get((Object)"materialId") != null ? subContent.get((Object)"materialId").toString() : Long.toString(0L));
                this.logger.info("\u5faa\u73af\u5904\u7406\uff0cmaterialId:{},materialTypeId:{}", (Object)materialId, (Object)materialType);
                if (materialMap.containsKey(materialId)) {
                    materialDataModelVO = (MaterialDataModelVO)materialMap.get(materialId);
                    if (BigDecimal.ZERO.compareTo(materialDataModelVO.getContractNum()) == 0) {
                        MaterialDataModelVO typeModel = (MaterialDataModelVO)materialTypeMap.get(materialType);
                        this.logger.info("\u6839\u636e\u6750\u6599\u67e5\u8be2\u5408\u540c\u91cf\u4e3a0\uff0c\u53d6\u5206\u7c7b\u91cf\uff1a{}", (Object)JSONObject.toJSONString((Object)typeModel));
                        materialDataModelVO.setContractNum(typeModel == null ? BigDecimal.ZERO : typeModel.getContractNum());
                    }
                    this.logger.info("\u4ecematerialMap\u4e2d\u53d6\u503c\uff0c\u6b64\u65f6materialDataModelVO={}", (Object)JSONObject.toJSONString((Object)materialDataModelVO));
                }
                if (materialTypeMap.containsKey(materialType)) {
                    materialDataModelVO = (MaterialDataModelVO)materialTypeMap.get(materialType);
                    this.logger.info("\u4ecematerialTypeMap\u4e2d\u53d6\u503c\uff0c\u6b64\u65f6materialDataModelVO={}", (Object)JSONObject.toJSONString((Object)materialDataModelVO));
                }
                if (!materialTypeMap.containsKey(materialType) && !materialMap.containsKey(materialId)) {
                    materialDataModelVO.setProjectId(projectId);
                    materialDataModelVO.setProjectName(content.get((Object)"projectName") != null ? content.get((Object)"projectName").toString() : "");
                    materialDataModelVO.setMaterialTypeId(Long.valueOf(materialType));
                    materialDataModelVO.setMaterialTypeName(subContent.get((Object)materialTypeName).toString());
                    materialDataModelVO.setMaterialName(subContent.get((Object)"materialName") != null ? subContent.get((Object)"materialName").toString() : "");
                    if (subContent.get((Object)"materialId") != null) {
                        materialDataModelVO.setMaterialId(Long.valueOf(Long.parseLong(subContent.get((Object)"materialId").toString())));
                    }
                    String unitName = subContent.get((Object)unit) != null ? subContent.get((Object)unit).toString() : "";
                    String spaceName = subContent.get((Object)space) != null ? subContent.get((Object)space).toString() : "";
                    materialDataModelVO.setUnitName(unitName);
                    materialDataModelVO.setSpec(spaceName);
                    materialDataModelVO.setContractNum(BigDecimal.ZERO);
                    materialDataModelVO.setContractNumAll(BigDecimal.ZERO);
                    materialDataModelVO.setBudgetNum(BigDecimal.ZERO);
                    materialDataModelVO.setPlanNum(BigDecimal.ZERO);
                    materialDataModelVO.setApplyNum(BigDecimal.ZERO);
                    materialDataModelVO.setApplyNumAll(BigDecimal.ZERO);
                    materialDataModelVO.setInstoreNum(BigDecimal.ZERO);
                    materialDataModelVO.setInstoreNumAll(BigDecimal.ZERO);
                    materialDataModelVO.setSettlementNum(BigDecimal.ZERO);
                    this.logger.info("\u4ece\u5176\u4ed6\u4e2d\u53d6\u503c\uff0c\u6b64\u65f6materialDataModelVO={}", (Object)JSONObject.toJSONString((Object)materialDataModelVO));
                }
                list.add(materialDataModelVO);
            }
        }
        this.logger.info("\u6570\u636e\u6a21\u578b\u5904\u7406\u8fd4\u56de\u6570\u636e,\u6700\u540e\u7ec4\u88c5\u7ed3\u679c:{}", (Object)JSONObject.toJSONString(list));
        return list;
    }

    private boolean isMaterialTypeFlag(String billTypeCode) {
        return DataModelEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode().equals(billTypeCode) || DataModelEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u53d8\u66f4.getCode().equals(billTypeCode) || DataModelEnum.\u7269\u8d44\u603b\u8ba1\u5212.getCode().equals(billTypeCode) || DataModelEnum.\u7269\u8d44\u603b\u8ba1\u5212\u53d8\u66f4.getCode().equals(billTypeCode);
    }
}

