/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.delivery.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.delivery.bean.MaterialDeliveryDetailEntity;
import com.ejianc.business.delivery.bean.MaterialDeliveryEntity;
import com.ejianc.business.delivery.enums.StoreStatusEnum;
import com.ejianc.business.delivery.service.IMaterialDeliveryService;
import com.ejianc.business.delivery.vo.MaterialDeliveryDetailVO;
import com.ejianc.business.delivery.vo.MaterialDeliveryVO;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"materialDelivery"})
@Api(value="\u6d88\u8017\u6750\u9001\u8d27\u5355", tags={"\u6d88\u8017\u6750\u9001\u8d27\u5355"})
public class MaterialDeliveryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialDeliveryService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMaterialContractService contractService;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialDeliveryVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody MaterialDeliveryVO saveOrUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveDeliver(saveOrUpdateVO));
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialDeliveryVO> queryDetail(@RequestParam Long id) {
        MaterialDeliveryEntity entity = (MaterialDeliveryEntity)((Object)this.service.selectById(id));
        MaterialDeliveryVO vo = (MaterialDeliveryVO)BeanMapper.map((Object)((Object)entity), MaterialDeliveryVO.class);
        MaterialContractEntity contract = (MaterialContractEntity)((Object)this.contractService.getById(vo.getContractId()));
        if (contract != null) {
            vo.setTaxRate(ComputeUtil.toBigDecimal((Double)contract.getTaxRate()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialDeliveryVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialDeliveryVO materialDeliveryVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialDeliveryVO>> queryList(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", this.service.queryDeliverList(param));
    }

    @ApiOperation(value="\u67e5\u8be2\u5f85\u5165\u5e93\u5217\u8868")
    @RequestMapping(value={"/queryApproveList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialDeliveryVO>> queryApproveList(@RequestBody QueryParam param) {
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("storeStatus", new Parameter("ne", (Object)StoreStatusEnum.FULL_STORE.getCode()));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", this.service.queryDeliverList(param));
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialDelivery-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refMaterialDeliveryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialDeliveryVO>> refMaterialDeliveryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialDeliveryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u4fee\u6539\u9001\u8d27\u5355\u72b6\u6001")
    @RequestMapping(value={"/saveMaterialDeliveryState"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> saveMaterialDeliveryState(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody MaterialDeliveryVO saveOrUpdateVO) {
        return CommonResponse.success((String)"\u4fee\u6539\u9001\u8d27\u5355\u72b6\u6001\u6210\u529f\uff01", (Object)this.service.updateDeliverState(saveOrUpdateVO));
    }

    @ApiOperation(value="\u521d\u59cb\u5316\u9001\u8d27\u5355\u8be6\u60c5")
    @RequestMapping(value={"/queryInitDelivery"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialDeliveryVO> queryInitDelivery(@RequestParam Long orderId) {
        return CommonResponse.success((String)"\u521d\u59cb\u5316\u6210\u529f\uff01", (Object)this.service.queryInitDelivery(orderId));
    }

    @ApiOperation(value="\u63d0\u4ea4\u63a8\u9001\u6570\u636e\u65b9\u6cd5")
    @RequestMapping(value={"/saveCommitAfter"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialDeliveryVO> saveCommitAfter(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody MaterialDeliveryVO saveOrUpdateVO) {
        return CommonResponse.success((String)"\u53d1\u9001\u6210\u529f\uff01", (Object)this.service.saveCommitAfter(saveOrUpdateVO.getId()));
    }

    @RequestMapping(value={"/referMaterialDeliveryTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> referMaterialDeliveryTree(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam String condition) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)condition) || !condition.contains("projectId") || !condition.contains("contractId")) {
            throw new BusinessException("\u67e5\u8be2\u53c2\u6570\u4e0d\u6b63\u786e\uff01");
        }
        JSONObject conditionJson = JSONObject.parseObject((String)condition);
        Long contractId = conditionJson.getLong("contractId");
        Long projectId = conditionJson.getLong("projectId");
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("createTime", "desc");
        if (null != projectId) {
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        if (null != contractId) {
            queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        }
        queryParam.setOrderMap(orderMap);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("brandName");
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List list = this.service.queryList(queryParam, false);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (MaterialDeliveryEntity entity : list) {
            QueryParam param = new QueryParam();
            param.getParams().put("deliveryId", new Parameter("eq", (Object)entity.getId()));
            List<MaterialDeliveryDetailVO> detailList = this.service.querySubData(null, param);
            if (CollectionUtils.isEmpty(detailList)) continue;
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("extdata", null);
            map.put("isLeaf", true);
            map.put("selectable", true);
            map.put("key", entity.getId());
            map.put("name", entity.getDeliverName() + DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getArriveDate()) + "\u53d1\u8d27\u5355");
            map.put("code", entity.getBillCode());
            map.put("parentId", null);
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @RequestMapping(value={"/refMaterialDeliveryDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialDeliveryDetailVO>> refMaterialDeliveryDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String relyCondition, @RequestParam(required=false) String condition, String relyNode, String searchText, @RequestParam(required=false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("model");
        fuzzyFields.add("unit");
        fuzzyFields.add("brandName");
        Map param = queryParam.getParams();
        String deliveryId = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            deliveryId = _con.getString("deliveryId");
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)relyCondition)) {
            deliveryId = relyCondition.split("=")[1];
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty(deliveryId)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u53d1\u8d27\u5355\uff01");
        }
        param.put("deliveryId", new Parameter("eq", (Object)deliveryId));
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            for (String key : search.keySet()) {
                queryParam.getParams().put(key, new Parameter("like", (Object)search.get((Object)key).toString()));
            }
        }
        Page pageData = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        List<MaterialDeliveryDetailVO> list = this.service.querySubData((IPage<MaterialDeliveryDetailEntity>)pageData, queryParam);
        Page voPage = null;
        if (pageData != null) {
            voPage = new Page();
            voPage.setCurrent(pageData.getCurrent());
            voPage.setPages(pageData.getPages());
            voPage.setTotal(pageData.getTotal());
            voPage.setSize((long)queryParam.getPageSize());
            voPage.setRecords(list);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u8868\u53c2\u7167\u6210\u529f", voPage);
    }
}

