/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.MaterialContractDetailSubEntity;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IMaterialContractDetailSubService;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/contractMaterialDetail/"})
public class ContractMaterialDetailController {
    @Autowired
    private IMaterialContractDetailSubService materialContractDetailSubService;
    @Autowired
    private IInstoreService iInstoreService;

    @GetMapping(value={"contractMaterialDetailListRefer"})
    public CommonResponse<IPage<MaterialContractDetailSubEntity>> contractMaterialDetailListRefer(@RequestParam(required=false) String condition, @RequestParam(required=false) String searchText, @RequestParam int pageSize, @RequestParam int pageNumber, @RequestParam(required=false) String searchObject) {
        Map conditionMap;
        QueryParam queryParam = new QueryParam();
        queryParam.getFuzzyFields().add("material_name");
        queryParam.getFuzzyFields().add("spec");
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            queryParam.setSearchText(searchText);
        }
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            if (search.get((Object)"materialTypeName") != null) {
                queryParam.getParams().put("materialTypeName", new Parameter("like", (Object)search.get((Object)"materialTypeName").toString()));
            }
            if (search.get((Object)"materialName") != null) {
                queryParam.getParams().put("materialName", new Parameter("like", (Object)search.get((Object)"materialName").toString()));
            }
            if (search.get((Object)"spec") != null) {
                queryParam.getParams().put("spec", new Parameter("like", (Object)search.get((Object)"spec").toString()));
            }
            if (search.get((Object)"measureUnit") != null) {
                queryParam.getParams().put("measureUnit", new Parameter("like", (Object)search.get((Object)"measureUnit").toString()));
            }
        }
        Long contractId = null;
        if (StringUtils.isNotBlank((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("contractId")) {
            contractId = Long.valueOf(conditionMap.get("contractId").toString());
        }
        if (null == contractId) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5408\u540c\u5217\u8868\u5931\u8d25\uff0c\u5408\u540c\u4e3b\u952e\u4e3a\u5fc5\u4f20\u53c2\u6570\uff01");
        }
        queryParam.getParams().put("residualQuantity", new Parameter("gt", (Object)0));
        Page pageData = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        List<MaterialContractDetailSubEntity> materialContractDetailSubEntities = this.materialContractDetailSubService.queryResidualQuantity((IPage<MaterialContractDetailSubEntity>)pageData, queryParam, contractId);
        for (MaterialContractDetailSubEntity entity : materialContractDetailSubEntities) {
            entity.setTotalAmount(ComputeUtil.safeMultiply((BigDecimal)entity.getResidualQuantity(), (BigDecimal)entity.getUnitPrice()));
        }
        Page voPage = null;
        if (materialContractDetailSubEntities != null) {
            voPage = new Page();
            voPage.setCurrent(pageData.getCurrent());
            voPage.setPages(pageData.getPages());
            voPage.setTotal(pageData.getTotal());
            voPage.setSize((long)queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(materialContractDetailSubEntities, MaterialContractDetailSubEntity.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u5217\u8868\u6210\u529f\uff01", voPage);
    }

    @GetMapping(value={"contractMaterialDetailListSettleRefer"})
    public CommonResponse<IPage<MaterialContractDetailSubEntity>> contractMaterialDetailListSettleRefer(@RequestParam(required=false) String condition, @RequestParam(required=false) String searchText, @RequestParam int pageSize, @RequestParam int pageNumber, @RequestParam(required=false) String searchObject) {
        Map conditionMap;
        QueryParam queryParam = new QueryParam();
        queryParam.getFuzzyFields().add("material_name");
        queryParam.getFuzzyFields().add("spec");
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            queryParam.setSearchText(searchText);
        }
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            if (search.get((Object)"materialTypeName") != null) {
                queryParam.getParams().put("materialTypeName", new Parameter("like", (Object)search.get((Object)"materialTypeName").toString()));
            }
            if (search.get((Object)"materialName") != null) {
                queryParam.getParams().put("materialName", new Parameter("like", (Object)search.get((Object)"materialName").toString()));
            }
            if (search.get((Object)"spec") != null) {
                queryParam.getParams().put("spec", new Parameter("like", (Object)search.get((Object)"spec").toString()));
            }
            if (search.get((Object)"measureUnit") != null) {
                queryParam.getParams().put("measureUnit", new Parameter("like", (Object)search.get((Object)"measureUnit").toString()));
            }
        }
        Long contractId = null;
        if (StringUtils.isNotBlank((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("contractId")) {
            contractId = Long.valueOf(conditionMap.get("contractId").toString());
        }
        if (null == contractId) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5408\u540c\u5217\u8868\u5931\u8d25\uff0c\u5408\u540c\u4e3b\u952e\u4e3a\u5fc5\u4f20\u53c2\u6570\uff01");
        }
        queryParam.getParams().put("material_contract_id", new Parameter("eq", contractId));
        IPage pageData = this.materialContractDetailSubService.queryPage(queryParam, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u5217\u8868\u6210\u529f\uff01", (Object)pageData);
    }
}

