/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.material.bean.UseApplyEntity;
import com.ejianc.business.material.bean.UseApplySubEntity;
import com.ejianc.business.material.mapper.UseApplyMapper;
import com.ejianc.business.material.mapper.UseApplySubMapper;
import com.ejianc.business.material.service.IOutStoreSubService;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.service.impl.InstoreMaterialService;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.MaterialApplyCountVO;
import com.ejianc.business.material.vo.OutStoreSubVO;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.PurchaseOrderDetailVO;
import com.ejianc.business.material.vo.UseApplyFinishVO;
import com.ejianc.business.material.vo.UseApplySubVO;
import com.ejianc.business.material.vo.UseApplyVO;
import com.ejianc.business.plan.mapper.MaterialMasterPlanMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanSubMapper;
import com.ejianc.business.utils.BigDecimalUtils;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UseApplyService
extends BaseServiceImpl<UseApplyMapper, UseApplyEntity>
implements IUseApplyService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    public IOutStoreSubService outStoreSubService;
    @Autowired
    public IPayContractApi payContractApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private MaterialMasterPlanMapper materialMasterPlanMapper;
    @Autowired
    private MaterialMasterPlanSubMapper materialMasterPlanSubMapper;
    @Autowired
    private UseApplyMapper useApplyMapper;
    @Autowired
    private UseApplySubMapper useApplySubMapper;
    @Autowired
    private InstoreMaterialService instoreMaterialService;
    private static String PARAM_PLAN_ALL_COUNT = "P-F8k54925";
    private static String PARAM_PLAN_PRICE = "P-649dG759";
    private static String PARAM_PROJECT_MNY = "P-w112KG65";
    private static String PARAM_COST_MNY = "P-AQ725A75";
    private static String PARAM_BATCH_PLAN_NUM = "P-q4fR4e66";

    @Override
    public IPage<UseApplyVO> queryForList(QueryParam queryParam, boolean isEs) {
        Page voPage = null;
        IPage entityPage = super.queryPage(queryParam, isEs);
        if (entityPage != null) {
            voPage = new Page();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize((long)queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList((Iterable)entityPage.getRecords(), UseApplyVO.class));
        }
        return voPage;
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public ParamsCheckVO checkAllParams(UseApplyVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        List<UseApplySubVO> useApplySubEntities = vo.getUseApplySubEntities();
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap paramsCheckVOMap = new HashMap();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType(paramsArray[0]);
        if (CollectionUtils.isNotEmpty(useApplySubEntities) && (int)useApplySubEntities.stream().filter(in -> in.getMaterialId() != null).count() > 0) {
            useApplySubEntities = useApplySubEntities.stream().filter(in -> in.getMaterialId() != null).collect(Collectors.toList());
            CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_ALL_COUNT, curOrgId);
            if (!response.isSuccess()) {
                throw new BusinessException("\u3010\u603b\u8ba1\u5212\u3011\u63a7\u5236\u3010\u9879\u76ee\u7528\u6599\u7533\u8bf7\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
            }
            List billParamVOS = (List)response.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS)) {
                Long projectId = vo.getProjectId();
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"project_id", (Object)projectId);
                wrapper.eq((Object)"dr", (Object)0);
                List materialMasterPlanEntities = this.materialMasterPlanMapper.selectList((Wrapper)wrapper);
                QueryWrapper planSubWrapper = new QueryWrapper();
                ArrayList<Long> ids = new ArrayList<Long>();
                materialMasterPlanEntities.forEach(item -> ids.add(item.getId()));
                ids.add(1L);
                planSubWrapper.in((Object)"material_master_plan_id", ids);
                planSubWrapper.eq((Object)"dr", (Object)0);
                List materialMasterPlanSubEntities = this.materialMasterPlanSubMapper.selectList((Wrapper)planSubWrapper);
                HashMap planMap = new HashMap();
                materialMasterPlanSubEntities.forEach(item -> {
                    Double num = item.getNum();
                    if (planMap.get(item.getMaterialId()) != null) {
                        planMap.put(item.getMaterialId(), ComputeUtil.safeAdd((BigDecimal)BigDecimal.valueOf(num), (BigDecimal)((BigDecimal)planMap.get(item.getMaterialId()))));
                    } else {
                        planMap.put(item.getMaterialId(), BigDecimal.valueOf(num));
                    }
                });
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 == billParamVO.getControlType()) continue;
                    BigDecimal manageRate = billParamVO.getRoleValue();
                    QueryWrapper appWrapper = new QueryWrapper();
                    appWrapper.eq((Object)"project_id", (Object)projectId);
                    appWrapper.eq((Object)"dr", (Object)0);
                    List useApplyEntities = this.useApplyMapper.selectList((Wrapper)appWrapper);
                    ids.clear();
                    useApplyEntities.forEach(item -> ids.add(item.getId()));
                    ArrayList noIds = new ArrayList();
                    useApplySubEntities.forEach(item -> {
                        if (item.getId() != null) {
                            noIds.add(item.getId());
                        }
                    });
                    ids.add(1L);
                    QueryWrapper appSubWrapper = new QueryWrapper();
                    appSubWrapper.in((Object)"pid", ids);
                    appSubWrapper.notIn((Object)"id", noIds);
                    appSubWrapper.eq((Object)"dr", (Object)0);
                    appSubWrapper.ne((Object)"task_state", (Object)"back");
                    List useApplySubEntities1 = this.useApplySubMapper.selectList((Wrapper)appSubWrapper);
                    List useApplySubEntities2 = BeanMapper.mapList(useApplySubEntities, UseApplySubEntity.class);
                    HashMap<Long, UseApplySubEntity> thisMap = new HashMap<Long, UseApplySubEntity>();
                    useApplySubEntities2.forEach(item -> {
                        if (thisMap.containsKey(item.getMaterialId())) {
                            UseApplySubEntity useApplySubEntity = (UseApplySubEntity)((Object)((Object)thisMap.get(item.getMaterialId())));
                            useApplySubEntity.setApplyNum(ComputeUtil.nullToZero((BigDecimal)ComputeUtil.safeAdd((BigDecimal)useApplySubEntity.getApplyNum(), (BigDecimal)item.getApplyNum())));
                        } else {
                            thisMap.put(item.getMaterialId(), (UseApplySubEntity)((Object)item));
                        }
                    });
                    HashMap oldAppMap = new HashMap();
                    useApplySubEntities1.forEach(item -> {
                        BigDecimal applyNum = item.getApplyNum();
                        if (oldAppMap.containsKey(item.getMaterialId())) {
                            BigDecimal bigDecimal = (BigDecimal)oldAppMap.get(item.getMaterialId());
                            oldAppMap.put(item.getMaterialId(), ComputeUtil.nullToZero((BigDecimal)ComputeUtil.safeAdd((BigDecimal)applyNum, (BigDecimal)bigDecimal)));
                        } else {
                            oldAppMap.put(item.getMaterialId(), applyNum);
                        }
                    });
                    thisMap.forEach((k, item) -> {
                        BigDecimal appNumber;
                        Long materialId = item.getMaterialId();
                        BigDecimal applyNum = item.getApplyNum();
                        BigDecimal oldApplyNum = oldAppMap.get(materialId) == null ? BigDecimal.ZERO : (BigDecimal)oldAppMap.get(materialId);
                        BigDecimal planNum = planMap.get(materialId) == null ? BigDecimal.ZERO : (BigDecimal)planMap.get(materialId);
                        BigDecimal planNumber = planNum.multiply(manageRate).divide(BigDecimal.valueOf(100L));
                        if (planNumber.compareTo(appNumber = ComputeUtil.nullToZero((BigDecimal)ComputeUtil.safeAdd((BigDecimal)oldApplyNum, (BigDecimal)applyNum))) == -1) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(item.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)item.getModel()) ? " [" + item.getModel() + "]" : ""));
                            paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u7533\u8bf7\u6570\u91cf\u8d85\u51fa\u603b\u8ba1\u5212*\u6bd4\u4f8b");
                            paramsCheckDsVO.setContent("\u672c\u6b21\u7533\u8bf7\u6570\u91cf:" + applyNum.setScale(2, 4) + ",\u7d2f\u8ba1\u5df2\u7533\u8bf7\u6570\u91cf" + oldApplyNum.setScale(2, 4) + ",\u603b\u8ba1\u5212\u6570\u91cf" + planNum.setScale(2, 4) + ",\u603b\u8ba1\u5212\u6570\u91cf\u6bd4\u4f8b" + manageRate.setScale(2, 4) + "%,\u8d85\u989d" + appNumber.subtract(planNumber).setScale(2, 4));
                            UseApplyService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    });
                }
            }
        }
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            pc.setWarnType("alert");
            pc.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            pc.setWarnType("warn");
            pc.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    @Override
    public CommonResponse<UseApplyVO> getSumNumCommon(UseApplyVO vo) {
        List<UseApplySubVO> useApplySubEntities = vo.getUseApplySubEntities();
        Map<Long, List<UseApplySubVO>> listMap = useApplySubEntities.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.groupingBy(UseApplySubVO::getMaterialId));
        HashMap numMap = new HashMap();
        listMap.forEach((k, v) -> numMap.put(k, v.stream().filter(s -> s.getApplyNum() != null).map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add)));
        ArrayList<Long> materialIds = new ArrayList<Long>(listMap.keySet());
        if (CollectionUtils.isEmpty(materialIds)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u7269\u8d44\u7d2f\u8ba1\u91cf,\u8fdb\u5ea6\u91cf,\u603b\u91cf\u6210\u529f!", (Object)((Object)vo));
        }
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        queryParam.put("projectId", vo.getProjectId());
        queryParam.put("pId", vo.getId());
        queryParam.put("materialIds", materialIds);
        List<UseApplySubVO> useApplySubVOS = ((UseApplyMapper)this.baseMapper).countApplyNumCommon(queryParam);
        Long orgId = vo.getOrgId();
        List<InstoreMaterialVO> instoreMaterialVOList = null;
        if (orgId != null) {
            instoreMaterialVOList = this.instoreMaterialService.storeNumCount(orgId, materialIds);
        }
        if (CollectionUtils.isNotEmpty(useApplySubEntities)) {
            Map<Object, Object> storeNumMap = new HashMap();
            if (CollectionUtils.isNotEmpty(instoreMaterialVOList)) {
                storeNumMap = instoreMaterialVOList.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.groupingBy(k -> String.valueOf(k.getMaterialId()), Collectors.reducing(BigDecimal.ZERO, InstoreMaterialVO::getStoreNum, ComputeUtil::safeAdd)));
            }
            Map<String, BigDecimal> level3Map = useApplySubVOS.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.groupingBy(k -> String.valueOf(k.getMaterialId()), Collectors.reducing(BigDecimal.ZERO, UseApplySubVO::getApplyNum, ComputeUtil::safeAdd)));
            Map<Object, Object> sumAppluNumMap = new HashMap();
            if (CollectionUtils.isNotEmpty(useApplySubEntities)) {
                sumAppluNumMap = useApplySubEntities.stream().collect(Collectors.groupingBy(k -> String.valueOf(k.getMaterialId()), Collectors.reducing(BigDecimal.ZERO, UseApplySubVO::getApplyNum, ComputeUtil::safeAdd)));
            }
            for (UseApplySubVO d : useApplySubEntities) {
                String materialId = String.valueOf(d.getMaterialId());
                if (materialId == null) continue;
                BigDecimal applyed = level3Map.get(materialId);
                BigDecimal thisAddApplyed = ComputeUtil.safeAdd((BigDecimal)applyed, (BigDecimal)d.getApplyNum());
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("projectId", vo.getProjectId());
                param.put("materialId", d.getMaterialId());
                List<OutStoreSubVO> outStoreSubVOS = this.outStoreSubService.queryReturnGoodsMaterialNum(param);
                Map<String, BigDecimal> outStoreMap = outStoreSubVOS.stream().collect(Collectors.groupingBy(k -> String.valueOf(k.getMaterialId()) + (k.getBrandId() != null ? k.getBrandId() : ""), Collectors.reducing(BigDecimal.ZERO, OutStoreSubVO::getOutStoreNumber, ComputeUtil::safeAdd)));
                BigDecimal returnGoodsNum = outStoreMap.get(materialId);
                applyed = BigDecimalUtils.safeSub((BigDecimal)applyed, (BigDecimal)returnGoodsNum);
                if (applyed.compareTo(BigDecimal.ZERO) < 0) {
                    applyed = new BigDecimal(0);
                }
                if ((thisAddApplyed = ComputeUtil.safeAdd((BigDecimal)applyed, (BigDecimal)((BigDecimal)sumAppluNumMap.get(materialId)))).compareTo(BigDecimal.ZERO) < 0) {
                    thisAddApplyed = new BigDecimal(0);
                }
                d.setOrderNum(ComputeUtil.nullToZero((BigDecimal)thisAddApplyed));
                d.setSumApplyNum(ComputeUtil.nullToZero((BigDecimal)applyed));
                d.setStoreNum(ComputeUtil.nullToZero((BigDecimal)((BigDecimal)storeNumMap.get(materialId))));
                d.setIsFinish(0);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u7269\u8d44\u7d2f\u8ba1\u91cf,\u8fdb\u5ea6\u91cf,\u603b\u91cf\u6210\u529f!", (Object)((Object)vo));
    }

    @Override
    public List<UseApplyFinishVO> materialFinishCount(Map<String, Object> queryParam) {
        return ((UseApplyMapper)this.baseMapper).materialFinishCount(queryParam);
    }

    @Override
    public List<MaterialApplyCountVO> queryMaterialApplyCount(Long projectId, List<Long> materialIds) {
        return ((UseApplyMapper)this.baseMapper).queryMaterialApplyCount(projectId, materialIds);
    }

    @Override
    public List<UseApplySubEntity> queryAllApplyData(IPage<UseApplySubEntity> pageData, QueryParam queryParam, Long projectId) {
        QueryWrapper wrapper = UseApplyService.changeToQueryWrapper((QueryParam)queryParam);
        List<UseApplySubEntity> list = ((UseApplyMapper)this.baseMapper).queryAllApplyData(pageData, wrapper, projectId);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryApplySubList(IPage<UseApplySubEntity> pageData, QueryParam queryParam) {
        QueryWrapper wrapper = UseApplyService.changeToQueryWrapper((QueryParam)queryParam);
        List<UseApplySubEntity> list = ((UseApplyMapper)this.baseMapper).queryApplySubList(pageData, wrapper);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryAllApplyDataForPurchaseOrder(IPage<UseApplySubEntity> pageData, QueryParam queryParam, Long projectId) {
        QueryWrapper wrapper = UseApplyService.changeToQueryWrapper((QueryParam)queryParam);
        List<UseApplySubEntity> list = ((UseApplyMapper)this.baseMapper).queryAllApplyDataForPurchaseOrder(pageData, wrapper, projectId);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryApplySubListForPurchaseOrder(IPage<UseApplySubEntity> pageData, QueryParam queryParam) {
        QueryWrapper wrapper = UseApplyService.changeToQueryWrapper((QueryParam)queryParam);
        List<UseApplySubEntity> list = ((UseApplyMapper)this.baseMapper).queryApplySubListForPurchaseOrder(pageData, wrapper);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryApplySubListForInstore(IPage<UseApplySubEntity> pageData, QueryParam queryParam) {
        QueryWrapper wrapper = UseApplyService.changeToQueryWrapper((QueryParam)queryParam);
        List<UseApplySubEntity> list = ((UseApplyMapper)this.baseMapper).queryApplySubListForInstore(pageData, wrapper);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryAllApplyDataForInstore(IPage<UseApplySubEntity> pageData, QueryParam queryParam, Long projectId) {
        QueryWrapper wrapper = UseApplyService.changeToQueryWrapper((QueryParam)queryParam);
        List<UseApplySubEntity> list = ((UseApplyMapper)this.baseMapper).queryAllApplyDataForInstore(pageData, wrapper, projectId);
        return list;
    }

    @Override
    public void updatePurchaseFlag(Long id, Integer purchaseFlag) {
        if (id != null) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)id);
            updateWrapper.set(UseApplyEntity::getPurchaseFlag, (Object)purchaseFlag);
            super.update((Wrapper)updateWrapper);
        }
    }

    @Override
    public void updateSumBookNum(List<Long> applyIds) {
        ((UseApplyMapper)this.baseMapper).updateSumBookNum(applyIds);
    }

    @Override
    public void updateSumCheckNum(Long applyId) {
        ((UseApplyMapper)this.baseMapper).updateSumCheckNum(applyId);
    }

    @Override
    public List<UseApplyVO> queryOrderIssuanceList(IPage<UseApplyVO> pageData, QueryWrapper wrapper, Long employeeId, Long purchaseManagerId) {
        return ((UseApplyMapper)this.baseMapper).queryOrderIssuanceList(pageData, wrapper, employeeId, purchaseManagerId);
    }

    @Override
    public List<PurchaseOrderDetailVO> queryAssignDetail(Long applyDetailId) {
        return this.useApplyMapper.getPurchaseOrderDetail(applyDetailId);
    }

    @Override
    public List<InstoreMaterialVO> queryInstoreMaterial(Long applyDetailId, Long purchaseOrderDetailId) {
        return this.useApplyMapper.getInstoreMaterial(applyDetailId, purchaseOrderDetailId);
    }

    @Override
    public Map<Long, UseApplySubEntity> getSumBookNum(List<Long> applySubIds, List<Long> ingoreOrderDetailIds) {
        Map<Long, UseApplySubEntity> applySubEntityMap = new HashMap<Long, UseApplySubEntity>();
        List<UseApplySubEntity> list = ((UseApplyMapper)this.baseMapper).getSumBookNum(applySubIds, ingoreOrderDetailIds);
        if (CollectionUtils.isNotEmpty(list)) {
            applySubEntityMap = list.stream().collect(Collectors.toMap(BaseEntity::getId, e -> e));
        }
        return applySubEntityMap;
    }
}

