package com.ejianc.business.delivery.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.delivery.bean.MaterialDeliveryDetailEntity;
import com.ejianc.business.delivery.bean.MaterialDeliveryEntity;
import com.ejianc.business.delivery.enums.StoreStatusEnum;
import com.ejianc.business.delivery.service.IMaterialDeliveryService;
import com.ejianc.business.delivery.vo.MaterialDeliveryDetailVO;
import com.ejianc.business.delivery.vo.MaterialDeliveryVO;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 消耗材送货单
 *
 * @author generator
 */
@Controller
@RequestMapping("materialDelivery")
@Api(value = "消耗材送货单", tags = {"消耗材送货单"})
public class MaterialDeliveryController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IMaterialDeliveryService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IMaterialContractService contractService;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialDeliveryVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody MaterialDeliveryVO saveOrUpdateVO) {
        return CommonResponse.success("保存或修改单据成功！", service.saveDeliver(saveOrUpdateVO));
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialDeliveryVO> queryDetail(@RequestParam Long id) {
        MaterialDeliveryEntity entity = service.selectById(id);
        MaterialDeliveryVO vo = BeanMapper.map(entity, MaterialDeliveryVO.class);
        MaterialContractEntity contract = contractService.getById(vo.getContractId());
        if (contract != null) {
            vo.setTaxRate(ComputeUtil.toBigDecimal(contract.getTaxRate()));
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialDeliveryVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialDeliveryVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MaterialDeliveryVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialDeliveryVO>> queryList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", service.queryDeliverList(param));
    }

    @ApiOperation("查询待入库列表")
    @RequestMapping(value = "/queryApproveList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialDeliveryVO>> queryApproveList(@RequestBody QueryParam param) {
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        /** 数据隔离 本下 */
        //param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        // 过滤全部入库
        param.getParams().put("storeStatus", new Parameter(QueryParam.NE, StoreStatusEnum.FULL_STORE.getCode()));
        return CommonResponse.success("查询列表数据成功！", service.queryDeliverList(param));
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi
                .findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId)
                .collect(Collectors.toList())));
        List<MaterialDeliveryEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialDelivery-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refMaterialDeliveryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialDeliveryVO>> refMaterialDeliveryData(@RequestParam Integer pageNumber,
                                                                             @RequestParam Integer pageSize,
                                                                             String condition,
                                                                             String searchObject,
                                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MaterialDeliveryEntity> page = service.queryPage(param, false);
        IPage<MaterialDeliveryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialDeliveryVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @ApiOperation("修改送货单状态")
    @RequestMapping(value = "/saveMaterialDeliveryState", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> saveMaterialDeliveryState(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody MaterialDeliveryVO saveOrUpdateVO){
        return CommonResponse.success("修改送货单状态成功！", service.updateDeliverState(saveOrUpdateVO));
    }

    @ApiOperation("初始化送货单详情")
    @RequestMapping(value = "/queryInitDelivery", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialDeliveryVO> queryInitDelivery(@RequestParam Long orderId) {
        return CommonResponse.success("初始化成功！",service.queryInitDelivery(orderId));
    }

    @ApiOperation("提交推送数据方法")
    @RequestMapping(value = "/saveCommitAfter", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialDeliveryVO> saveCommitAfter(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody MaterialDeliveryVO saveOrUpdateVO) {
        return CommonResponse.success("发送成功！",service.saveCommitAfter(saveOrUpdateVO.getId()));
    }

    /**
     * @description: 发货单tree参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @return {@link List< Map< String, Object>>}
     * @author songlx
     * @date: 2023/4/19
     */
    @RequestMapping(value = "/referMaterialDeliveryTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> referMaterialDeliveryTree(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
            @RequestParam String condition) {
        if (StringUtils.isEmpty(condition) || !condition.contains("projectId") || !condition.contains("contractId")) {
            throw new BusinessException("查询参数不正确！");
        }
        JSONObject conditionJson = JSONObject.parseObject(condition);
        Long contractId = conditionJson.getLong("contractId");
        Long projectId = conditionJson.getLong("projectId");
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("createTime", "desc");
        if (null != projectId) {
            queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        }
        if (null != contractId) {
            queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        }
        queryParam.setOrderMap(orderMap);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("brandName");
        /** 已提交的数据 或者 审批通过的数据 */
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<MaterialDeliveryEntity> list = service.queryList(queryParam, false);
        List<Map> resultMapList = new ArrayList<>();
        Map map = null;
        for (MaterialDeliveryEntity entity : list) {
            QueryParam param = new QueryParam();
            param.getParams().put("deliveryId", new Parameter(QueryParam.EQ, entity.getId()));
            List<MaterialDeliveryDetailVO> detailList = service.querySubData(null, param);
            if (CollectionUtils.isEmpty(detailList)) {
                continue;
            }
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("extdata", null);
            map.put("isLeaf", true);
            map.put("selectable", true);
            map.put("key", entity.getId());
            map.put("name", entity.getDeliverName() + DateFormatUtil.formatDate(DateFormatUtil.PATTERN_ISO_ON_DATE, entity.getArriveDate()) + "发货单");
            map.put("code", entity.getBillCode());
            map.put("parentId", null);
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    /**
     * @description: 发货单tree-- 子表数据
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @return {@link List< Map< String, Object>>}
     * @author songlx
     * @date: 2023/4/19
     */
    @RequestMapping(value = "/refMaterialDeliveryDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialDeliveryDetailVO>> refMaterialDeliveryDetailData(@RequestParam Integer pageNumber,
            @RequestParam Integer pageSize, String relyCondition, @RequestParam(required = false) String condition,
            String relyNode, String searchText, @RequestParam(required = false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("model");
        fuzzyFields.add("unit");
        fuzzyFields.add("brandName");
        Map<String, Parameter> param = queryParam.getParams();
        String deliveryId = null;
        if(StringUtils.isNotEmpty(condition)){
            JSONObject _con = JSONObject.parseObject(condition);
            deliveryId = _con.getString("deliveryId");
        }
        if (StringUtils.isNotEmpty(relyCondition)) {
            deliveryId = relyCondition.split("=")[1];
        }
        if(StringUtils.isEmpty(deliveryId)){
            throw new BusinessException("请选择发货单！");
        }
        param.put("deliveryId", new Parameter(QueryParam.EQ, deliveryId));

        if (StringUtils.isNotBlank(searchObject)) {
            JSONObject search = JSONObject.parseObject(searchObject);
            for (String key : search.keySet()) {
                queryParam.getParams().put(key, new Parameter(QueryParam.LIKE, search.get(key).toString()));
            }
        }

        IPage<MaterialDeliveryDetailEntity> pageData = new Page<>(queryParam.getPageIndex(), queryParam.getPageSize());
        List<MaterialDeliveryDetailVO> list = service.querySubData(pageData, queryParam);

        IPage<MaterialDeliveryDetailVO> voPage = null;
        if (pageData != null) {
            voPage = new Page<>();
            voPage.setCurrent(pageData.getCurrent());
            voPage.setPages(pageData.getPages());
            voPage.setTotal(pageData.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(list);
        }
        return CommonResponse.success("查询数表参照成功", voPage);
    }
}
