package com.ejianc.business.material.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.material.bean.UseApplyEntity;
import com.ejianc.business.material.bean.UseApplySubEntity;
import com.ejianc.business.material.vo.*;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@Mapper
public interface UseApplyMapper extends BaseCrudMapper<UseApplyEntity> {


    List<UseApplySubVO> countApplyNum(Map<String, Object> queryParam);

    List<UseApplySubVO> countApplyNumCommon(Map<String, Object> queryParam);

    List<UseApplySubVO> countUseApplyNum(Map<String, Object> queryParam);

    List<UseApplySubVO> countBatchPlanNumCommon(Map<String, Object> queryParam);

    List<UseApplyFinishVO> materialFinishCount(Map<String, Object> queryParam);

    List<UseApplySubVO> queryListByMaterial(Map<String, Object> queryParam);

    List<MaterialApplyCountVO> queryMaterialApplyCount(@Param(value = "projectId") Long projectId, @Param(value = "materialIds") List<Long> materialIds);

    List<UseApplySubEntity> queryAllApplyData(IPage<UseApplySubEntity> pageData, @Param(Constants.WRAPPER) QueryWrapper wrapper, @Param(value = "projectId") Long projectId);

    List<UseApplySubEntity> queryApplySubList(IPage<UseApplySubEntity> pageData, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    List<UseApplySubEntity> queryAllApplyDataForPurchaseOrder(IPage<UseApplySubEntity> pageData, @Param(Constants.WRAPPER) QueryWrapper wrapper, @Param(value = "projectId") Long projectId);

    List<UseApplySubEntity> queryApplySubListForPurchaseOrder(IPage<UseApplySubEntity> pageData, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    List<UseApplySubEntity> queryApplySubListForInstore(IPage<UseApplySubEntity> pageData, @Param(Constants.WRAPPER) QueryWrapper wrapper);

    List<UseApplySubEntity> queryAllApplyDataForInstore(IPage<UseApplySubEntity> pageData, @Param(Constants.WRAPPER) QueryWrapper wrapper, @Param(value = "projectId") Long projectId);

    void updateSumBookNum(@Param(value = "applyIds") List<Long> applyIds);

    void updateSumCheckNum(@Param(value = "applyId") Long applyId);

    List<UseApplyVO> queryOrderIssuanceList(IPage<UseApplyVO> pageData, @Param(Constants.WRAPPER) QueryWrapper wrapper, @Param(value = "receiverId") Long receiverId, @Param(value = "purchaseManagerId") Long purchaseManagerId);

    /**
     * @description: 根据用料申请明细联查采购订单明细
     *
     * @param applyDetailId 用料申请明细id
     * @return {@link List< PurchaseOrderDetailVO>}
     * @author songlx
     * @date: 2024/6/24
     */
    List<PurchaseOrderDetailVO> getPurchaseOrderDetail(@Param(value = "applyDetailId") Long applyDetailId);

    /**
     * @description: 根据用料申请明细or采购订单明细联查收料入库明细
     *
     * @param applyDetailId 用料申请明细id
     * @param purchaseOrderDetailId 采购订单明细id
     * @return {@link List< InstoreMaterialVO>}
     * @author songlx
     * @date: 2024/6/24
     */
    List<InstoreMaterialVO> getInstoreMaterial(@Param(value = "applyDetailId") Long applyDetailId, @Param(value = "purchaseOrderDetailId") Long purchaseOrderDetailId);


    List<UseApplySubEntity> getSumBookNum(@Param(value = "applySubIds") List<Long> applySubIds, @Param(value = "ingoreOrderDetailIds") List<Long> ingoreOrderDetailIds);
}
