package com.ejianc.business.storeCheck.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.storeCheck.bean.StoreCheckEntity;
import com.ejianc.business.storeCheck.mapper.StoreCheckMapper;
import com.ejianc.business.storeCheck.mapper.StoreCheckSubMapper;
import com.ejianc.business.storeCheck.service.IStoreCheckService;
import com.ejianc.business.storeCheck.vo.StoreCheckVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author CJ
 * @Description:
 * @date 2021/3/12 16:13
 */
@Service(value = "storeCheckService")
public class StoreCheckServiceImpl extends BaseServiceImpl<StoreCheckMapper, StoreCheckEntity> implements IStoreCheckService {

    @Autowired
    private StoreCheckMapper storeCheckMapper;

    @Autowired
    private StoreCheckSubMapper storeCheckSubMapper;

    @Override
    public StoreCheckVO queryByCode(String billCode) {
        StoreCheckVO resp = null;
        QueryWrapper<StoreCheckEntity> query = new QueryWrapper<>();
        query.eq("bill_code", billCode);
        query.eq("dr", BaseVO.DR_UNDELETE);
        //带上租户id
        query.eq("tenant_id",InvocationInfoProxy.getTenantid());
        StoreCheckEntity entity = storeCheckMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, StoreCheckVO.class);
        }
        return resp;
    }

    @Override
    public StoreCheckVO queryInvalidBillByStoreId(Long storeId) {
        StoreCheckVO resp = null;
        List<Integer> billStates = new ArrayList<>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());

        QueryWrapper<StoreCheckEntity> query = new QueryWrapper<>();
        query.eq("store_id", storeId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("bill_state", billStates);
        StoreCheckEntity entity = storeCheckMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, StoreCheckVO.class);
        }
        return resp;
    }

    @Override
    public StoreCheckVO saveCheckStore(StoreCheckEntity saveEntity) {
        //更新子表信息
//        if(null != saveEntity.getId()) {
//            storeCheckSubMapper.delByStoreId(saveEntity.getId());
//        }
        super.saveOrUpdate(saveEntity, false);
        return BeanMapper.map(saveEntity, StoreCheckVO.class);
    }

    @Override
    public StoreCheckVO getLatestStoreCheck(Long storeId) {
        StoreCheckVO vo = null;
        StoreCheckEntity entity = storeCheckMapper.getLatestStoreCheck(storeId);
        if(null != entity) {
            vo = BeanMapper.map(entity, StoreCheckVO.class);
        }
        return vo;
    }
}
