/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.material.bean.ContractChangeEntity;
import com.ejianc.business.material.service.IContractChangeService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.utlis.ArchivesUtil;
import com.ejianc.business.material.vo.ContractChangeVO;
import com.ejianc.business.material.vo.ContractDetailChangeVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialInsertArchiveVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/materialContractChange/"})
public class MaterialContractChangeController {
    @Autowired
    private IContractChangeService contractChangeService;
    @Autowired
    private IMaterialContractService materialContractService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private final String DEFAULT_RULE_CODE = "materialContract";
    @Autowired
    private ArchivesUtil archivesUtil;
    @Resource
    private IMaterialApi materialApi;
    @Autowired
    private SessionManager sessionManager;

    @PostMapping(value={"saveOrUpdate"})
    public CommonResponse<ContractChangeVO> save(@RequestBody ContractChangeVO contractChangeVO) {
        List materialDetailList;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("material_contract_id", new Parameter("eq", (Object)contractChangeVO.getMaterialContractId()));
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("bill_state", new Parameter("ne", (Object)BillStateEnum.COMMITED_STATE.getBillStateCode()));
        queryParam.getComplexParams().add(c1);
        queryParam.getParams().put("bill_state", new Parameter("ne", (Object)BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryParam.getParams().put("id", new Parameter("ne", (Object)contractChangeVO.getId()));
        List list = this.contractChangeService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u5408\u540c\u5b58\u5728\u672a\u5ba1\u6279\u901a\u8fc7\u7684\u53d8\u66f4\u8bb0\u5f55\uff01");
        }
        if (StringUtils.isBlank((CharSequence)contractChangeVO.getCode())) {
            String dependOnProject = contractChangeVO.getDependOnProject();
            if ("1".equals(dependOnProject)) {
                contractChangeVO.setCode(this.getAutoCode(contractChangeVO));
            } else {
                throw new BusinessException("\u96c6\u91c7\u5408\u540c\u8bf7\u8f93\u5165\u5408\u540c\u7f16\u7801\uff01");
            }
        }
        if (StringUtils.isBlank((CharSequence)contractChangeVO.getName())) {
            BigDecimal amountWithTax;
            LinkedList<String> namelist = new LinkedList<String>();
            if (StringUtils.isNotBlank((CharSequence)contractChangeVO.getProductName())) {
                namelist.add(contractChangeVO.getProductName());
            }
            if (StringUtils.isNotBlank((CharSequence)contractChangeVO.getSupplierName())) {
                namelist.add(contractChangeVO.getSupplierName());
            }
            if (StringUtils.isNotBlank((CharSequence)contractChangeVO.getProjectCode())) {
                namelist.add(contractChangeVO.getProjectCode());
            }
            if (StringUtils.isNotBlank((CharSequence)contractChangeVO.getProjectName())) {
                namelist.add(contractChangeVO.getProjectName());
            }
            if ((amountWithTax = contractChangeVO.getAmountWithTax()) != null) {
                namelist.add(String.valueOf(ComputeUtil.scaleTwo((BigDecimal)amountWithTax)));
            }
            namelist.add(contractChangeVO.getEmployeeName());
            contractChangeVO.setName(String.join((CharSequence)"-", namelist));
        }
        String changeVersionStr = contractChangeVO.getChangeVersion() > 9 ? String.valueOf(contractChangeVO.getChangeVersion()) : "0" + contractChangeVO.getChangeVersion();
        contractChangeVO.setChangeCode("BG" + contractChangeVO.getCode() + "-" + changeVersionStr);
        boolean checkResult = this.materialContractService.codeCheck(contractChangeVO.getMaterialContractId(), contractChangeVO.getCode());
        if (!checkResult) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5408\u540c\u7f16\u7801\u91cd\u590d");
        }
        long id = IdWorker.getId();
        if (contractChangeVO.getId() == null) {
            contractChangeVO.setId(Long.valueOf(id));
        }
        if (CollectionUtils.isNotEmpty((Collection)(materialDetailList = contractChangeVO.getMaterialDetailList()))) {
            for (ContractDetailChangeVO materialContractDetailSubVO : materialDetailList) {
                String onlykey = materialContractDetailSubVO.getMaterialTypeName() + materialContractDetailSubVO.getMaterialName() + materialContractDetailSubVO.getMeasureUnit() + materialContractDetailSubVO.getSpec() + materialContractDetailSubVO.getMaterialCode();
                materialContractDetailSubVO.setOnlyKey(onlykey);
            }
            MaterialInsertArchiveVO archiveVO = new MaterialInsertArchiveVO(null, contractChangeVO.getId(), contractChangeVO.getCode(), contractChangeVO.getProjectName(), "\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u53d8\u66f4");
            JSONObject jsonObject = this.archivesUtil.batchSaveArchive(archiveVO, materialDetailList, "materialTypeId", "materialId", "materialTypeName", "materialName", "materialCode", "unit", "spec", "errorMessage");
            String sourceList = JSON.toJSONString((Object)jsonObject.get((Object)"sourceList"), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat});
            List contractDetailChangeVOS = JSONObject.parseArray((String)sourceList, ContractDetailChangeVO.class);
            contractChangeVO.setMaterialDetailList(contractDetailChangeVOS);
            List sourceIds = contractDetailChangeVOS.stream().map(contractDetailChangeVO -> Long.parseLong(contractDetailChangeVO.getMaterialId())).collect(Collectors.toList());
            List partition = Lists.partition(sourceIds, (int)300);
            ArrayList materialList = new ArrayList();
            for (int i = 0; i < partition.size(); ++i) {
                CommonResponse r = this.materialApi.queryMaterialByIds((List)partition.get(i));
                if (!r.isSuccess()) {
                    throw new BusinessException("\u4fdd\u5b58\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2\u7269\u8d44\u6863\u6848\u5931\u8d25\uff01");
                }
                materialList.addAll((Collection)r.getData());
            }
            Map materialMap = materialList.stream().collect(Collectors.toMap(MaterialVO::getId, Function.identity(), (key1, key2) -> key2));
            for (ContractDetailChangeVO detailSubVO : contractChangeVO.getMaterialDetailList()) {
                if (!materialMap.containsKey(Long.parseLong(detailSubVO.getMaterialId()))) continue;
                MaterialVO vo = (MaterialVO)materialMap.get(Long.parseLong(detailSubVO.getMaterialId()));
                String assistUnitName = vo.getAssistUnitName();
                BigDecimal unitAssistUnit = vo.getUnitAssistUnit();
                if (!StringUtils.isNotBlank((CharSequence)assistUnitName) || unitAssistUnit == null) continue;
                detailSubVO.setAssistUnitName(assistUnitName);
                detailSubVO.setUnitAssistUnit(unitAssistUnit);
                detailSubVO.setNumAssistUnit(NumberUtil.mul((Number)detailSubVO.getCount(), (Number)unitAssistUnit));
                detailSubVO.setPriceAssistUnit(NumberUtil.div((BigDecimal)detailSubVO.getTotalAmount(), (BigDecimal)detailSubVO.getNumAssistUnit(), (int)4, (RoundingMode)RoundingMode.HALF_UP));
            }
        }
        ContractChangeVO resp = this.contractChangeService.save(contractChangeVO);
        this.queryPrice(resp);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)resp);
    }

    private String getAutoCode(ContractChangeVO contractChangeVO) {
        String code = null;
        while (StringUtils.isBlank(code)) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)"materialContract", (Long)InvocationInfoProxy.getTenantid(), (BaseVO)contractChangeVO);
            CommonResponse resp = this.billCodeApi.generateBillCode(billCodeParam);
            if (!resp.isSuccess()) {
                throw new BusinessException("\u4fdd\u5b58\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u7f16\u7801\u5931\u8d25\uff01");
            }
            code = (String)resp.getData();
        }
        return code;
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<ContractChangeVO> detail(@RequestParam(value="id") Long id) {
        ContractChangeVO vo = null;
        ContractChangeEntity e = (ContractChangeEntity)((Object)this.contractChangeService.selectById(id));
        if (e != null) {
            vo = (ContractChangeVO)BeanMapper.map((Object)((Object)e), ContractChangeVO.class);
            this.queryPrice(vo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", vo);
    }

    private void queryPrice(ContractChangeVO vo) {
        List materialDetailList = vo.getMaterialDetailList();
        if (CollectionUtils.isNotEmpty((Collection)materialDetailList)) {
            MaterialPriceVO priceVO = new MaterialPriceVO(vo.getProjectId());
            ArrayList detail = new ArrayList();
            materialDetailList.forEach(item -> {
                MaterialPriceVO materialPriceVO = new MaterialPriceVO();
                materialPriceVO.setMaterialId(Long.valueOf(item.getMaterialId()));
                detail.add(materialPriceVO);
            });
            priceVO.setDetail(detail);
            Integer isJc = vo.getPurchaseMode().equals("1") ? 1 : 0;
            MaterialPriceVO materialPriceVO = this.materialContractService.queryPrice(isJc, vo.getMaterialContractId(), priceVO);
            List dd = materialPriceVO.getDetail();
            if (CollectionUtils.isNotEmpty((Collection)dd)) {
                Map<Long, MaterialPriceVO> priceVOMap = dd.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                for (ContractDetailChangeVO v : materialDetailList) {
                    String materialId = v.getMaterialId();
                    MaterialPriceVO p = priceVOMap.get(Long.valueOf(materialId));
                    if (null == p) continue;
                    v.setPlanNum(p.getPlanNum());
                    v.setPlanPrice(p.getPlanPrice());
                    v.setMinPrice(p.getMinPrice());
                    v.setMaxPrice(p.getMaxPrice());
                    v.setPriceArea(p.getPriceArea());
                }
            }
        }
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody List<ContractChangeVO> vos) {
        this.contractChangeService.deleteById(vos.get(0).getId(), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

